/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserTranslator;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;
import pojos.DataObject;
import pojos.ImageData;
import pojos.MultiImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FSFolderModel
extends DataBrowserModel {
    FSFolderModel(Object parent, Collection<DataObject> files) {
        if (files == null) {
            throw new IllegalArgumentException("No files.");
        }
        this.parent = parent;
        ArrayList<DataObject> toTransform = new ArrayList<DataObject>();
        Iterator<DataObject> i = files.iterator();
        this.numberOfImages = 0;
        while (i.hasNext()) {
            DataObject o = i.next();
            if (o instanceof ImageData) {
                toTransform.add(o);
                ++this.numberOfImages;
                continue;
            }
            if (!(o instanceof MultiImageData)) continue;
            toTransform.add(o);
            this.numberOfImages += ((MultiImageData)o).getComponents().size();
        }
        Set visTrees = DataBrowserTranslator.transformFSFolder(toTransform);
        this.browser = BrowserFactory.createBrowser(visTrees);
        this.layoutBrowser();
    }

    @Override
    protected DataBrowserLoader createDataLoader(boolean refresh, Collection ids) {
        if (refresh) {
            this.imagesLoaded = 0;
        }
        if (this.imagesLoaded != 0 && ids != null) {
            this.imagesLoaded -= ids.size();
        }
        if (this.imagesLoaded == this.numberOfImages) {
            return null;
        }
        List<ImageNode> nodes = this.browser.getVisibleImageNodes();
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        Iterator<ImageNode> i = nodes.iterator();
        ArrayList<DataObject> imgs = new ArrayList<DataObject>();
        ArrayList<Long> loaded = new ArrayList<Long>();
        if (ids != null) {
            while (i.hasNext()) {
                DataObject data;
                ImageNode node = i.next();
                if (node.getThumbnail().getFullScaleThumb() != null || !ids.contains((data = (DataObject)node.getHierarchyObject()).getId()) || loaded.contains(data.getId())) continue;
                imgs.add(data);
                loaded.add(data.getId());
                ++this.imagesLoaded;
            }
        } else {
            while (i.hasNext()) {
                ImageNode node = i.next();
                if (node.getThumbnail().getFullScaleThumb() != null) continue;
                DataObject data = (DataObject)node.getHierarchyObject();
                long id = data.getId();
                if (id > 0L) {
                    if (loaded.contains(id)) continue;
                    imgs.add(data);
                    loaded.add(id);
                    ++this.imagesLoaded;
                    continue;
                }
                if (data instanceof ImageData) {
                    imgs.add(data);
                    ++this.imagesLoaded;
                    continue;
                }
                if (!(data instanceof MultiImageData)) continue;
                List list = ((MultiImageData)data).getComponents();
                imgs.addAll(list);
                this.imagesLoaded += list.size();
            }
        }
        if (imgs.size() == 0) {
            return null;
        }
        return new ThumbnailLoader(this.component, this.sorter.sort(imgs), 2);
    }

    @Override
    protected int getType() {
        return 9;
    }

    @Override
    protected List<ImageDisplay> getNodes() {
        return null;
    }
}

