/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.ImageTable;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImageTableView
extends JPanel {
    static final String TABLE_NODES_SELECTION_PROPERTY = "tableNodesSelection";
    static final String TABLE_SELECTION_MENU_PROPERTY = "tableSelectionMenu";
    static final String TABLE_SELECTION_VIEW_PROPERTY = "tableSelectionView";
    private ImageTable table;
    private DataBrowserModel model;

    private void initComponents(ImageDisplay root) {
        this.table = new ImageTable(root, this, this.model);
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        JScrollPane pane = new JScrollPane((Component)((Object)this.table));
        pane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.add((Component)pane, "Center");
    }

    ImageTableView(DataBrowserModel model, ImageDisplay root) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.initComponents(root);
        this.buildGUI();
    }

    void showMenu(Point location) {
        this.firePropertyChange(TABLE_SELECTION_MENU_PROPERTY, null, location);
    }

    ViewerSorter getSorter() {
        return this.model.getSorter();
    }

    void refreshTable() {
        this.table.refreshTable();
    }

    void selectNodes(List<ImageDisplay> nodes) {
        this.firePropertyChange(TABLE_NODES_SELECTION_PROPERTY, null, nodes);
    }

    void setSelectedNodes(List<DataObject> objects) {
        this.table.setSelectedNodes(objects);
    }

    void viewSelectedNode() {
        this.firePropertyChange(TABLE_SELECTION_VIEW_PROPERTY, Boolean.FALSE, Boolean.TRUE);
    }

    void markUnmodifiedNodes(Class type, Collection<Long> ids) {
        this.table.markUnmodifiedNodes(type, ids);
    }
}

