/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class SlideShowCanvas
extends JComponent {
    static final String SELECT_NEXT_PROPERTY = "selectNext";
    private BufferedImage image;

    SlideShowCanvas() {
        this.setDoubleBuffered(true);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createBevelBorder(1, UIUtilities.INNER_BORDER_HIGHLIGHT, UIUtilities.INNER_BORDER_SHADOW));
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                SlideShowCanvas.this.firePropertyChange(SlideShowCanvas.SELECT_NEXT_PROPERTY, Boolean.FALSE, Boolean.TRUE);
            }
        });
    }

    void paintImage(BufferedImage image) {
        if (image == null) {
            return;
        }
        this.image = image;
        Dimension d = new Dimension(image.getWidth(), image.getHeight());
        this.setPreferredSize(d);
        this.setSize(d);
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        if (this.image == null) {
            return;
        }
        ImagePaintingFactory.setGraphicRenderingSettings(g2D);
        g2D.drawImage(this.image, null, 0, 0);
    }
}

