/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.actions.EditorAction;
import org.openmicroscopy.shoola.agents.editor.actions.SaveNewCmd;
import org.openmicroscopy.shoola.agents.editor.view.Editor;
import org.openmicroscopy.shoola.util.ui.MessageBox;

public class SaveAsProtocolAction
extends EditorAction
implements PropertyChangeListener {
    protected void onStateChange() {
        int state = this.model.getState();
        this.setEnabled(state == 3);
        if (!this.model.isExperiment()) {
            this.setEnabled(false);
        }
    }

    public SaveAsProtocolAction(Editor model) {
        super(model);
        this.setEnabled(false);
        this.setName("Save As Protocol");
        this.setDescription("Save an Experiment file as a Protocol.");
        this.setIcon(58);
        model.registerBrowserListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.model.isExperiment()) {
            return;
        }
        JFrame f = EditorAgent.getRegistry().getTaskBar().getFrame();
        MessageBox msg = new MessageBox(f, "Save As Protocol...", "This will remove the Experiment Info and any Step Notes\nand save the file as a new Protocol file.");
        msg.setYesText("OK");
        msg.setNoText("Cancel");
        int option = msg.centerMsgBox();
        if (option != 1) {
            return;
        }
        this.model.deleteExperimentInfo();
        SaveNewCmd save = new SaveNewCmd(this.model);
        save.execute();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("browserEdit".equals(name)) {
            this.onStateChange();
        }
    }
}

