/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.browser.TextToken;
import org.openmicroscopy.shoola.util.ui.BrowserLauncher;
import org.openmicroscopy.shoola.util.ui.omeeditpane.ChemicalNameFormatter;
import org.openmicroscopy.shoola.util.ui.omeeditpane.ChemicalSymbolsEditer;
import org.openmicroscopy.shoola.util.ui.omeeditpane.OMERegexFormatter;
import org.openmicroscopy.shoola.util.ui.omeeditpane.Position;
import org.openmicroscopy.shoola.util.ui.omeeditpane.WikiView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorTextComponent
extends JTextPane
implements DocumentListener {
    public static final String PARAM_REGEX = "\\[[[^\\]^\\[.].]+\\]";
    public static final String URL_REGEX = "((https?|ftp|file)://|www)[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
    private OMERegexFormatter regexFormatter;
    private ChemicalNameFormatter chemicalNameFormatter;
    private ChemicalSymbolsEditer chemicalSymbolEditer;
    private SimpleAttributeSet plainText;
    private StyledDocument doc = this.getStyledDocument();
    private List<Position> paramPositionList = new ArrayList<Position>();
    private boolean toggleSymbolEdit = true;
    private boolean hasDataToSave;
    public static final String PARAM_CREATED = "paramCreated";
    public static final String PARAM_DELETED = "paramDeleted";
    public static final String PARAM_EDITED = "paramEdited";

    private void updateParamMap(String text) {
        if (text == null) {
            this.paramPositionList.clear();
            return;
        }
        WikiView.findExpressions(text, PARAM_REGEX, this.paramPositionList);
    }

    private void populateSymbolsList() {
        String list = (String)EditorAgent.getRegistry().lookup("/model/symbols");
        String[] chemicals = list.split(",");
        for (int i = 0; i < chemicals.length; ++i) {
            String[] colonSplit = chemicals[i].split(":");
            String find = " " + colonSplit[0].trim();
            if (colonSplit.length <= 1) continue;
            String replace = " " + colonSplit[1].trim();
            this.chemicalSymbolEditer.addSymbol(find, replace);
        }
    }

    private void populateChemicalList() {
        String list = (String)EditorAgent.getRegistry().lookup("/model/chemicals");
        String[] chemicals = list.split(",");
        for (int i = 0; i < chemicals.length; ++i) {
            this.chemicalNameFormatter.addFormula(chemicals[i].trim());
        }
    }

    private void parseRegex(int caretPosition) {
        this.chemicalNameFormatter.parseRegex(this.doc, true);
        this.regexFormatter.parseRegex(this.doc, false);
        this.chemicalSymbolEditer.parseRegex(this.doc, this.toggleSymbolEdit ? caretPosition : 0);
        String text = "";
        try {
            text = this.doc.getText(0, this.doc.getLength());
        }
        catch (BadLocationException e2) {
            e2.printStackTrace();
        }
        ArrayList<Position> newPositionList = new ArrayList<Position>();
        WikiView.findExpressions(text, PARAM_REGEX, newPositionList);
        int oldParamCount = this.paramPositionList.size();
        int newParamCount = newPositionList.size();
        if (oldParamCount > newParamCount) {
            this.firePropertyChange(PARAM_CREATED, oldParamCount, newParamCount);
        } else if (oldParamCount < newParamCount) {
            this.firePropertyChange(PARAM_DELETED, oldParamCount, newParamCount);
        } else {
            int regexIndex = this.offsetParamIndex(caretPosition);
            if (regexIndex > -1) {
                Position p = (Position)newPositionList.get(regexIndex);
                String newText = "";
                try {
                    newText = this.doc.getText(p.getStart() + 1, p.getEnd() - p.getStart() - 2);
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
                this.firePropertyChange(PARAM_EDITED, null, newText);
            }
        }
        this.paramPositionList = newPositionList;
    }

    void dataEdited() {
        this.hasDataToSave = true;
    }

    void dataSaved() {
        this.hasDataToSave = false;
    }

    List<TextToken> getParamTokens() {
        ArrayList<TextToken> params = new ArrayList<TextToken>();
        for (Position p : this.paramPositionList) {
            String text;
            int start = p.getStart();
            int end = p.getEnd();
            try {
                text = this.doc.getText(start, end - start);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                text = "";
            }
            params.add(new TextToken(p.getStart(), p.getEnd(), text));
        }
        return params;
    }

    public EditorTextComponent() {
        this.plainText = new SimpleAttributeSet();
        StyleConstants.setFontFamily(this.plainText, "Arial");
        StyleConstants.setFontSize(this.plainText, 13);
        this.regexFormatter = new OMERegexFormatter(this.plainText);
        SimpleAttributeSet set = new SimpleAttributeSet();
        StyleConstants.setForeground(set, Color.blue);
        this.regexFormatter.addRegex(PARAM_REGEX, set);
        SimpleAttributeSet urlSet = new SimpleAttributeSet();
        StyleConstants.setForeground(urlSet, Color.blue);
        StyleConstants.setUnderline(urlSet, true);
        this.regexFormatter.addRegex(URL_REGEX, urlSet);
        this.chemicalNameFormatter = new ChemicalNameFormatter(this.plainText);
        this.populateChemicalList();
        this.chemicalSymbolEditer = new ChemicalSymbolsEditer(this.plainText);
        this.populateSymbolsList();
        this.getDocument().addDocumentListener(this);
        this.addMouseListener(new UrlMouseListener());
    }

    public boolean hasDataToSave() {
        return this.hasDataToSave;
    }

    public int offsetParamIndex(int offset) {
        if (offset == 0) {
            return -1;
        }
        int index = 0;
        for (Position p : this.paramPositionList) {
            if (p.contains(offset, offset)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public void setText(String text) {
        int caret = this.getCaretPosition();
        super.setText(text);
        try {
            this.setCaretPosition(caret);
        }
        catch (IllegalArgumentException ex) {
            this.setCaretPosition(0);
        }
        this.updateParamMap(text);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.parseRegex(e.getOffset());
        this.dataEdited();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.parseRegex(e.getOffset());
        this.dataEdited();
    }

    private class UrlMouseListener
    extends MouseAdapter {
        private UrlMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            Point mouseLoc = e.getPoint();
            int offset = EditorTextComponent.this.viewToModel(mouseLoc);
            if (e.getClickCount() == 2) {
                String text = "";
                try {
                    text = EditorTextComponent.this.doc.getText(0, EditorTextComponent.this.doc.getLength());
                    ArrayList<Position> urlPositionList = new ArrayList<Position>();
                    WikiView.findExpressions(text, EditorTextComponent.URL_REGEX, urlPositionList);
                    for (Position p : urlPositionList) {
                        if (!p.contains(offset, offset)) continue;
                        String link = EditorTextComponent.this.doc.getText(p.getStart(), p.getEnd() - p.getStart());
                        if (link.startsWith("www")) {
                            link = "http://" + link;
                        }
                        new BrowserLauncher().openURL(link);
                        return;
                    }
                }
                catch (BadLocationException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }
}

