/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.openmicroscopy.shoola.agents.editor.browser.TextToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlContentEditor
extends JEditorPane
implements DocumentListener {
    private boolean hasDataToSave;

    private void initialise() {
        this.setEditable(true);
        this.setBackground(null);
        this.getDocument().addDocumentListener(this);
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        doc.setPreservesUnknownTags(false);
    }

    public HtmlContentEditor() {
        super("text/html", "");
        this.initialise();
    }

    public String getElementId(int offset) {
        Document d = this.getDocument();
        if (!(d instanceof StyledDocument)) {
            return null;
        }
        StyledDocument styledDoc = (StyledDocument)d;
        Element el = styledDoc.getCharacterElement(offset);
        if (el instanceof HTMLDocument.RunElement) {
            SimpleAttributeSet sas;
            Object id;
            HTMLDocument.RunElement rE = (HTMLDocument.RunElement)el;
            Object tag = rE.getAttribute(HTML.Tag.A);
            if (tag != null && tag instanceof SimpleAttributeSet && (id = (sas = (SimpleAttributeSet)tag).getAttribute(HTML.Attribute.ID)) != null) {
                return id.toString();
            }
            tag = rE.getAttribute(HTML.Tag.SPAN);
            if (tag != null && tag instanceof SimpleAttributeSet && (id = (sas = (SimpleAttributeSet)tag).getAttribute(HTML.Attribute.ID)) != null) {
                return id.toString();
            }
        }
        return null;
    }

    public List<TextToken> getElementsByTag(HTML.Tag tag) {
        Document d = this.getDocument();
        if (!(d instanceof StyledDocument)) {
            return null;
        }
        HTMLDocument styledDoc = (HTMLDocument)d;
        ArrayList<TextToken> tokens = new ArrayList<TextToken>();
        HTMLDocument.Iterator i = styledDoc.getIterator(tag);
        while (i.isValid()) {
            AttributeSet atSet = i.getAttributes();
            Object idAttribute = atSet.getAttribute(HTML.Attribute.ID);
            int start = i.getStartOffset();
            int end = i.getEndOffset();
            try {
                String text = styledDoc.getText(start, end - start);
                String id = idAttribute == null ? null : idAttribute.toString();
                tokens.add(new TextToken(start, end, text, id));
            }
            catch (BadLocationException e) {
                // empty catch block
            }
            i.next();
        }
        return tokens;
    }

    public boolean isOffsetWithinTag(int offset, HTML.Tag tag) {
        HTMLDocument.RunElement rE;
        Object ob;
        if (offset == 0) {
            return false;
        }
        Document d = this.getDocument();
        Element el = ((StyledDocument)d).getCharacterElement(offset);
        return el instanceof HTMLDocument.RunElement && (ob = (rE = (HTMLDocument.RunElement)el).getAttribute(tag)) != null;
    }

    public void dataEdited() {
        this.hasDataToSave = true;
    }

    public void dataSaved() {
        this.hasDataToSave = false;
    }

    public boolean hasDataToSave() {
        return this.hasDataToSave;
    }

    @Override
    public void setText(String text) {
        int caret = this.getCaretPosition();
        super.setText(text);
        try {
            this.setCaretPosition(caret);
        }
        catch (IllegalArgumentException ex) {
            this.setCaretPosition(0);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.dataEdited();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.dataEdited();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.dataEdited();
    }
}

