/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.IFieldContent;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class TreeOutlineCellRenderer
extends DefaultTreeCellRenderer {
    private static final int MAX_CHARS = 25;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node;
        Object object;
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        Icon paramIcon = null;
        String toolTipText = null;
        IconManager imF = IconManager.getInstance();
        if (value instanceof DefaultMutableTreeNode && (object = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof IField) {
            IField field = (IField)object;
            toolTipText = field.getToolTipText();
            String text = TreeOutlineCellRenderer.getFieldDisplayName(field, node);
            if (field.getContentCount() < 1) {
                paramIcon = imF.getIcon(3);
            } else {
                IFieldContent content = field.getContentAt(0);
                String paramType = "TEXTBOX";
                if (content instanceof IParam) {
                    paramType = ((IParam)content).getAttribute("paramType");
                }
                if ("TEXT".equals(paramType)) {
                    paramIcon = imF.getIcon(3);
                } else if ("TEXTBOX".equals(paramType)) {
                    paramIcon = imF.getIcon(5);
                } else if ("DATE_TIME".equals(paramType)) {
                    paramIcon = imF.getIcon(14);
                } else if ("BOOLEAN".equals(paramType)) {
                    paramIcon = imF.getIcon(9);
                } else if ("ENUMERATION".equals(paramType)) {
                    paramIcon = imF.getIcon(11);
                } else if ("NUMERIC".equals(paramType)) {
                    paramIcon = imF.getIcon(12);
                }
            }
            this.setText(text);
        }
        this.setIcon(paramIcon);
        if (toolTipText != null && toolTipText.trim().length() > 0) {
            toolTipText = UIUtilities.formatToolTipText(toolTipText);
            this.setToolTipText(toolTipText);
        }
        return this;
    }

    public static String getFieldDisplayName(IField field, DefaultMutableTreeNode node) {
        String text = field.getAttribute("fieldName");
        if (text == null) {
            text = TreeModelMethods.getNodeName(node);
        }
        if (text.length() > 25) {
            text = text.substring(0, 24) + "..";
        }
        return text;
    }
}

