/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.actions;

import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.undo.UndoableEditSupport;
import org.openmicroscopy.shoola.agents.editor.browser.Browser;
import org.openmicroscopy.shoola.agents.editor.browser.actions.BrowserAction;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.TreeEdit;

public abstract class AbstractTreeEditAction
extends BrowserAction
implements TreeSelectionListener,
TreeEdit {
    protected JTree treeUI;
    protected UndoableEditSupport undoSupport;

    protected void refreshState() {
        int state = this.model.getEditingMode();
        if (this.model.isFileLocked() || state == 2) {
            this.setEnabled(false);
        } else if (this.treeUI == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.canDo());
        }
    }

    protected abstract boolean canDo();

    protected void onStateChange() {
        this.refreshState();
    }

    public AbstractTreeEditAction(UndoableEditSupport undoSupport, Browser model) {
        super(model);
        this.undoSupport = undoSupport;
    }

    public void setTree(JTree tree) {
        if (tree == null) {
            return;
        }
        if (this.treeUI != null) {
            this.treeUI.removeTreeSelectionListener(this);
        }
        this.treeUI = tree;
        this.treeUI.addTreeSelectionListener(this);
        this.refreshState();
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.refreshState();
    }
}

