/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.actions;

import java.awt.event.ActionEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.browser.Browser;
import org.openmicroscopy.shoola.agents.editor.browser.actions.BrowserAction;
import org.openmicroscopy.shoola.agents.editor.browser.undo.UndoRedoListener;
import org.openmicroscopy.shoola.agents.editor.browser.undo.UndoRedoObservable;

public class UndoEditAction
extends BrowserAction
implements UndoableEditListener,
UndoRedoListener {
    private UndoManager undoManager;

    public UndoEditAction(UndoManager undoManager, UndoableEditSupport undoSupport, Browser model) {
        super(model);
        this.undoManager = undoManager;
        undoSupport.addUndoableEditListener(this);
        if (undoManager instanceof UndoRedoObservable) {
            ((UndoRedoObservable)((Object)undoManager)).addUndoRedoListener(this);
        }
        this.putValue("Name", "Undo");
        this.putValue("SmallIcon", IconManager.getInstance().getIcon(47));
        this.refreshStatus();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        this.refreshStatus();
    }

    public void undoRedoPerformed() {
        this.refreshStatus();
    }

    protected void onStateChange() {
        this.refreshStatus();
    }

    private void refreshStatus() {
        boolean enabled = this.model.isFileLocked() ? false : this.undoManager.canUndo();
        this.setEnabled(enabled);
        this.setDescription(enabled ? this.undoManager.getUndoPresentationName() : "Can't Undo");
    }
}

