/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs;

import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.AbstractParamEditor;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomTextField;
import org.openmicroscopy.shoola.agents.editor.uiComponents.DropDownMenu;
import org.openmicroscopy.shoola.agents.editor.util.Ontologies;
import org.openmicroscopy.shoola.util.ui.HistoryDialog;

public class OntologyTermEditor
extends AbstractParamEditor
implements PropertyChangeListener,
DocumentListener {
    private DropDownMenu ontologyChooser;
    private JTextComponent termSelector;
    HistoryDialog popup;

    private void initialise() {
        String[] ontologyList = Ontologies.getInstance().getOntologyNameList();
        this.ontologyChooser = new DropDownMenu(ontologyList);
        this.ontologyChooser.addPropertyChangeListener("itemSelection", this);
        this.termSelector = new CustomTextField(250);
    }

    private void buildUI() {
        this.add(this.ontologyChooser);
        this.add(this.termSelector);
        IAttributes param = this.getParameter();
        String ontologyID = param.getAttribute("ontolgoyId");
        String termID = param.getAttribute("termId");
        String termName = param.getAttribute("termName");
        if (ontologyID != null) {
            this.ontologyChooser.setText(ontologyID);
        } else {
            this.ontologyChooser.setText("Ontology");
        }
        if (termID != null) {
            this.termSelector.setText(ontologyID + ":" + termID + "   " + (termName == null ? "" : termName));
        }
        this.termSelector.getDocument().addDocumentListener(this);
    }

    private void autoComplete() {
        Rectangle rect = this.termSelector.getBounds();
        String text = this.termSelector.getText();
        if (text.length() < 3) {
            return;
        }
        String ontologyID = this.ontologyChooser.getText();
        if (ontologyID == null || ontologyID.length() == 0) {
            return;
        }
        Object[] matchingTerms = Ontologies.getTermsByName(text, ontologyID);
        if (matchingTerms.length == 0) {
            return;
        }
        this.popup = new HistoryDialog(matchingTerms, 300);
        this.popup.addPropertyChangeListener("selection", this);
        this.popup.show(this.ontologyChooser, 0, rect.height);
        this.termSelector.requestFocusInWindow();
    }

    public OntologyTermEditor(IAttributes param) {
        super(param);
        this.initialise();
        this.buildUI();
    }

    public String getEditDisplayName() {
        return "Ontology Term";
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.ontologyChooser.equals(evt.getSource())) {
            String ontology = evt.getNewValue() + "";
            String ontologyID = Ontologies.getOntologyIdFromOntology(ontology);
            HashMap<String, String> newTerm = new HashMap<String, String>();
            newTerm.put("ontolgoyId", ontologyID);
            newTerm.put("termId", null);
            newTerm.put("termName", null);
            this.ontologyChooser.setText(ontologyID);
            this.termSelector.setText("");
            this.firePropertyChange("sizeChangedPropery", null, null);
            this.attributeEdited("ontolgoyId", newTerm);
            return;
        }
        if (this.popup.equals(evt.getSource())) {
            String term = this.popup.getSelectedTextValue() + "";
            String termID = Ontologies.getTermIdFromB3(term);
            String termName = Ontologies.getTermNameFromB3(term);
            HashMap<String, String> newTerm = new HashMap<String, String>();
            newTerm.put("termId", termID);
            newTerm.put("termName", termName);
            this.termSelector.getDocument().removeDocumentListener(this);
            this.termSelector.setText(this.popup.getSelectedTextValue() + "");
            this.termSelector.getDocument().addDocumentListener(this);
            this.firePropertyChange("sizeChangedPropery", null, null);
            this.attributeEdited("termId", newTerm);
            return;
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.autoComplete();
    }

    public void insertUpdate(DocumentEvent e) {
        this.autoComplete();
    }

    public void removeUpdate(DocumentEvent e) {
        this.autoComplete();
    }
}

