/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.AbstractParamEditor;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.AttributeEditListeners;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomFont;

public class TextBoxEditor
extends AbstractParamEditor {
    private JTextArea textBox;
    private String attributeName;

    private void initialise() {
        String text = this.getParameter().getAttribute(this.attributeName);
        this.textBox = new JTextArea(text);
        this.textBox.setLineWrap(true);
        this.textBox.setColumns(40);
        this.textBox.setFont(new CustomFont());
        this.textBox.setWrapStyleWord(true);
        Border bevelBorder = BorderFactory.createLoweredBevelBorder();
        Border emptyBorder = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(bevelBorder, emptyBorder);
        this.textBox.setBorder(compoundBorder);
        int lines = this.textBox.getLineCount();
        int extraLines = 0;
        int lineLength = 0;
        int lineStartOffset = 0;
        for (int l = 0; l < lines; ++l) {
            try {
                lineLength = this.textBox.getLineEndOffset(l) - lineStartOffset;
                extraLines += lineLength / 60;
                lineStartOffset = this.textBox.getLineEndOffset(l) + 1;
                continue;
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        this.textBox.setRows(Math.max(lines += extraLines, 2));
        AttributeEditListeners.addListeners(this.textBox, this, this.attributeName);
        this.textBox.getDocument().addDocumentListener(new NewLineListener());
    }

    private void buildUI() {
        JScrollPane scrollPane = new JScrollPane(this.textBox);
        Dimension textBoxSize = this.textBox.getPreferredSize();
        int w = (int)textBoxSize.getWidth();
        int h = (int)textBoxSize.getHeight();
        scrollPane.setPreferredSize(new Dimension(w + 10, h + 10));
        this.add(scrollPane);
    }

    public TextBoxEditor(IAttributes param, String attributeName) {
        super(param);
        this.attributeName = attributeName;
        this.initialise();
        this.buildUI();
    }

    public TextBoxEditor(IAttributes param) {
        super(param);
        this.attributeName = "value";
        this.initialise();
        this.buildUI();
    }

    public JTextArea getTextBox() {
        return this.textBox;
    }

    public String getEditDisplayName() {
        return "Edit Text";
    }

    public class NewLineListener
    implements DocumentListener {
        int lineCount;

        public NewLineListener() {
            this.lineCount = TextBoxEditor.this.textBox.getLineCount();
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            this.checkLines();
        }

        public void removeUpdate(DocumentEvent e) {
            this.checkLines();
        }

        private void checkLines() {
            int newLineCount = TextBoxEditor.this.textBox.getLineCount();
            if (newLineCount != this.lineCount) {
                this.lineCount = newLineCount;
            }
        }
    }
}

