/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.AbstractParamEditor;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.TextFieldEditor;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomLabel;

public class AttributeEditLine
extends AbstractParamEditor
implements PropertyChangeListener {
    protected String attributeName;
    private String labelText;
    protected JTextField textField;

    protected void buildUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)new CustomLabel(this.labelText + ": "), "North");
        TextFieldEditor textEditor = new TextFieldEditor(this.getParameter(), this.attributeName);
        textEditor.addPropertyChangeListener("valueChangedProperty", this);
        this.textField = textEditor.getTextField();
        this.add((Component)textEditor, "Center");
    }

    public AttributeEditLine(IAttributes param, String attributeName, String label) {
        super(param);
        this.attributeName = attributeName;
        this.labelText = label;
        this.buildUI();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("valueChangedProperty".equals(evt.getPropertyName())) {
            this.attributeEdited(this.attributeName, evt.getNewValue());
        }
    }

    public String getEditDisplayName() {
        return "Edit " + this.labelText;
    }

    public void setFontSize(int size) {
        if (this.textField != null) {
            Font oldFont = this.textField.getFont();
            Font newFont = oldFont.deriveFont((float)size);
            this.textField.setFont(newFont);
        }
    }
}

