/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.TextFieldEditor;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate.AttributeEditLine;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class AttributeEditNoLabel
extends AttributeEditLine
implements FocusListener {
    private String labelText;
    private Border selectedBorder;
    private Border unselectedBorder;

    private void checkFieldEmpty() {
        String displayedText = this.textField.getText().trim();
        if (displayedText.length() == 0) {
            this.textField.setText(this.labelText);
            this.textField.setForeground(Color.GRAY);
        }
    }

    public AttributeEditNoLabel(IAttributes param, String attributeName, String label) {
        super(param, attributeName, label);
        this.labelText = label;
        this.checkFieldEmpty();
    }

    protected void buildUI() {
        this.setLayout(new BorderLayout());
        this.selectedBorder = BorderFactory.createLineBorder(UIUtilities.LIGHT_GREY);
        this.unselectedBorder = BorderFactory.createLineBorder(Color.white);
        TextFieldEditor editor = new TextFieldEditor(this.getParameter(), this.attributeName);
        this.textField = editor.getTextField();
        this.textField.setBorder(this.unselectedBorder);
        this.textField.addFocusListener(this);
        editor.addPropertyChangeListener("valueChangedProperty", this);
        this.add((Component)editor, "Center");
    }

    public void focusGained(FocusEvent e) {
        this.textField.setBorder(this.selectedBorder);
        if (this.labelText != null && this.labelText.equals(this.textField.getText())) {
            this.textField.setSelectionStart(0);
            this.textField.setSelectionEnd(this.labelText.length());
        }
    }

    public void focusLost(FocusEvent e) {
        this.textField.setBorder(this.unselectedBorder);
    }
}

