/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.browser.ExperimentInfoPanel;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate.AttributeEditArea;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate.AttributeEditNoLabel;
import org.openmicroscopy.shoola.agents.editor.model.Note;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomButton;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class NoteEditor
extends JPanel
implements ActionListener {
    private Note note;
    private PropertyChangeListener parent;
    public static final String NOTE_DELETED = "noteDeleted";

    private void buildUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(ExperimentInfoPanel.LIGHT_YELLOW);
        MatteBorder lineBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, UIUtilities.LIGHT_GREY);
        this.setBorder(lineBorder);
        EmptyBorder eb = new EmptyBorder(3, 4, 3, 4);
        AttributeEditNoLabel nameEditor = new AttributeEditNoLabel(this.note, "name", "Note Name");
        nameEditor.addPropertyChangeListener("valueChangedProperty", this.parent);
        nameEditor.setBackground(null);
        nameEditor.setBorder(eb);
        AttributeEditArea contentEditor = new AttributeEditArea(this.note, "content", "Note Content");
        contentEditor.addPropertyChangeListener("valueChangedProperty", this.parent);
        contentEditor.setBorder(eb);
        JToolBar rightToolBar = new JToolBar();
        rightToolBar.setBackground(null);
        rightToolBar.setFloatable(false);
        MatteBorder bottomLeft = BorderFactory.createMatteBorder(0, 1, 1, 0, UIUtilities.LIGHT_GREY);
        rightToolBar.setBorder(bottomLeft);
        IconManager iM = IconManager.getInstance();
        Icon delete = iM.getIcon(84);
        CustomButton deleteButton = new CustomButton(delete);
        deleteButton.addActionListener(this);
        deleteButton.setToolTipText("Delete this note");
        rightToolBar.add(deleteButton);
        Box titleToolBar = Box.createHorizontalBox();
        nameEditor.setAlignmentY(0.0f);
        titleToolBar.add(nameEditor);
        rightToolBar.setAlignmentY(0.0f);
        titleToolBar.add(rightToolBar);
        this.add(titleToolBar);
        this.add(contentEditor);
    }

    public NoteEditor(Note note, PropertyChangeListener parent) {
        this.note = note;
        this.parent = parent;
        this.addPropertyChangeListener(NOTE_DELETED, parent);
        this.buildUI();
    }

    public Note getNote() {
        return this.note;
    }

    public void actionPerformed(ActionEvent e) {
        this.firePropertyChange(NOTE_DELETED, false, true);
    }
}

