/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model;

import java.util.Date;
import java.util.HashMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.model.ProtocolRootField;
import pojos.ExperimenterData;

public class ExperimentInfo
implements IAttributes {
    private HashMap<String, String> valueAttributesMap;
    public static final String EXP_DATE = "experiment-date";
    public static final String INVESTIG_NAME = "investigator-name";
    public static final String EDIT_PROTOCOL = "editProtocol";

    public ExperimentInfo(String name, String utcDate) {
        if (name == null) {
            if (EditorAgent.isServerAvailable()) {
                ExperimenterData ed = EditorAgent.getUserDetails();
                name = ed.getFirstName() + " " + ed.getLastName();
            } else {
                name = System.getProperty("user.name");
            }
        }
        if (utcDate == null) {
            Date now = new Date();
            utcDate = now.getTime() + "";
        }
        this.valueAttributesMap = new HashMap();
        this.setAttribute(INVESTIG_NAME, name);
        this.setAttribute(EXP_DATE, utcDate);
    }

    public ExperimentInfo() {
        this(null, null);
    }

    public static boolean isModelExperiment(TreeModel model) {
        IAttributes expInfo = ExperimentInfo.getExpInfo(model);
        return expInfo != null;
    }

    public static IAttributes getExpInfo(TreeModel model) {
        if (model == null) {
            return null;
        }
        TreeNode tn = (TreeNode)model.getRoot();
        if (!(tn instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tn;
        Object userOb = node.getUserObject();
        if (!(userOb instanceof ProtocolRootField)) {
            return null;
        }
        ProtocolRootField prf = (ProtocolRootField)userOb;
        return prf.getExpInfo();
    }

    public String getAttribute(String name) {
        return this.valueAttributesMap.get(name);
    }

    public void setAttribute(String name, String value) {
        this.valueAttributesMap.put(name, value);
    }

    public boolean isAttributeTrue(String attributeName) {
        return "true".equals(this.valueAttributesMap.get(attributeName));
    }
}

