/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model;

import java.io.File;
import java.io.FileInputStream;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLParserFactory;
import org.openmicroscopy.shoola.agents.editor.model.CPEimport;
import org.openmicroscopy.shoola.agents.editor.model.ExperimentInfo;
import org.openmicroscopy.shoola.agents.editor.model.Field;
import org.openmicroscopy.shoola.agents.editor.model.FieldNode;
import org.openmicroscopy.shoola.agents.editor.model.PROimport;
import org.openmicroscopy.shoola.agents.editor.model.ProtocolRootField;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;

public class TreeModelFactory {
    public static TreeModel getTree(File file) throws ParsingException {
        IXMLElement root = null;
        String errMsg = null;
        String absPath = file.getAbsolutePath();
        try {
            IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
            FileInputStream input = new FileInputStream(file);
            StdXMLReader reader = new StdXMLReader(input);
            parser.setReader(reader);
            root = (IXMLElement)parser.parse();
            input.close();
        }
        catch (Throwable ex) {
            errMsg = "Error reading XML file at " + absPath + "  File " + (file.exists() ? "may be corrupted or incomplete." : "not found.");
        }
        String rootName = null;
        if (root != null) {
            rootName = root.getFullName();
            if ("protocol-archive".equals(rootName)) {
                return CPEimport.createTreeModel(root);
            }
            if ("ProtocolTitle".equals(rootName)) {
                return PROimport.createTreeModel(root);
            }
            errMsg = "File format not recognised:  XML root element named '" + rootName + "' is not an OMERO.Editor File";
        }
        throw new ParsingException(errMsg);
    }

    public static TreeModel getTreeXml(File file) throws ParsingException {
        IXMLElement root = null;
        String errMsg = null;
        String absPath = file.getAbsolutePath();
        try {
            IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
            FileInputStream input = new FileInputStream(file);
            StdXMLReader reader = new StdXMLReader(input);
            parser.setReader(reader);
            root = (IXMLElement)parser.parse();
            input.close();
        }
        catch (Throwable ex) {
            errMsg = "Error reading XML file at " + absPath + "  File " + (file.exists() ? "may be corrupted or incomplete." : "not found.");
        }
        if (root != null) {
            return PROimport.createTreeModel(root);
        }
        throw new ParsingException(errMsg);
    }

    public static TreeModel getTree() {
        ProtocolRootField rootField = new ProtocolRootField();
        FieldNode rootNode = new FieldNode(rootField);
        FieldNode firstNode = new FieldNode(new Field());
        rootNode.add(firstNode);
        return new DefaultTreeModel(rootNode);
    }

    public static TreeModel getExperimentTree(String name) {
        ProtocolRootField rootField = new ProtocolRootField();
        rootField.setAttribute("fieldName", name);
        ExperimentInfo experimentInfo = new ExperimentInfo();
        rootField.setExpInfo(experimentInfo);
        FieldNode rootNode = new FieldNode(rootField);
        FieldNode firstNode = new FieldNode(new Field());
        rootNode.add(firstNode);
        return new DefaultTreeModel(rootNode);
    }
}

