/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.params;

import org.openmicroscopy.shoola.agents.editor.model.params.AbstractParam;

public class OntologyTermParam
extends AbstractParam {
    public static final String ONTOLOGY_TERM_PARAM = "ONTOLOGYTERM";
    public static final String ONTOLOGY_ID = "ontolgoyId";
    public static final String TERM_ID = "termId";
    public static final String TERM_NAME = "termName";
    public static final String ONTOLOGY_SEPARATOR = ":";
    public static final String TERM_SEPARATOR = " ";

    public OntologyTermParam() {
        super(ONTOLOGY_TERM_PARAM);
    }

    public String toString() {
        String text = this.getParamValue();
        return super.toString() + TERM_SEPARATOR + (text == null ? "" : text);
    }

    public String getParamValue() {
        String id = this.getAttribute(ONTOLOGY_ID);
        String term = this.getAttribute(TERM_ID);
        String name = this.getAttribute(TERM_NAME);
        if (id == null && term == null && name == null) {
            return null;
        }
        return (id == null ? "" : id + ONTOLOGY_SEPARATOR) + (term == null ? "" : term + TERM_SEPARATOR) + (name == null ? "" : name);
    }

    public boolean setOntologyTerm(String ontologyTerm) {
        int colonIndex = ontologyTerm.indexOf(ONTOLOGY_SEPARATOR);
        if (colonIndex < 2) {
            return false;
        }
        String ontologyId = ontologyTerm.substring(0, colonIndex);
        int spaceIndex = (ontologyTerm = ontologyTerm.substring(colonIndex + 1)).indexOf(TERM_SEPARATOR);
        if (spaceIndex < 1) {
            return false;
        }
        String termId = ontologyTerm.substring(0, spaceIndex);
        String termName = ontologyTerm.substring(spaceIndex + 1, ontologyTerm.length());
        this.setAttribute(ONTOLOGY_ID, ontologyId);
        this.setAttribute(TERM_ID, termId);
        this.setAttribute(TERM_NAME, termName);
        return true;
    }

    public boolean isParamFilled() {
        boolean filled = this.getAttribute(ONTOLOGY_ID) != null && this.getAttribute(TERM_ID) != null;
        return filled;
    }
}

