/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.undoableEdits;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import org.openmicroscopy.shoola.agents.editor.model.DataReference;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;

public class AddDataRefEdit
extends AbstractUndoableEdit {
    private IField field;
    private DataReference newDataRef;
    private DataReference oldDataRef;
    private JTree tree;
    private TreeNode node;
    private int indexOfRef;

    public AddDataRefEdit(IField field, JTree tree, TreeNode node) {
        this.field = field;
        this.tree = tree;
        this.node = node;
        this.indexOfRef = field.getDataRefCount();
        this.newDataRef = new DataReference();
        this.redo();
    }

    public AddDataRefEdit(IField field, DataReference dataRef, JTree tree, TreeNode node) {
        this.field = field;
        this.newDataRef = null;
        this.oldDataRef = dataRef;
        this.tree = tree;
        this.node = node;
        this.redo();
    }

    public void undo() {
        if (this.newDataRef != null) {
            this.field.removeDataRef(this.newDataRef);
        } else {
            this.field.addDataRef(this.indexOfRef, this.oldDataRef);
        }
        this.notifySelectStartEdit();
    }

    public void redo() {
        if (this.newDataRef != null) {
            this.field.addDataRef(this.indexOfRef, this.newDataRef);
        } else {
            this.indexOfRef = this.field.removeDataRef(this.oldDataRef);
        }
        this.notifySelectStartEdit();
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }

    public String getPresentationName() {
        return "Data Reference";
    }

    private void notifySelectStartEdit() {
        this.notifyNodeChanged();
        TreeModelMethods.selectNode(this.node, this.tree);
        DefaultMutableTreeNode dmtNode = (DefaultMutableTreeNode)this.node;
        TreePath path = new TreePath(dmtNode.getPath());
        if (this.tree != null) {
            this.tree.startEditingAtPath(path);
        }
    }

    private void notifyNodeChanged() {
        if (this.tree != null && this.node != null) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
            treeModel.nodeChanged(this.node);
        }
    }
}

