/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.undoableEdits;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.UndoableTreeEdit;

public class IndentLeftEdit
extends UndoableTreeEdit {
    private List<DefaultMutableTreeNode> movedNodes = new ArrayList<DefaultMutableTreeNode>();
    private int lastNodeChildCount;

    public IndentLeftEdit(JTree tree) {
        super(tree);
    }

    public static boolean canDo(TreePath[] paths) {
        if (paths == null) {
            return false;
        }
        if (paths.length == 0) {
            return false;
        }
        TreePath selectedPath = paths[0];
        DefaultMutableTreeNode firstNode = (DefaultMutableTreeNode)selectedPath.getLastPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)firstNode.getParent();
        if (parentNode == null) {
            return false;
        }
        DefaultMutableTreeNode grandParent = (DefaultMutableTreeNode)parentNode.getParent();
        return grandParent != null;
    }

    public void doEdit() {
        if (this.tree == null) {
            return;
        }
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        if (!IndentLeftEdit.canDo(selectedPaths)) {
            return;
        }
        if (selectedPaths.length > 0) {
            for (int i = 0; i < selectedPaths.length; ++i) {
                DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)selectedPaths[i].getLastPathComponent();
                this.movedNodes.add(currentNode);
            }
            this.lastNodeChildCount = this.movedNodes.get(this.movedNodes.size() - 1).getChildCount();
        }
        this.redo();
    }

    public void undo() {
        TreeModelMethods.indentNodesRight(this.movedNodes, this.treeModel);
        DefaultMutableTreeNode lastNode = this.movedNodes.get(this.movedNodes.size() - 1);
        int lastNodeNewChildCount = lastNode.getChildCount();
        for (int i = lastNodeNewChildCount - 1; i > this.lastNodeChildCount - 1; --i) {
            TreeModelMethods.indentNodeLeft((DefaultMutableTreeNode)lastNode.getChildAt(i));
        }
        TreeModelMethods.selectDNodes(this.movedNodes, this.tree);
    }

    public void redo() {
        TreeModelMethods.indentNodesLeft(this.movedNodes, this.treeModel);
        TreeModelMethods.selectDNodes(this.movedNodes, this.tree);
    }

    public String getPresentationName() {
        return "Indent Fields to Left";
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }
}

