/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.undoableEdits;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.UndoableTreeEdit;
import org.openmicroscopy.shoola.agents.editor.view.EditorFactory;
import org.openmicroscopy.shoola.env.ui.UserNotifier;

public class PasteFieldsEdit
extends UndoableTreeEdit {
    private List<DefaultMutableTreeNode> newNodes;
    private int indexOfNewField;
    private DefaultMutableTreeNode parentNode;

    public PasteFieldsEdit(JTree tree) {
        super(tree);
    }

    public static boolean canDo() {
        return EditorFactory.getCopiedData() != null;
    }

    public void doEdit() {
        if (!PasteFieldsEdit.canDo()) {
            UserNotifier un = EditorAgent.getRegistry().getUserNotifier();
            un.notifyInfo("No steps to paste", "Can't paste: No steps have been copied to the clipboard.");
            return;
        }
        Object data = EditorFactory.getCopiedData();
        if (!(data instanceof Object[])) {
            return;
        }
        Object[] copiedData = (Object[])data;
        this.newNodes = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < copiedData.length; ++i) {
            Object item = copiedData[i];
            if (!(item instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode pastedNode = (DefaultMutableTreeNode)item;
            this.newNodes.add(TreeModelMethods.duplicateNode(pastedNode));
        }
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        if (selectedPaths != null && selectedPaths.length > 0) {
            DefaultMutableTreeNode lastField = (DefaultMutableTreeNode)selectedPaths[selectedPaths.length - 1].getLastPathComponent();
            if (lastField.isRoot()) {
                this.parentNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
                this.indexOfNewField = this.parentNode.getChildCount();
            } else {
                int indexOfLastHighlightedField = lastField.getParent().getIndex(lastField);
                this.indexOfNewField = indexOfLastHighlightedField + 1;
                this.parentNode = (DefaultMutableTreeNode)lastField.getParent();
            }
        } else {
            this.parentNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
            this.indexOfNewField = this.parentNode.getChildCount();
        }
        this.redo();
    }

    public void undo() {
        for (DefaultMutableTreeNode newNode : this.newNodes) {
            this.treeModel.removeNodeFromParent(newNode);
        }
    }

    public void redo() {
        TreePath[] paths = new TreePath[this.newNodes.size()];
        int i = 0;
        int indexToAdd = this.indexOfNewField;
        for (DefaultMutableTreeNode newNode : this.newNodes) {
            this.treeModel.insertNodeInto(newNode, this.parentNode, indexToAdd++);
            paths[i++] = new TreePath(newNode.getPath());
        }
        this.tree.setSelectionPaths(paths);
    }

    public String getPresentationName() {
        return "Paste Fields";
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }
}

