/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.openmicroscopy.shoola.agents.editor.util.OntologyLookUp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ontologies {
    private static Ontologies uniqueInstance;
    private Map<String, String> supportedOntologies = new LinkedHashMap<String, String>();
    public static final String ONTOLOGY_ID_NAME_SEPARATOR = "   ";
    private static String[] OBO_REL_TERMS;
    public static final String BS = "Biosapiens Annotations";
    public static final String BSPO = "Spatial Reference Ontology";
    public static final String BTO = "BRENDA tissue / enzyme source";
    public static final String CARO = "Common Anatomy Reference Ontology";
    public static final String CHEBI = "Chemical Entities of Biological Interest";
    public static final String CL = "Cell Type";
    public static final String DDANAT = "Dictyostelium discoideum Anatomy";
    public static final String DOID = "Human Disease";
    public static final String ECO = "Evidence Codes";
    public static final String EHDA = "Human Developmental Anatomy";
    public static final String EHDAA = "Human Developmental Anatomy";
    public static final String EMAP = "Mouse Gross Anatomy and Development";
    public static final String ENVO = "Environmental Ontology";
    public static final String EO = "Plant Environmental Conditions";
    public static final String EV = "eVOC (Expressed Sequence Annotation for Humans)";
    public static final String FAO = "Fungal Gross Anatomy";
    public static final String FBbi = "Biological Imaging Methods";
    public static final String FBbt = "Drosophila Gross Anatomy";
    public static final String FBcv = "Flybase Controlled Vocabulary";
    public static final String FBdv = "Drosophila Development";
    public static final String FIX = "Physico-Chemical Methods and Properties";
    public static final String GO = "Gene Ontology";
    public static final String GRO = "Cereal Plant Development";
    public static final String IEV = "Event (INOH)";
    public static final String IMR = "Molecule Role (INOH)";
    public static final String MA = "Mouse Adult Gross Anatomy";
    public static final String MFO = "Medaka Fish Anatomy and Development";
    public static final String MI = "Molecular Interaction (PSI MI 2.5)";
    public static final String MOD = "Protein Modifications (PSI-MOD)";
    public static final String MP = "Mammalian Phenotype";
    public static final String MPATH = "Mouse Pathology";
    public static final String NEWT = "NEWT UniProt Taxonomy Database";
    public static final String OBO_REL = "OBO Relationship Types";
    public static final String PATO = "Phenotypic qualities (properties)";
    public static final String PB = "Proteome Binders";
    public static final String PM = "Phenotypic manifestation (genetic context)";
    public static final String PO = "Plant Ontology (Structure, Growth and Developmental Stage)";
    public static final String PRIDE = "PRIDE Controlled Vocabulary";
    public static final String PSI = "Mass Spectroscopy CV (PSI-MS)";
    public static final String PW = "Pathway Ontology";
    public static final String REX = "Physico-Chemical Process";
    public static final String RO = "Multiple Alignment";
    public static final String SEP = "Separation Methods";
    public static final String SO = "Sequence Types and Features";
    public static final String SPD = "Spider Comparative Biology Ontology";
    public static final String TAIR = "Arabidopsis Development";
    public static final String TAO = "Teleost Anatomy and Development Ontology";
    public static final String TGMA = "Mosquito Gross Anatomy";
    public static final String TO = "Cereal Plant Trait";
    public static final String UO = "Unit Ontology";
    public static final String WBls = "C. elegans Development";
    public static final String XAO = "Xenopus anatomy and development";
    public static final String ZDB = "Zebrafish Anatomy and Development";
    public static final String ZEA = "Maize Gross Anatomy";

    private Ontologies() {
        this.supportedOntologies.put("BS", BS);
        this.supportedOntologies.put("BSPO", BSPO);
        this.supportedOntologies.put("BTO", BTO);
        this.supportedOntologies.put("CARO", CARO);
        this.supportedOntologies.put("CHEBI", CHEBI);
        this.supportedOntologies.put("CL", CL);
        this.supportedOntologies.put("DDANAT", DDANAT);
        this.supportedOntologies.put("DOID", DOID);
        this.supportedOntologies.put("ECO", ECO);
        this.supportedOntologies.put("EHDA", "Human Developmental Anatomy");
        this.supportedOntologies.put("EHDAA", "Human Developmental Anatomy");
        this.supportedOntologies.put("EMAP", EMAP);
        this.supportedOntologies.put("ENVO", ENVO);
        this.supportedOntologies.put("EO", EO);
        this.supportedOntologies.put("EV", EV);
        this.supportedOntologies.put("FAO", FAO);
        this.supportedOntologies.put("FBbi", FBbi);
        this.supportedOntologies.put("FBbt", FBbt);
        this.supportedOntologies.put("FBcv", FBcv);
        this.supportedOntologies.put("FBdv", FBdv);
        this.supportedOntologies.put("FIX", FIX);
        this.supportedOntologies.put("GO", GO);
        this.supportedOntologies.put("GRO", GRO);
        this.supportedOntologies.put("IEV", IEV);
        this.supportedOntologies.put("IMR", IMR);
        this.supportedOntologies.put("MA", MA);
        this.supportedOntologies.put("MFO", MFO);
        this.supportedOntologies.put("MI", MI);
        this.supportedOntologies.put("MOD", MOD);
        this.supportedOntologies.put("MP", MP);
        this.supportedOntologies.put("MPATH", MPATH);
        this.supportedOntologies.put("NEWT", NEWT);
        this.supportedOntologies.put("OBO_REL", OBO_REL);
        this.supportedOntologies.put("PATO", PATO);
        this.supportedOntologies.put("PB", PB);
        this.supportedOntologies.put("PM", PM);
        this.supportedOntologies.put("PO", PO);
        this.supportedOntologies.put("PRIDE", PRIDE);
        this.supportedOntologies.put("PSI", PSI);
        this.supportedOntologies.put("PW", PW);
        this.supportedOntologies.put("REX", REX);
        this.supportedOntologies.put("RO", RO);
        this.supportedOntologies.put("SEP", SEP);
        this.supportedOntologies.put("SO", SO);
        this.supportedOntologies.put("SPD", SPD);
        this.supportedOntologies.put("TAIR", TAIR);
        this.supportedOntologies.put("TAO", TAO);
        this.supportedOntologies.put("TGMA", TGMA);
        this.supportedOntologies.put("TO", TO);
        this.supportedOntologies.put("UO", UO);
        this.supportedOntologies.put("WBls", WBls);
        this.supportedOntologies.put("XAO", XAO);
        this.supportedOntologies.put("ZDB", ZDB);
        this.supportedOntologies.put("ZEA", ZEA);
    }

    public static Ontologies getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Ontologies();
        }
        return uniqueInstance;
    }

    public Map<String, String> getSupportedOntologies() {
        return this.supportedOntologies;
    }

    public static String[] getOboRelationshipTerms() {
        return OBO_REL_TERMS;
    }

    public static String[] getTermsByName(String text, String ontologyId) {
        Map<String, String> matchingTerms = OntologyLookUp.getTermsByName(text, ontologyId);
        if (matchingTerms == null) {
            return new String[0];
        }
        String[] terms = new String[matchingTerms.size()];
        int t = 0;
        for (Map.Entry<String, String> entry : matchingTerms.entrySet()) {
            String name = entry.getKey() + ONTOLOGY_ID_NAME_SEPARATOR + entry.getValue();
            terms[t++] = name;
        }
        return terms;
    }

    public static String getOntologyIdFromOntology(String ontologyName) {
        if (ontologyName == null) {
            return null;
        }
        int spacerIndex = ontologyName.indexOf(ONTOLOGY_ID_NAME_SEPARATOR);
        if (spacerIndex < 1) {
            return null;
        }
        return ontologyName.substring(0, spacerIndex);
    }

    public static String getOntologyIdFromB3(String b3TermId) {
        if (b3TermId == null) {
            return null;
        }
        int colonIndex = b3TermId.indexOf(":");
        if (colonIndex < 1) {
            return null;
        }
        return b3TermId.substring(0, colonIndex);
    }

    public static String getTermIdFromB3(String b3TermId) {
        if (b3TermId == null) {
            return null;
        }
        int colonIndex = b3TermId.indexOf(":");
        int separatorIndex = b3TermId.indexOf(ONTOLOGY_ID_NAME_SEPARATOR);
        if (colonIndex < 1) {
            return null;
        }
        if (separatorIndex < 0) {
            separatorIndex = b3TermId.length();
        }
        return b3TermId.substring(colonIndex + 1, separatorIndex);
    }

    public static String getTermNameFromB3(String b3TermId) {
        if (b3TermId == null) {
            return null;
        }
        int separatorIndex = b3TermId.indexOf(ONTOLOGY_ID_NAME_SEPARATOR);
        if (separatorIndex < 0) {
            return null;
        }
        return b3TermId.substring(separatorIndex).trim();
    }

    public String[] getOntologyNameList() {
        String[] ontologyIds = new String[this.supportedOntologies.size()];
        String[] ontologyNames = new String[this.supportedOntologies.size()];
        int index = 0;
        for (String key : this.supportedOntologies.keySet()) {
            String name = this.supportedOntologies.get(key);
            ontologyIds[index] = key;
            ontologyNames[index] = key + ONTOLOGY_ID_NAME_SEPARATOR + name;
            ++index;
        }
        return ontologyNames;
    }

    static {
        OBO_REL_TERMS = new String[]{"DEVELOPS_FROM", "ALT_ID", "BROAD", "PART_OF", "RELATED", "NARROW", "IS_A", "EXACT", "SYNONYM"};
    }
}

