/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.view;

import java.io.File;
import java.io.IOException;
import javax.swing.tree.TreeModel;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.EditorLoader;
import org.openmicroscopy.shoola.agents.editor.FileLoader;
import org.openmicroscopy.shoola.agents.editor.FileSaver;
import org.openmicroscopy.shoola.agents.editor.browser.Browser;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.editor.model.CPEexport;
import org.openmicroscopy.shoola.agents.editor.model.CPEsummaryExport;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelFactory;
import org.openmicroscopy.shoola.agents.editor.view.Editor;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.file.IOUtil;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;
import pojos.DataObject;
import pojos.FileAnnotationData;

class EditorModel {
    private int state;
    private String fileName;
    private FileAnnotationData fileAnnotation;
    private long fileID;
    private long annotationID;
    private String nameSpace;
    private File fileToEdit;
    private Browser browser;
    private DataObject parent;
    private int type;
    private EditorLoader currentLoader;
    private Editor component;

    private boolean saveFile(File file) {
        CPEexport xmlExport = new CPEexport();
        boolean saved = xmlExport.export(this.browser.getTreeModel(), file);
        if (saved) {
            this.browser.setEdited(false);
        }
        return saved;
    }

    EditorModel(FileAnnotationData fileAnnotationData) {
        this.state = 1;
        if (fileAnnotationData == null) {
            throw new IllegalArgumentException("No file annotation specified.");
        }
        this.setFileAnnotationData(fileAnnotationData);
        this.type = 100;
    }

    EditorModel(long annotationID) {
        this.state = 1;
        this.annotationID = annotationID;
        this.fileID = annotationID;
        this.type = 100;
    }

    EditorModel(File file) {
        if (file == null) {
            throw new NullPointerException("No file.");
        }
        this.state = 1;
        this.fileName = file.getName();
        this.type = 100;
    }

    EditorModel() {
        this.state = 1;
        this.fileName = "No File Open";
        this.type = 100;
    }

    EditorModel(DataObject parent, String name, int type) {
        this.state = 1;
        if (name == null || name.length() == 0) {
            name = "No File Open";
        }
        this.fileName = name;
        this.parent = parent;
        this.type = type == 100 || type == 101 ? type : 100;
    }

    void initialize(Editor component) {
        this.component = component;
        this.browser = BrowserFactory.createBrowser(this.type);
    }

    int getState() {
        return this.state;
    }

    void discard() {
        this.cancel();
        this.state = 4;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
        }
        this.currentLoader = null;
        this.state = 3;
    }

    long getFileID() {
        return this.fileID;
    }

    String getFileName() {
        return this.fileName;
    }

    String getNameSpace() {
        return this.nameSpace;
    }

    void fireFileLoading() {
        long size = 0L;
        if (this.fileAnnotation != null) {
            size = this.fileAnnotation.getFileSize();
        }
        this.currentLoader = new FileLoader(this.component, this.fileName, this.fileID, size);
        this.currentLoader.load();
        this.state = 2;
    }

    File getFileToEdit() {
        return this.fileToEdit;
    }

    String readTextFile(File file) throws IOException {
        this.state = 3;
        if (file == null) {
            throw new IOException("File cannot be null.");
        }
        return IOUtil.readTextFile(file);
    }

    boolean setFileToEdit(File file) {
        if (file == null) {
            this.fileToEdit = null;
            this.state = 1;
            this.fileName = "No File Open";
            return false;
        }
        TreeModel treeModel = null;
        try {
            treeModel = TreeModelFactory.getTree(file);
            this.fileToEdit = file;
        }
        catch (ParsingException e) {
            Registry reg = EditorAgent.getRegistry();
            UserNotifier un = reg.getUserNotifier();
            try {
                treeModel = TreeModelFactory.getTreeXml(file);
                un.notifyInfo("File not recognised", "File was converted from an unrecognised format into\nOMERO.editor's cpe.xml format.\nOverwriting the original file will erase the original XML format.");
                this.fileToEdit = null;
                this.setFileAnnotationData(null);
            }
            catch (ParsingException ex) {
                LogMessage message = new LogMessage();
                message.print(ex);
                reg.getLogger().error((Object)this, message);
                String errMsg = ex.getMessage();
                un.notifyInfo("File Failed to Open", errMsg);
            }
        }
        if (treeModel == null) {
            this.fileToEdit = null;
            this.state = 1;
            this.fileName = "No File Open";
            return false;
        }
        this.fileName = file.getName();
        this.browser.setTreeModel(treeModel);
        this.state = 3;
        return true;
    }

    void setBlankFile(String name) {
        this.fileToEdit = null;
        this.fileID = 0L;
        boolean blank = false;
        if (name == null || name.trim().length() == 0) {
            blank = true;
            this.fileName = "New Blank File";
        } else {
            this.fileName = name;
        }
        TreeModel treeModel = blank ? TreeModelFactory.getTree() : (this.type == 101 ? TreeModelFactory.getExperimentTree(name) : TreeModelFactory.getTree());
        this.browser.setTreeModel(treeModel);
        this.state = 3;
    }

    Browser getBrowser() {
        return this.browser;
    }

    boolean saveLocalFile() {
        if (this.fileToEdit != null && this.fileToEdit.exists()) {
            return this.saveFile(this.fileToEdit);
        }
        return false;
    }

    void fireFileSaving(String fileName, boolean asynch) {
        String filePath = EditorAgent.getEditorHome() + File.separator + fileName;
        File toEdit = new File(filePath);
        this.fireFileSaving(toEdit, asynch);
    }

    void fireFileSaving(File file, boolean asynch) {
        boolean fileIsExp = this.browser.isModelExperiment();
        int fileType = fileIsExp ? 1 : 0;
        this.saveFile(file);
        FileAnnotationData data = null;
        data = this.fileAnnotation != null ? this.fileAnnotation : new FileAnnotationData(file);
        String description = CPEsummaryExport.export(this.browser.getTreeModel());
        if (description != null) {
            data.setDescription(description);
        }
        if (asynch) {
            this.currentLoader = new FileSaver(this.component, file, data, fileType, this.parent);
            this.currentLoader.load();
            this.state = 5;
        } else {
            OmeroMetadataService svc = EditorAgent.getRegistry().getMetadataService();
            try {
                svc.archivedFile(this.fileAnnotation, file, fileType, this.parent);
            }
            catch (Exception e) {
                LogMessage msg = new LogMessage();
                msg.print("State: " + this.state);
                msg.print("Cannot save file back to server");
                msg.print(e);
                EditorAgent.getRegistry().getLogger().error((Object)this, msg);
            }
        }
    }

    boolean saveFileAs(File file) {
        if (this.saveFile(file)) {
            this.fileToEdit = file;
            this.fileName = file.getName();
            this.fileID = 0L;
            this.fileAnnotation = null;
            return true;
        }
        return false;
    }

    void setState(int state) {
        this.state = state;
    }

    boolean hasDataToSave() {
        return this.browser != null && this.browser.getSavedState() == 4;
    }

    void setFileAnnotationData(FileAnnotationData data) {
        this.fileAnnotation = data;
        if (data == null) {
            this.fileID = 0L;
            this.fileName = null;
            this.nameSpace = null;
            return;
        }
        this.fileID = data.getFileID();
        this.fileName = data.getFileName();
        this.nameSpace = data.getNameSpace();
    }

    void updateNameSpace() {
        this.nameSpace = this.browser.isModelExperiment() ? "openmicroscopy.org/omero/editor/experiment" : "openmicroscopy.org/omero/editor/protocol";
    }

    long getAnnotationId() {
        if (this.fileAnnotation == null) {
            return this.annotationID;
        }
        return this.fileAnnotation.getId();
    }

    int getType() {
        return this.type;
    }

    boolean isUserOwner() {
        if (this.fileAnnotation == null) {
            return true;
        }
        long userID = EditorAgent.getUserDetails().getId();
        return EditorUtil.isUserOwner(this.fileAnnotation, userID);
    }
}

