/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ZoomAction
extends ViewerAction {
    public static final double ZOOM_FIT_FACTOR = -1.0;
    public static final double MAX_ZOOM_FACTOR = 3.0;
    public static final double MIN_ZOOM_FACTOR = 0.25;
    public static final double DEFAULT_ZOOM_FACTOR = 1.0;
    public static final int ZOOM_25 = 0;
    public static final int ZOOM_50 = 1;
    public static final int ZOOM_75 = 2;
    public static final int ZOOM_100 = 3;
    public static final int ZOOM_125 = 4;
    public static final int ZOOM_150 = 5;
    public static final int ZOOM_175 = 6;
    public static final int ZOOM_200 = 7;
    public static final int ZOOM_225 = 8;
    public static final int ZOOM_250 = 9;
    public static final int ZOOM_275 = 10;
    public static final int ZOOM_300 = 11;
    public static final int ZOOM_FIT_TO_WINDOW = 12;
    public static final int DEFAULT_ZOOM_INDEX = 3;
    public static final int MIN_ZOOM_INDEX = 0;
    public static final int MAX_ZOOM_INDEX = 11;
    public static final String ZOOM_FIT_NAME = "Zoom to Fit";
    private static final int MAX = 12;
    private static final String DESCRIPTION = "Zoom in or out.";
    private static String[] names;
    private static double[] factors;
    private int zoomingIndex;

    private void controlsIndex(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return;
            }
        }
        throw new IllegalArgumentException("Zoom index not supported.");
    }

    public static int getIndex(double f) {
        for (int i = 0; i < factors.length; ++i) {
            if (factors[i] != f) continue;
            return i;
        }
        return 12;
    }

    public static double getZoomFactor(int index) {
        if (index < 0 || index >= factors.length - 1) {
            return -1.0;
        }
        return factors[index];
    }

    public ZoomAction(ImViewer model, int zoomingIndex) {
        super(model);
        this.controlsIndex(zoomingIndex);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.zoomingIndex = zoomingIndex;
        this.putValue("Name", names[zoomingIndex]);
        this.name = names[zoomingIndex];
    }

    public int getIndex() {
        return this.zoomingIndex;
    }

    public void actionPerformed(ActionEvent e) {
        this.model.setZoomFactor(factors[this.zoomingIndex], this.zoomingIndex);
    }

    static {
        factors = new double[13];
        ZoomAction.factors[0] = 0.25;
        ZoomAction.factors[1] = factors[0] + 0.25;
        ZoomAction.factors[2] = factors[1] + 0.25;
        ZoomAction.factors[3] = factors[2] + 0.25;
        ZoomAction.factors[4] = factors[3] + 0.25;
        ZoomAction.factors[5] = factors[4] + 0.25;
        ZoomAction.factors[6] = factors[5] + 0.25;
        ZoomAction.factors[7] = factors[6] + 0.25;
        ZoomAction.factors[8] = factors[7] + 0.25;
        ZoomAction.factors[9] = factors[8] + 0.25;
        ZoomAction.factors[10] = factors[9] + 0.25;
        ZoomAction.factors[11] = factors[10] + 0.25;
        ZoomAction.factors[12] = -1.0;
        names = new String[13];
        ZoomAction.names[0] = (int)(factors[0] * 100.0) + "%";
        ZoomAction.names[1] = (int)(factors[1] * 100.0) + "%";
        ZoomAction.names[2] = (int)(factors[2] * 100.0) + "%";
        ZoomAction.names[3] = (int)(factors[3] * 100.0) + "%";
        ZoomAction.names[4] = (int)(factors[4] * 100.0) + "%";
        ZoomAction.names[5] = (int)(factors[5] * 100.0) + "%";
        ZoomAction.names[6] = (int)(factors[6] * 100.0) + "%";
        ZoomAction.names[7] = (int)(factors[7] * 100.0) + "%";
        ZoomAction.names[8] = (int)(factors[8] * 100.0) + "%";
        ZoomAction.names[9] = (int)(factors[9] * 100.0) + "%";
        ZoomAction.names[10] = (int)(factors[10] * 100.0) + "%";
        ZoomAction.names[11] = (int)(factors[11] * 100.0) + "%";
        ZoomAction.names[12] = ZOOM_FIT_NAME;
    }
}

