/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.cdm;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.imviewer.util.cdm.PlaneSlicingDialog;

class PlaneSlicingPane
extends JPanel {
    static final int WIDTH = 220;
    static final int HEIGHT = 200;
    static final int topBorder = 20;
    static final int leftBorder = 40;
    static final int square = 140;
    static final int bottomBorder = 30;
    static final int rightBorder = 10;
    static final int lS = 180;
    static final int tS = 160;
    static final int tS2 = 90;
    static final int rStart = 91;
    static final int rEnd = 130;
    static final int triangleW = 7;
    static final int triangleH = 8;
    static final Color bgColor = Color.WHITE;
    static final Color borderColor = Color.BLUE;
    static final Color fixedLineColor = Color.BLACK;
    static final Color gridColor = Color.LIGHT_GRAY;
    static final Color axisColor = Color.GRAY;
    static final Color lineColor = Color.RED;
    static final Color layerColor = new Color(192, 192, 192, 80);
    private static final Color ostartColor = Color.BLACK;
    private static final Color oendColor = Color.GRAY;
    private Point2D startPt;
    private Point2D endPt;
    private int xStartOutput1;
    private int xStartOutput2;
    private int xStartOutput3;
    private int yStartOutput1;
    private int yStartOutput2;
    private int yStartOutput3;
    private int xEndOutput1;
    private int xEndOutput2;
    private int xEndOutput3;
    private int yEndOutput1;
    private int yEndOutput2;
    private int yEndOutput3;
    private PlaneSlicingDialog model;

    PlaneSlicingPane(PlaneSlicingDialog model) {
        this.model = model;
    }

    void initialize(int yStart, int yEnd) {
        this.setKnobOutputStart(30, yStart);
        this.setKnobOutputEnd(190, yEnd);
        this.startPt = new Point2D.Double();
        this.endPt = new Point2D.Double();
        this.startPt.setLocation(40.0, yStart);
        this.endPt.setLocation(180.0, yEnd);
        this.repaint();
    }

    void setKnobOutputStart(int x, int y) {
        this.xStartOutput1 = x;
        this.xStartOutput2 = x - 8;
        this.xStartOutput3 = x - 8;
        this.yStartOutput1 = y;
        this.yStartOutput2 = y - 7;
        this.yStartOutput3 = y + 7;
    }

    void setKnobOutputEnd(int x, int y) {
        this.xEndOutput1 = x;
        this.xEndOutput2 = x + 8;
        this.xEndOutput3 = x + 8;
        this.yEndOutput1 = y;
        this.yEndOutput2 = y - 7;
        this.yEndOutput3 = y + 7;
    }

    void updateOutputStart(int y) {
        this.yStartOutput1 = y;
        this.yStartOutput2 = y - 7;
        this.yStartOutput3 = y + 7;
        this.startPt.setLocation(this.startPt.getX(), y);
        this.repaint();
    }

    void updateOutputEnd(int y) {
        this.yEndOutput1 = y;
        this.yEndOutput2 = y - 7;
        this.yEndOutput3 = y + 7;
        this.endPt.setLocation(this.endPt.getX(), y);
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        int i;
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        g2D.setColor(bgColor);
        g2D.fillRect(0, 0, 220, 200);
        Font font = g2D.getFont();
        FontMetrics fontMetrics = g2D.getFontMetrics();
        int hFont = fontMetrics.getHeight();
        Rectangle2D rInput = font.getStringBounds("(1) Input", g2D.getFontRenderContext());
        Rectangle2D rUpper = font.getStringBounds("upper", g2D.getFontRenderContext());
        int wInput = (int)rInput.getWidth();
        int wUpper = (int)rUpper.getWidth();
        AffineTransform transform = new AffineTransform();
        transform.translate(110.0, 90.0);
        transform.scale(1.0, -1.0);
        transform.scale(10.0, 10.0);
        g2D.setPaint(gridColor);
        GeneralPath path = new GeneralPath();
        for (i = -7; i <= 7; ++i) {
            path.moveTo(i, -7.0f);
            path.lineTo(i, 7.0f);
        }
        for (i = -7; i <= 7; ++i) {
            path.moveTo(-7.0f, i);
            path.lineTo(7.0f, i);
        }
        g2D.draw(transform.createTransformedShape(path));
        g2D.setColor(axisColor);
        g2D.drawLine(40, 12, 40, 165);
        g2D.drawLine(40, 12, 37, 15);
        g2D.drawLine(40, 12, 43, 15);
        g2D.drawLine(35, 20, 40, 20);
        g2D.drawLine(35, 160, 188, 160);
        g2D.drawLine(185, 157, 188, 160);
        g2D.drawLine(185, 163, 188, 160);
        g2D.drawLine(180, 160, 180, 165);
        int[] xStartOutputPoints = new int[]{this.xStartOutput1, this.xStartOutput2, this.xStartOutput3};
        int[] yStartOutputPoints = new int[]{this.yStartOutput1, this.yStartOutput2, this.yStartOutput3};
        GeneralPath filledPolygonStartOutput = new GeneralPath();
        filledPolygonStartOutput.moveTo(xStartOutputPoints[0], yStartOutputPoints[0]);
        for (int index = 1; index < xStartOutputPoints.length; ++index) {
            filledPolygonStartOutput.lineTo(xStartOutputPoints[index], yStartOutputPoints[index]);
        }
        filledPolygonStartOutput.closePath();
        g2D.setColor(ostartColor);
        g2D.fill(filledPolygonStartOutput);
        int[] xEndOutputPoints = new int[]{this.xEndOutput1, this.xEndOutput2, this.xEndOutput3};
        int[] yEndOutputPoints = new int[]{this.yEndOutput1, this.yEndOutput2, this.yEndOutput3};
        GeneralPath filledPolygonEndOutput = new GeneralPath();
        filledPolygonEndOutput.moveTo(xEndOutputPoints[0], yEndOutputPoints[0]);
        for (int index = 1; index < xEndOutputPoints.length; ++index) {
            filledPolygonEndOutput.lineTo(xEndOutputPoints[index], yEndOutputPoints[index]);
        }
        filledPolygonEndOutput.closePath();
        g2D.setColor(oendColor);
        g2D.fill(filledPolygonEndOutput);
        g2D.drawString("lower", 50, 160 + hFont);
        g2D.drawString("upper", 180 - wUpper - 10, 160 + hFont);
        g2D.drawString("(1) Input", 110 - wInput / 2, 175 + hFont);
        g2D.drawLine(90, (int)this.startPt.getY(), 90, 90);
        g2D.drawLine(130, 90, 130, (int)this.endPt.getY());
        g2D.setColor(lineColor);
        g2D.setStroke(new BasicStroke(1.5f));
        g2D.drawLine(41, (int)this.startPt.getY(), 90, (int)this.startPt.getY());
        g2D.drawLine(131, (int)this.endPt.getY(), 180, (int)this.endPt.getY());
        g2D.setColor(fixedLineColor);
        g2D.drawLine(91, 90, 130, 90);
        if (this.model.getPaneIndex() == 0) {
            g2D.setColor(borderColor);
            g2D.draw(new Rectangle2D.Double(0.0, 0.0, 220.0, 200.0));
        } else {
            g2D.setColor(layerColor);
            g2D.fillRect(0, 0, 220, 200);
        }
    }
}

