/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.saver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openmicroscopy.shoola.agents.imviewer.util.saver.ImgSaver;
import org.openmicroscopy.shoola.agents.imviewer.util.saver.ImgSaverPreviewerCanvas;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ImgSaverPreviewer
extends JDialog {
    static final int SPACE = 10;
    private ImgSaver model;
    private JButton cancelButton;
    private JButton saveButton;
    private ImgSaverPreviewerCanvas canvas;
    private JLayeredPane layeredPane;

    private void setDimensions(int w, int h) {
        Dimension d = new Dimension(w, h);
        this.canvas.setPreferredSize(d);
        this.canvas.setSize(d);
        this.layeredPane.setPreferredSize(d);
        this.layeredPane.setSize(d);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = 7 * (screenSize.width / 10);
        int height = 7 * (screenSize.height / 10);
        h += 10;
        if ((w += 10) > width) {
            w = width;
        }
        if (h > height) {
            h = height;
        }
        this.setSize(w, h);
        this.setPreferredSize(new Dimension(w, h));
    }

    private void onClose() {
        this.setVisible(false);
        this.dispose();
    }

    private void initListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ImgSaverPreviewer.this.onClose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImgSaverPreviewer.this.onClose();
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImgSaverPreviewer.this.model.setCursor(Cursor.getPredefinedCursor(3));
                ImgSaverPreviewer.this.model.saveImage(false);
                ImgSaverPreviewer.this.model.setCursor(Cursor.getPredefinedCursor(0));
                ImgSaverPreviewer.this.onClose();
            }
        });
    }

    private void initComponents() {
        this.saveButton = new JButton("Save");
        this.saveButton.setToolTipText(UIUtilities.formatToolTipText("Save the preview image."));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText(UIUtilities.formatToolTipText("Close without saving."));
        this.getRootPane().setDefaultButton(this.saveButton);
        this.canvas = new ImgSaverPreviewerCanvas(this);
        this.layeredPane = new JLayeredPane();
        this.layeredPane.add((Component)this.canvas, (Object)0);
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.add(this.cancelButton);
        bar.add(this.saveButton);
        return UIUtilities.buildComponentPanelRight(bar);
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        c.add((Component)this.buildToolBar(), "North");
        c.add((Component)new JScrollPane(this.layeredPane), "Center");
    }

    ImgSaverPreviewer(ImgSaver model) {
        super(model);
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.setTitle("Preview image to save.");
        this.setModal(true);
        this.initComponents();
        this.initListeners();
    }

    void initialize() {
        int w = 10;
        BufferedImage img = this.model.getImage();
        if (img != null) {
            List l = this.model.getImageComponents();
            if (l != null) {
                int n = l.size();
                w += n * img.getWidth() + (n - 1) * 10;
            }
            this.setDimensions(w += img.getWidth() + 10, img.getHeight() + 20);
        }
        this.canvas.repaint();
        this.buildGUI();
        this.pack();
    }

    BufferedImage getImage() {
        return this.model.getImage();
    }

    List getImageComponents() {
        return this.model.getImageComponents();
    }

    boolean isUnitBar() {
        return this.model.isUnitBar();
    }

    String getUnitBarValue() {
        return this.model.getUnitBarValue();
    }

    Color getUnitBarColor() {
        return this.model.getUnitBarColor();
    }

    double getUnitBarSize() {
        return this.model.getUnitBarSize();
    }

    int getType() {
        return this.model.getType();
    }
}

