/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerModel;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import pojos.ExperimenterData;

class UsersPopupMenu
extends JPopupMenu
implements ActionListener {
    static final String USER_RNDSETTINGS_PROPERTY = "userRndSettings";
    private ImViewerModel model;

    private void initComponents() {
        UserItem item;
        Map m = this.model.getRenderingSettings();
        if (m == null) {
            return;
        }
        long userID = this.model.getAlternativeSettingsOwnerId();
        ViewerSorter sorter = new ViewerSorter();
        List list = sorter.sort(m.keySet());
        Iterator i = list.iterator();
        IconManager icons = IconManager.getInstance();
        Icon icon = icons.getIcon(53);
        long id = this.model.getUserDetails().getId();
        if (userID != -1L) {
            id = userID;
        }
        ButtonGroup group = new ButtonGroup();
        long ownerID = this.model.getOwnerID();
        while (i.hasNext()) {
            ExperimenterData exp = (ExperimenterData)i.next();
            if (ownerID != exp.getId()) continue;
            item = new UserItem(exp, icon);
            item.setFont(item.getFont().deriveFont(1));
            item.setToolTipText("Image's owner");
            item.setSelected(id == exp.getId());
            group.add(item);
            item.addActionListener(this);
            this.add(item);
            this.add(new JSeparator());
        }
        for (ExperimenterData exp : list) {
            if (ownerID == exp.getId()) continue;
            item = new UserItem(exp, icon);
            item.setSelected(id == exp.getId());
            group.add(item);
            item.addActionListener(this);
            this.add(item);
        }
    }

    UsersPopupMenu(ImViewerModel model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.initComponents();
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof UserItem) {
            UserItem item = (UserItem)src;
            this.firePropertyChange(USER_RNDSETTINGS_PROPERTY, null, item.getExperimenter());
        }
    }

    class UserItem
    extends JCheckBoxMenuItem {
        private ExperimenterData exp;

        UserItem(ExperimenterData exp, Icon icon) {
            if (exp == null) {
                throw new IllegalArgumentException("No experimenter.");
            }
            this.exp = exp;
            this.setIcon(icon);
            this.setText(this.toString());
        }

        ExperimenterData getExperimenter() {
            return this.exp;
        }

        public String toString() {
            return this.exp.getFirstName() + " " + this.exp.getLastName();
        }
    }
}

