/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement;

import java.util.Collection;
import org.openmicroscopy.shoola.agents.measurement.MeasurementViewerLoader;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.log.LogMessage;

public class ServerSideROILoader
extends MeasurementViewerLoader {
    private long imageID;
    private long userID;
    private CallHandle handle;

    public ServerSideROILoader(MeasurementViewer viewer, long imageID, long userID) {
        super(viewer);
        if (imageID < 0L) {
            throw new IllegalArgumentException("No image specified.");
        }
        this.imageID = imageID;
        this.userID = userID;
    }

    public void load() {
        this.handle = this.idView.loadROIFromServer(this.imageID, this.userID, this);
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleException(Throwable exc) {
        int state = this.viewer.getState();
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print("State: " + state);
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        if (state != 6) {
            this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
        }
        this.viewer.setLoadingFromServerClient(null);
    }

    public void handleResult(Object result) {
        if (this.viewer.getState() == 6) {
            return;
        }
        this.viewer.setLoadingFromServerClient((Collection)result);
    }
}

