/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.actions.MeasurementViewerAction;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class SaveROIAction
extends MeasurementViewerAction
implements PropertyChangeListener {
    private static final String NAME = "Save...";
    private static final String DESCRIPTION = "Save the ROI.";

    protected void onStateChange() {
        if (this.model.getState() == 5) {
            this.setEnabled(this.model.isImageWritable());
        } else {
            this.setEnabled(false);
        }
    }

    public SaveROIAction(MeasurementViewer model) {
        super(model);
        model.addPropertyChangeListener("roiChanged", this);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager icons = IconManager.getInstance();
        this.putValue("SmallIcon", icons.getIcon(12));
    }

    public void actionPerformed(ActionEvent e) {
        this.model.saveROIToServer();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("roiChanged".equals(name)) {
            this.onStateChange();
        }
    }
}

