/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.roitable;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.treetable.model.OMETreeNode;

public class ROINode
extends OMETreeNode {
    private static final int ROIID_COLUMN = 0;
    private static final int TIME_COLUMN = 1;
    private static final int Z_COLUMN = 2;
    private static final int SHAPE_COLUMN = 3;
    private static final int ANNOTATION_COLUMN = 4;
    private static final int VISIBLE_COLUMN = 5;
    private Map<ROIShape, ROINode> childMap;
    private TreeMap<Coord3D, ROINode> childCoordMap;

    public ROINode(String str) {
        super(str);
        this.initMaps();
    }

    public ROINode(ROI nodeName) {
        super(nodeName);
        this.initMaps();
    }

    public ROINode(ROIShape nodeName) {
        super(nodeName);
        this.initMaps();
    }

    public int getInsertionPoint(Coord3D coord) {
        Iterator<Coord3D> i = this.childCoordMap.keySet().iterator();
        int index = 0;
        while (i.hasNext()) {
            Coord3D nodeCoord = i.next();
            if (nodeCoord.compare(nodeCoord, coord) != -1) {
                return index;
            }
            ++index;
        }
        return index;
    }

    private void initMaps() {
        this.childMap = new HashMap<ROIShape, ROINode>();
        this.childCoordMap = new TreeMap(new Coord3D());
    }

    public ROINode findChild(ROIShape shape) {
        if (this.childMap.containsKey(shape)) {
            return this.childMap.get(shape);
        }
        return null;
    }

    public ROINode findChild(Coord3D shapeCoord) {
        if (this.childCoordMap.containsKey(shapeCoord)) {
            return this.childCoordMap.get(shapeCoord);
        }
        return null;
    }

    public boolean isEditable(int column) {
        switch (column) {
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public void insert(ROINode child, int index) {
        super.insert((MutableTreeTableNode)child, index);
        Object userObject = child.getUserObject();
        if (userObject instanceof ROIShape) {
            ROIShape shape = (ROIShape)userObject;
            child.setExpanded(true);
            this.childMap.put(shape, child);
            this.childCoordMap.put(shape.getCoord3D(), child);
        }
    }

    public void remove(ROINode child) {
        super.remove((MutableTreeTableNode)child);
        Object userObject = child.getUserObject();
        if (userObject instanceof ROIShape) {
            ROIShape shape = (ROIShape)userObject;
            this.childMap.remove(shape);
            this.childCoordMap.remove(shape.getCoord3D());
        }
    }

    public void remove(Coord3D childCoord) {
        ROINode childNode = this.childCoordMap.get(childCoord);
        super.remove((MutableTreeTableNode)childNode);
        Object userObject = childNode.getUserObject();
        if (userObject instanceof ROIShape) {
            ROIShape shape = (ROIShape)userObject;
            this.childMap.remove(shape);
            this.childCoordMap.remove(shape.getCoord3D());
        }
    }

    public Object getValueAt(int column) {
        Object userObject = this.getUserObject();
        if (userObject instanceof ROI) {
            ROI roi = (ROI)userObject;
            switch (column) {
                case 0: {
                    return null;
                }
                case 1: {
                    return roi.getID();
                }
                case 2: {
                    return roi.getTRange();
                }
                case 3: {
                    return roi.getZRange();
                }
                case 4: {
                    return roi.getShapeTypes();
                }
                case 5: {
                    return AnnotationKeys.TEXT.get(roi);
                }
                case 6: {
                    return roi.isVisible();
                }
            }
            return null;
        }
        if (userObject instanceof ROIShape) {
            ROIShape roiShape = (ROIShape)userObject;
            switch (column) {
                case 0: {
                    return null;
                }
                case 1: {
                    return Long.valueOf(roiShape.getID()).toString();
                }
                case 2: {
                    return Integer.valueOf(roiShape.getT() + 1).toString();
                }
                case 3: {
                    Integer z = roiShape.getZ() + 1;
                    return z.toString();
                }
                case 4: {
                    return roiShape.getFigure().getType();
                }
                case 5: {
                    return roiShape.getFigure().getAttribute(MeasurementAttributes.TEXT);
                }
                case 6: {
                    return roiShape.getFigure().isVisible();
                }
            }
            return null;
        }
        return null;
    }

    public void setValueAt(Object value, int column) {
        block13: {
            Object userObject;
            block12: {
                userObject = this.getUserObject();
                if (!(userObject instanceof ROI)) break block12;
                ROI roi = (ROI)userObject;
                switch (column) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 5: {
                        if (!(value instanceof String)) break;
                        roi.setAnnotation(AnnotationKeys.TEXT, (String)value);
                        break;
                    }
                    case 6: {
                        if (!(value instanceof Boolean)) break;
                        for (ROIShape shape : roi.getShapes().values()) {
                            shape.getFigure().setVisible((Boolean)value);
                        }
                    }
                }
                break block13;
            }
            if (userObject instanceof ROIShape) {
                ROIShape roiShape = (ROIShape)userObject;
                ROIFigure figure = roiShape.getFigure();
                switch (column) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        if (!(value instanceof String)) break;
                        AnnotationKeys.TEXT.set(roiShape, (String)value);
                        MeasurementAttributes.TEXT.set(figure, (String)value);
                        if (((String)value).equals("")) {
                            MeasurementAttributes.SHOWTEXT.set(figure, Boolean.valueOf(false));
                            break;
                        }
                        MeasurementAttributes.SHOWTEXT.set(figure, Boolean.valueOf(true));
                        break;
                    }
                    case 6: {
                        if (!(value instanceof Boolean)) break;
                        roiShape.getFigure().setVisible((Boolean)value);
                        break;
                    }
                }
            }
        }
    }
}

