/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeSelectionModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.TabPaneInterface;
import org.openmicroscopy.shoola.agents.measurement.util.model.AnnotationDescription;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROINode;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROITableModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.agents.measurement.view.ROITable;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ObjectManager
extends JPanel
implements TabPaneInterface {
    private static List<String> columnNames = new Vector<String>(8);
    private static Map<String, Integer> columnWidths;
    private static final int INDEX = 1;
    private static final String NAME = "Manager";
    private ROITable objectsTable;
    private MeasurementViewerModel model;
    private MeasurementViewerUI view;
    private TreeSelectionListener treeSelectionListener;

    private void initComponents() {
        ROINode root = new ROINode("root");
        Vector cName = (Vector)columnNames;
        this.objectsTable = new ROITable(new ROITableModel(root, cName), cName, this);
        this.objectsTable.setRootVisible(false);
        this.objectsTable.setColumnSelectionAllowed(true);
        this.objectsTable.setRowSelectionAllowed(true);
        this.treeSelectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreeSelectionModel tsm = ObjectManager.this.objectsTable.getTreeSelectionModel();
                if (tsm.isSelectionEmpty()) {
                    return;
                }
                int[] index = tsm.getSelectionRows();
                if (index.length == 0) {
                    return;
                }
                if (index.length == 1) {
                    ROINode node = (ROINode)ObjectManager.this.objectsTable.getNodeAtRow(ObjectManager.this.objectsTable.getSelectedRow());
                    if (node == null) {
                        return;
                    }
                    Object nodeValue = node.getUserObject();
                    if (nodeValue instanceof ROIShape) {
                        ObjectManager.this.view.selectFigure(((ROIShape)nodeValue).getFigure());
                    }
                    int col = ObjectManager.this.objectsTable.getSelectedColumn();
                    int row = ObjectManager.this.objectsTable.getSelectedRow();
                    if (row < 0 || col < 0) {
                        return;
                    }
                } else {
                    for (int i = 0; i < index.length; ++i) {
                        ROIShape shape = ObjectManager.this.objectsTable.getROIShapeAtRow(index[i]);
                        if (shape == null) continue;
                        ObjectManager.this.view.selectFigure(shape.getFigure());
                        ObjectManager.this.requestFocus();
                    }
                }
            }
        };
        this.objectsTable.addTreeSelectionListener(this.treeSelectionListener);
        ColumnFactory columnFactory = new ColumnFactory(){

            public void configureColumnWidths(JXTable table, TableColumnExt columnExt) {
                columnExt.setPreferredWidth(((Integer)columnWidths.get(columnExt.getHeaderValue())).intValue());
            }
        };
        this.objectsTable.setHorizontalScrollEnabled(true);
        this.objectsTable.setColumnControlVisible(true);
        this.objectsTable.setColumnFactory(columnFactory);
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane((Component)((Object)this.objectsTable)), "Center");
    }

    ObjectManager(MeasurementViewerUI view, MeasurementViewerModel model) {
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.view = view;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    void showROIManagementMenu(int x, int y) {
        this.objectsTable.showROIManagementMenu(this.view.getDrawingView(), x, y);
    }

    void rebuildTable() {
        TreeMap roiList = this.model.getROI();
        Iterator iterator = roiList.values().iterator();
        this.objectsTable.clear();
        while (iterator.hasNext()) {
            ROI roi = (ROI)iterator.next();
            TreeMap<Coord3D, ROIShape> shapeList = roi.getShapes();
            Iterator<ROIShape> shapeIterator = shapeList.values().iterator();
            while (shapeIterator.hasNext()) {
                this.objectsTable.addROIShape(shapeIterator.next());
            }
        }
        this.objectsTable.collapseAll();
    }

    String getComponentName() {
        return NAME;
    }

    Icon getComponentIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(2);
    }

    void addFigures(Collection l) {
        for (ROI roi : l) {
            Iterator<ROIShape> j = roi.getShapes().values().iterator();
            while (j.hasNext()) {
                this.objectsTable.addROIShape(j.next());
            }
        }
    }

    void addROIShapes(List<ROIShape> shapeList) {
        this.objectsTable.addROIShapeList(shapeList);
    }

    void setSelectedFigures(List<ROIShape> l, boolean clear) {
        Iterator<ROIShape> i = l.iterator();
        TreeSelectionModel tsm = this.objectsTable.getTreeSelectionModel();
        ROIFigure figure = null;
        if (clear) {
            tsm.clearSelection();
        }
        this.objectsTable.removeTreeSelectionListener(this.treeSelectionListener);
        try {
            while (i.hasNext()) {
                ROIShape shape = i.next();
                figure = shape.getFigure();
                this.objectsTable.selectROIShape(figure.getROIShape());
            }
            this.objectsTable.repaint();
            if (figure != null) {
                this.objectsTable.scrollToROIShape(figure.getROIShape());
            }
        }
        catch (Exception e) {
            MeasurementAgent.getRegistry().getLogger().info((Object)this, "Figure selection " + e);
        }
        this.objectsTable.addTreeSelectionListener(this.treeSelectionListener);
    }

    void removeFigure(ROIFigure figure) {
        if (figure == null) {
            return;
        }
        this.objectsTable.removeROIShape(figure.getROIShape());
        this.objectsTable.repaint();
    }

    void removeFigures(List<ROIFigure> figures) {
        if (figures == null || figures.size() == 0) {
            return;
        }
        Iterator<ROIFigure> i = figures.iterator();
        while (i.hasNext()) {
            this.objectsTable.removeROIShape(i.next().getROIShape());
        }
        this.objectsTable.repaint();
    }

    void deleteROIShapes(List<ROIShape> shapeList) {
        this.view.deleteROIShapes(shapeList);
        this.rebuildTable();
    }

    void duplicateROI(long id, List<ROIShape> shapeList) {
        this.view.duplicateROI(id, shapeList);
        this.rebuildTable();
    }

    void calculateStats(List<ROIShape> shapeList) {
        this.view.calculateStats(shapeList);
    }

    void mergeROI(List<Long> idList, List<ROIShape> shapeList) {
        this.view.mergeROI(idList, shapeList);
        this.rebuildTable();
    }

    void splitROI(long id, List<ROIShape> shapeList) {
        this.view.splitROI(id, shapeList);
        this.rebuildTable();
    }

    void update() {
        this.objectsTable.refresh();
        this.objectsTable.invalidate();
        this.objectsTable.repaint();
    }

    void propagateROI(ROI roi) {
        this.view.showROIAssistant(roi);
    }

    void showMessage(String messageString) {
        this.view.setStatus(messageString);
    }

    void showReadyMessage() {
        this.view.setReadyStatus();
    }

    void onSelectedFigures() {
        this.objectsTable.onSelectedFigures(this.model.getSelectedFigures());
    }

    Collection<Figure> getSelectedFigures() {
        return this.model.getSelectedFigures();
    }

    @Override
    public int getIndex() {
        return 1;
    }

    static {
        columnNames.add("ROI");
        columnNames.add("id");
        columnNames.add("T");
        columnNames.add("Z");
        columnNames.add("Type");
        columnNames.add(AnnotationDescription.annotationDescription.get(AnnotationKeys.TEXT));
        columnNames.add("Visible");
        columnWidths = new HashMap<String, Integer>();
        columnWidths.put(columnNames.get(0), 80);
        columnWidths.put(columnNames.get(1), 36);
        columnWidths.put(columnNames.get(2), 36);
        columnWidths.put(columnNames.get(3), 36);
        columnWidths.put(columnNames.get(4), 36);
        columnWidths.put(columnNames.get(5), 96);
        columnWidths.put(columnNames.get(6), 36);
    }
}

