/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.agents.measurement.view.ROIAssistantModel;
import org.openmicroscopy.shoola.agents.measurement.view.ROIAssistantTable;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ROIAssistant
extends JDialog
implements ActionListener {
    private static final int CLOSE = 0;
    private ROIAssistantTable table;
    private ROIAssistantModel model;
    private JTextField shapeType;
    private JTextField xCoord;
    private JTextField yCoord;
    private JTextField width;
    private JTextField height;
    private JTextField description;
    private JRadioButton addButton;
    private JRadioButton removeButton;
    private JScrollPane scrollPane;
    private JButton closeButton;
    private MeasurementViewerUI view;
    private ROIShape initialShape;
    private JPanel cornerPane;

    private Point mapCoordToCell(Coord3D coord) {
        int w = this.table.getColumnWidth();
        int h = this.table.getRowHeight();
        int x = coord.getTimePoint() * w;
        int y = (this.table.getRowCount() - coord.getZSection()) * h;
        return new Point(x, y);
    }

    private void buildUI() {
        this.setSize(550, 530);
        JPanel panel = new JPanel();
        JPanel infoPanel = this.createInfoPanel();
        JPanel shapePanel = this.createShapePanel();
        this.createAcceptButton();
        this.createCornerPane();
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setVerticalScrollBar(this.scrollPane.createVerticalScrollBar());
        this.scrollPane.setHorizontalScrollBar(this.scrollPane.createHorizontalScrollBar());
        JPanel scrollPanel = new JPanel();
        scrollPanel.setLayout(new BoxLayout(scrollPanel, 0));
        scrollPanel.add(Box.createHorizontalStrut(10));
        scrollPanel.add(this.scrollPane);
        scrollPanel.add(Box.createHorizontalStrut(10));
        scrollPanel.add(this.createActionPanel());
        scrollPanel.add(Box.createHorizontalStrut(10));
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(infoPanel);
        panel.add(Box.createVerticalStrut(10));
        panel.add(scrollPanel);
        panel.add(Box.createVerticalStrut(10));
        panel.add(shapePanel);
        panel.add(Box.createVerticalStrut(10));
        panel.add(this.closeButton);
        panel.add(Box.createVerticalStrut(10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
    }

    private void createTable(int numRow, int numCol, Coord3D currentPlane, ROI selectedROI) {
        this.model = new ROIAssistantModel(numRow, numCol, currentPlane, selectedROI);
        this.table = new ROIAssistantTable(this.model);
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int col = ROIAssistant.this.table.getSelectedColumn();
                int row = ROIAssistant.this.table.getSelectedRow();
                if (row < 0 || row >= ROIAssistant.this.table.getRowCount() || col < 0 || col > ROIAssistant.this.table.getColumnCount()) {
                    return;
                }
                ROIShape shape = ROIAssistant.this.table.getShapeAt(row, col);
                if (shape != null) {
                    ROIAssistant.this.initialShape = shape;
                    ROIAssistant.this.shapeType.setText(shape.getFigure().getType());
                    ROIAssistant.this.description.setText((String)shape.getFigure().getAttribute(MeasurementAttributes.TEXT));
                    ROIAssistant.this.xCoord.setText(shape.getFigure().getStartPoint().getX() + "");
                    ROIAssistant.this.yCoord.setText(shape.getFigure().getStartPoint().getY() + "");
                    ROIAssistant.this.width.setText(Math.abs(shape.getFigure().getEndPoint().getX() - shape.getFigure().getStartPoint().getX()) + "");
                    ROIAssistant.this.height.setText(Math.abs(shape.getFigure().getEndPoint().getY() - shape.getFigure().getStartPoint().getY()) + "");
                }
            }

            public void mouseReleased(MouseEvent e) {
                int i;
                if (ROIAssistant.this.initialShape == null) {
                    return;
                }
                int[] col = ROIAssistant.this.table.getSelectedColumns();
                int[] row = ROIAssistant.this.table.getSelectedRows();
                for (int i2 = 0; i2 < row.length; ++i2) {
                    row[i2] = ROIAssistant.this.table.getRowCount() - row[i2] - 1;
                }
                int mincol = col[0];
                int maxcol = col[0];
                int minrow = row[0];
                int maxrow = row[0];
                for (i = 0; i < col.length; ++i) {
                    mincol = Math.min(mincol, col[i]);
                    maxcol = Math.max(maxcol, col[i]);
                }
                for (i = 0; i < row.length; ++i) {
                    minrow = Math.min(minrow, row[i]);
                    maxrow = Math.max(maxrow, row[i]);
                }
                if (minrow < 0 || maxrow > ROIAssistant.this.table.getRowCount() || mincol < 0 || maxcol > ROIAssistant.this.table.getColumnCount()) {
                    return;
                }
                int boundcol = maxcol != ROIAssistant.this.initialShape.getT() ? maxcol : mincol;
                int boundrow = maxrow != ROIAssistant.this.initialShape.getZ() ? maxrow : minrow;
                if (ROIAssistant.this.addButton.isSelected()) {
                    ROIAssistant.this.view.propagateShape(ROIAssistant.this.initialShape, boundcol, boundrow);
                }
                if (ROIAssistant.this.removeButton.isSelected()) {
                    ROIAssistant.this.view.deleteShape(ROIAssistant.this.initialShape, boundcol, boundrow);
                }
                ROIAssistant.this.initialShape = null;
                ROIAssistant.this.table.repaint();
            }
        });
    }

    private void createCornerPane() {
        this.cornerPane = new JPanel();
        this.cornerPane.setLayout(new BorderLayout());
        JLabel icon = new JLabel();
        icon.setIcon(IconManager.getInstance().getIcon(39));
        this.cornerPane.add((Component)icon, "Center");
    }

    private JPanel createActionPanel() {
        JPanel actionPanel = new JPanel();
        this.addButton = new JRadioButton("Add ROI");
        this.removeButton = new JRadioButton("Remove ROI");
        ButtonGroup group = new ButtonGroup();
        this.addButton.setSelected(true);
        group.add(this.addButton);
        group.add(this.removeButton);
        actionPanel.setLayout(new BorderLayout());
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 1));
        subPanel.add(this.addButton);
        subPanel.add(this.removeButton);
        actionPanel.add((Component)subPanel, "North");
        return actionPanel;
    }

    private JPanel createInfoPanel() {
        TitlePanel infoPanel = new TitlePanel("ROI Assistant", "The ROI Assistant allows you to create an ROI which extends \nthrough time and z-sections.", IconManager.getInstance().getIcon(10));
        return infoPanel;
    }

    private JPanel createShapePanel() {
        JPanel shapePanel = new JPanel();
        this.shapeType = new JTextField();
        this.description = new JTextField();
        this.xCoord = new JTextField();
        this.yCoord = new JTextField();
        this.width = new JTextField();
        this.height = new JTextField();
        JLabel shapeTypeLabel = new JLabel("Shape Type ");
        JLabel xCoordLabel = new JLabel("X Coord");
        JLabel yCoordLabel = new JLabel("Y Coord");
        JLabel widthLabel = new JLabel("Width");
        JLabel heightLabel = new JLabel("Height");
        JLabel descriptionLabel = new JLabel("Description");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.createLabelText(shapeTypeLabel, this.shapeType));
        panel.add(Box.createVerticalStrut(5));
        panel.add(this.createLabelText(descriptionLabel, this.description));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.add(this.createLabelText(xCoordLabel, this.xCoord));
        panel2.add(Box.createVerticalStrut(5));
        panel2.add(this.createLabelText(yCoordLabel, this.yCoord));
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        panel3.add(this.createLabelText(widthLabel, this.width));
        panel3.add(Box.createVerticalStrut(5));
        panel3.add(this.createLabelText(heightLabel, this.height));
        shapePanel.setLayout(new BoxLayout(shapePanel, 0));
        shapePanel.add(panel);
        shapePanel.add(Box.createHorizontalStrut(10));
        shapePanel.add(panel2);
        shapePanel.add(Box.createHorizontalStrut(10));
        shapePanel.add(panel3);
        return shapePanel;
    }

    private JPanel createLabelText(JLabel l, JTextField t) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(l);
        panel.add(t);
        UIUtilities.setDefaultSize(l, new Dimension(80, 22));
        UIUtilities.setDefaultSize(t, new Dimension(80, 22));
        return panel;
    }

    private void createAcceptButton() {
        this.closeButton = new JButton("Close");
        this.closeButton.setActionCommand("0");
        this.closeButton.addActionListener(this);
    }

    private void closeAssistant() {
        this.setVisible(false);
        this.dispose();
    }

    ROIAssistant(int numRow, int numCol, Coord3D currentPlane, ROI selectedROI, MeasurementViewerUI view) {
        super(view);
        this.view = view;
        this.initialShape = null;
        this.setModal(true);
        this.createTable(numRow, numCol, currentPlane, selectedROI);
        this.buildUI();
        JList rowHeader = new JList(new HeaderListModel(this.table.getRowCount()));
        rowHeader.setFixedCellHeight(this.table.getRowHeight());
        rowHeader.setFixedCellWidth(this.table.getColumnWidth());
        rowHeader.setCellRenderer(new RowHeaderRenderer(this.table));
        this.scrollPane.setRowHeaderView(rowHeader);
        this.scrollPane.setCorner("UPPER_LEFT_CORNER", this.cornerPane);
        JViewport viewPort = this.scrollPane.getViewport();
        Point point = this.mapCoordToCell(currentPlane);
        int x = (int)Math.max(point.getX() - (double)(6 * this.table.getColumnWidth()), 0.0);
        int y = (int)Math.max(point.getY() - (double)(6 * this.table.getColumnWidth()), 0.0);
        viewPort.setViewPosition(new Point(x, y));
    }

    public void actionPerformed(ActionEvent evt) {
        int id = -1;
        try {
            id = Integer.parseInt(evt.getActionCommand());
            switch (id) {
                case 0: {
                    this.closeAssistant();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        public RowHeaderRenderer(JTable table) {
            if (table != null) {
                JTableHeader header = table.getTableHeader();
                this.setOpaque(true);
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                this.setHorizontalAlignment(0);
                this.setHorizontalTextPosition(0);
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    class HeaderListModel
    extends AbstractListModel {
        private String[] headers;

        public HeaderListModel(int n) {
            this.headers = new String[n];
            for (int i = 0; i < n; ++i) {
                this.headers[i] = "" + (n - i);
            }
        }

        public int getSize() {
            return this.headers.length;
        }

        public Object getElementAt(int index) {
            return this.headers[index];
        }
    }
}

