/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationUI;
import org.openmicroscopy.shoola.agents.metadata.editor.DocComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.ui.RatingComponent;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.border.SeparatorOneLineBorder;
import pojos.AnnotationData;
import pojos.BooleanAnnotationData;
import pojos.DataObject;
import pojos.FileAnnotationData;
import pojos.RatingAnnotationData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotationDataUI
extends AnnotationUI
implements ActionListener,
PropertyChangeListener {
    private static final int SHOW_ALL = 0;
    private static final int ADDED_BY_ME = 1;
    private static final int ADDED_BY_OTHERS = 2;
    private static final int MAX = 3;
    private static final String[] NAMES = new String[3];
    private RatingComponent rating;
    private JPanel tagsPane;
    private JPanel docPane;
    private int selectedValue;
    private int initialValue;
    private int tagRow;
    private JPanel content;
    private JButton addTagsButton;
    private JButton addDocsButton;
    private JButton removeDocsButton;
    private JButton removeTagsButton;
    private JButton unrateButton;
    private EditorControl controller;
    private boolean tagFlag;
    private boolean docFlag;
    private List<String> tagNames;
    private Map<String, TagAnnotationData> existingTags;
    private JPopupMenu docSelectionMenu;
    private List<DocComponent> tagsDocList;
    private List<DocComponent> filesDocList;
    private JCheckBox publishedBox;
    private boolean init;
    private JLabel otherRating;
    private JButton filterButton;
    private int filter;
    private List<FileAnnotationData> toReplace;
    private String docConstraints;
    private int docIndex = 0;
    private JComponent docRef;

    private void displayMenu(Component src, Point p) {
        JPopupMenu menu = new JPopupMenu();
        ButtonGroup group = new ButtonGroup();
        JCheckBoxMenuItem item = this.createMenuItem(0);
        group.add(item);
        menu.add(item);
        item = this.createMenuItem(1);
        group.add(item);
        menu.add(item);
        item = this.createMenuItem(2);
        group.add(item);
        menu.add(item);
        menu.show(src, p.x, p.y);
    }

    private JCheckBoxMenuItem createMenuItem(int index) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(NAMES[index]);
        Font f = item.getFont();
        item.setFont(f.deriveFont(f.getStyle(), f.getSize() - 2));
        item.setSelected(this.filter == index);
        item.addActionListener(this);
        item.setActionCommand("" + index);
        return item;
    }

    private void filterAnnotations() {
        Object data;
        this.filterButton.setText(NAMES[this.filter]);
        Iterator<DocComponent> i = this.tagsDocList.iterator();
        ArrayList<Object> nodes = new ArrayList<Object>();
        while (i.hasNext()) {
            data = i.next().getData();
            if (data == null) continue;
            nodes.add(data);
        }
        this.layoutTags(nodes);
        i = this.filesDocList.iterator();
        nodes = new ArrayList();
        while (i.hasNext()) {
            data = i.next().getData();
            if (data == null) continue;
            nodes.add(data);
        }
        this.layoutAttachments(nodes);
        this.buildGUI();
    }

    private JPopupMenu createDocSelectionMenu() {
        if (this.docSelectionMenu != null) {
            return this.docSelectionMenu;
        }
        this.docSelectionMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Local document...");
        item.setToolTipText("Import a local document to the server and attach it.");
        item.addActionListener(this.controller);
        item.setActionCommand("0");
        this.docSelectionMenu.add(item);
        item = new JMenuItem("Uploaded document...");
        item.setToolTipText("Attach a document already uploaded to the server.");
        item.addActionListener(this.controller);
        item.setActionCommand("1");
        this.docSelectionMenu.add(item);
        item = new JMenuItem("New Experiment...");
        item.setEnabled(this.controller.isSingleMode());
        item.setToolTipText("Create a new experiment.");
        item.addActionListener(this.controller);
        item.setActionCommand("6");
        this.docSelectionMenu.add(item);
        return this.docSelectionMenu;
    }

    private void initComponents() {
        this.toReplace = new ArrayList<FileAnnotationData>();
        IconManager icons = IconManager.getInstance();
        this.filter = 0;
        this.filterButton = new JButton(NAMES[0]);
        this.filterButton.setToolTipText("Filter tags and attachments.");
        UIUtilities.unifiedButtonLookAndFeel(this.filterButton);
        Font font = this.filterButton.getFont();
        this.filterButton.setFont(font.deriveFont(font.getStyle(), font.getSize() - 2));
        this.filterButton.setIcon(icons.getIcon(96));
        this.filterButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.filterButton.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent me) {
                Object source = me.getSource();
                if (source instanceof Component) {
                    AnnotationDataUI.this.displayMenu((Component)source, me.getPoint());
                }
            }
        });
        this.otherRating = new JLabel();
        this.otherRating.setBackground(UIUtilities.BACKGROUND_COLOR);
        font = this.otherRating.getFont();
        this.otherRating.setFont(font.deriveFont(2, font.getSize() - 2));
        this.content = new JPanel();
        this.content.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.content.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.tagFlag = false;
        this.docFlag = false;
        this.tagNames = new ArrayList<String>();
        this.tagsDocList = new ArrayList<DocComponent>();
        this.filesDocList = new ArrayList<DocComponent>();
        this.existingTags = new HashMap<String, TagAnnotationData>();
        this.addTagsButton = new JButton(icons.getIcon(56));
        UIUtilities.unifiedButtonLookAndFeel(this.addTagsButton);
        this.addTagsButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addTagsButton.setToolTipText("Add Tags.");
        this.addTagsButton.addActionListener(this.controller);
        this.addTagsButton.setActionCommand("2");
        this.addDocsButton = new JButton(icons.getIcon(56));
        this.addDocsButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addDocsButton.setToolTipText("Attach a document.");
        this.addDocsButton.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (AnnotationDataUI.this.addDocsButton.isEnabled()) {
                    Point p = e.getPoint();
                    AnnotationDataUI.this.createDocSelectionMenu().show(AnnotationDataUI.this.addDocsButton, p.x, p.y);
                }
            }
        });
        UIUtilities.unifiedButtonLookAndFeel(this.addDocsButton);
        this.removeTagsButton = new JButton(icons.getIcon(57));
        UIUtilities.unifiedButtonLookAndFeel(this.removeTagsButton);
        this.removeTagsButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.removeTagsButton.setToolTipText("Unlink Tags.");
        this.removeTagsButton.addActionListener(this.controller);
        this.removeTagsButton.setActionCommand("19");
        this.removeDocsButton = new JButton(icons.getIcon(57));
        UIUtilities.unifiedButtonLookAndFeel(this.removeDocsButton);
        this.removeDocsButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.removeDocsButton.setToolTipText("Unlink Attachments.");
        this.removeDocsButton.addActionListener(this.controller);
        this.removeDocsButton.setActionCommand("20");
        this.initialValue = this.selectedValue = 0;
        this.rating = new RatingComponent(this.selectedValue, 1);
        this.rating.setOpaque(false);
        this.rating.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.rating.addPropertyChangeListener("rate", this);
        this.unrateButton = new JButton(icons.getIcon(57));
        UIUtilities.unifiedButtonLookAndFeel(this.unrateButton);
        this.unrateButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.unrateButton.setToolTipText("Unrate.");
        this.unrateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationDataUI.this.rating.setValue(0);
            }
        });
        this.tagsPane = new JPanel();
        this.tagsPane.setLayout(new BoxLayout(this.tagsPane, 1));
        this.tagsPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        DocComponent doc = new DocComponent(null, this.model);
        this.tagsDocList.add(doc);
        this.tagsPane.add(doc);
        this.docPane = new JPanel();
        this.docPane.setLayout(new BoxLayout(this.docPane, 1));
        this.docPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.docRef = this.docPane;
        doc = new DocComponent(null, this.model);
        this.filesDocList.add(doc);
        this.docPane.add(doc);
        this.publishedBox = new JCheckBox();
        this.publishedBox.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.publishedBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AnnotationDataUI.this.firePropertyChange("save", Boolean.FALSE, Boolean.TRUE);
            }
        });
    }

    private JToolBar createBar(JButton addButton, JButton removeButton) {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setBorder(null);
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.add(addButton);
        if (removeButton != null) {
            bar.add(removeButton);
        }
        return bar;
    }

    private void buildGUI() {
        JLabel l = new JLabel();
        Font f = l.getFont();
        int size = f.getSize() - 1;
        this.content.removeAll();
        this.content.setLayout(new BoxLayout(this.content, 1));
        JPanel p = UIUtilities.buildComponentPanel(this.createBar(this.filterButton, null), 0, 0);
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.content.add(p);
        p = new JPanel(new FlowLayout(0, 0, 0));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(UIUtilities.setTextFont("rate", 1, size));
        p.add(this.createBar(this.unrateButton, null));
        p.add(Box.createHorizontalStrut(2));
        p.add(this.rating);
        this.content.add(p);
        p = new JPanel(new FlowLayout(0, 0, 0));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(UIUtilities.setTextFont("tag", 1, size));
        p.add(this.createBar(this.addTagsButton, this.removeTagsButton));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(UIUtilities.BACKGROUND_COLOR);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridwidth = -1;
        c.fill = 0;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        panel.add((Component)p, c);
        p = new JPanel(new FlowLayout(0, 0, 0));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(UIUtilities.setTextFont("attachment", 1, size));
        p.add(this.createBar(this.addDocsButton, this.removeDocsButton));
        c.gridy = 3;
        panel.add((Component)p, c);
        c.gridy = 0;
        ++c.gridx;
        c.ipady = 2;
        c.gridheight = 2;
        panel.add((Component)this.tagsPane, c);
        c.gridy = 3;
        panel.add((Component)this.docRef, c);
        this.content.add(panel);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setBackground(UIUtilities.BACKGROUND);
        this.setBorder(new SeparatorOneLineBorder());
        this.add(this.content);
    }

    private JPanel initRow() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        return p;
    }

    private void layoutAttachments(Collection list) {
        DocComponent doc;
        this.docPane.removeAll();
        this.filesDocList.clear();
        int h = 0;
        if (list != null && list.size() > 0) {
            Iterator i = list.iterator();
            LinkedHashMap<FileAnnotationData, DocComponent> loadThumbnails = new LinkedHashMap<FileAnnotationData, DocComponent>();
            switch (this.filter) {
                case 0: {
                    DataObject data;
                    while (i.hasNext()) {
                        data = (DataObject)i.next();
                        if (this.toReplace.contains(data)) continue;
                        doc = new DocComponent(data, this.model);
                        doc.addPropertyChangeListener(this.controller);
                        if (doc.hasThumbnailToLoad()) {
                            loadThumbnails.put((FileAnnotationData)data, doc);
                        }
                        this.filesDocList.add(doc);
                        this.docPane.add(doc);
                        int v = doc.getPreferredSize().height;
                        if (h >= v) continue;
                        h = v;
                    }
                    break;
                }
                case 2: {
                    DataObject data;
                    List<Long> immutable = this.model.getImmutableAnnotationIds();
                    while (i.hasNext()) {
                        data = (DataObject)i.next();
                        if (this.toReplace.contains(data)) continue;
                        doc = new DocComponent(data, this.model);
                        doc.addPropertyChangeListener(this.controller);
                        this.filesDocList.add(doc);
                        if (!immutable.contains(data.getId())) continue;
                        if (doc.hasThumbnailToLoad()) {
                            loadThumbnails.put((FileAnnotationData)data, doc);
                        }
                        this.docPane.add(doc);
                        int v = doc.getPreferredSize().height;
                        if (h >= v) continue;
                        h = v;
                    }
                    break;
                }
                case 1: {
                    DataObject data;
                    List<Long> immutable = this.model.getImmutableAnnotationIds();
                    while (i.hasNext()) {
                        data = (DataObject)i.next();
                        if (this.toReplace.contains(data)) continue;
                        doc = new DocComponent(data, this.model);
                        doc.addPropertyChangeListener(this.controller);
                        this.filesDocList.add(doc);
                        if (immutable.contains(data.getId())) continue;
                        if (doc.hasThumbnailToLoad()) {
                            loadThumbnails.put((FileAnnotationData)data, doc);
                        }
                        this.docPane.add(doc);
                        int v = doc.getPreferredSize().height;
                        if (h >= v) continue;
                        h = v;
                    }
                    break;
                }
            }
        }
        if (this.filesDocList.size() == 0 || this.docPane.getComponentCount() == 0) {
            doc = new DocComponent(null, this.model);
            this.filesDocList.add(doc);
            this.docPane.add(doc);
        }
        int n = this.docPane.getComponentCount();
        this.docRef = this.docPane;
        if (n >= 3) {
            Dimension d = this.docPane.getPreferredSize();
            JScrollPane sp = new JScrollPane(this.docPane);
            int width = d.width + 20;
            if (width < 200) {
                width = 200;
            }
            sp.getViewport().setPreferredSize(new Dimension(width, h * 3));
            this.docRef = sp;
        }
        this.docPane.revalidate();
        this.docPane.repaint();
    }

    private void layoutTags(Collection list) {
        DocComponent doc;
        this.tagsPane.removeAll();
        this.tagsDocList.clear();
        if (list != null && list.size() > 0) {
            Iterator i = list.iterator();
            int width = 0;
            JPanel p = this.initRow();
            switch (this.filter) {
                case 0: {
                    while (i.hasNext()) {
                        doc = new DocComponent(i.next(), this.model);
                        doc.addPropertyChangeListener(this.controller);
                        this.tagsDocList.add(doc);
                        if (width + doc.getPreferredSize().width >= 200) {
                            this.tagsPane.add(p);
                            p = this.initRow();
                            width = 0;
                        } else {
                            width += doc.getPreferredSize().width;
                            width += 2;
                        }
                        p.add(doc);
                    }
                    break;
                }
                case 1: {
                    List<Long> immutable = this.model.getImmutableAnnotationIds();
                    while (i.hasNext()) {
                        DataObject data = (DataObject)i.next();
                        doc = new DocComponent(data, this.model);
                        doc.addPropertyChangeListener(this.controller);
                        this.tagsDocList.add(doc);
                        if (immutable.contains(data.getId())) continue;
                        if (width + doc.getPreferredSize().width >= 200) {
                            this.tagsPane.add(p);
                            p = this.initRow();
                            width = 0;
                        } else {
                            width += doc.getPreferredSize().width;
                            width += 2;
                        }
                        p.add(doc);
                    }
                    break;
                }
                case 2: {
                    List<Long> immutable = this.model.getImmutableAnnotationIds();
                    while (i.hasNext()) {
                        DataObject data = (DataObject)i.next();
                        doc = new DocComponent(data, this.model);
                        doc.addPropertyChangeListener(this.controller);
                        this.tagsDocList.add(doc);
                        if (!immutable.contains(data.getId())) continue;
                        if (width + doc.getPreferredSize().width >= 200) {
                            this.tagsPane.add(p);
                            p = this.initRow();
                            width = 0;
                        } else {
                            width += doc.getPreferredSize().width;
                            width += 2;
                        }
                        p.add(doc);
                    }
                    break;
                }
            }
            if (p.getComponentCount() == 0) {
                switch (this.filter) {
                    case 1: 
                    case 2: {
                        doc = new DocComponent(null, this.model);
                        this.tagsDocList.add(doc);
                        this.tagsPane.add(doc);
                    }
                }
            } else {
                this.tagsPane.add(p);
            }
        }
        if (this.tagsDocList.size() == 0) {
            doc = new DocComponent(null, this.model);
            this.tagsDocList.add(doc);
            this.tagsPane.add(doc);
        }
        this.tagsPane.revalidate();
        this.tagsPane.repaint();
    }

    AnnotationDataUI(EditorModel model, EditorControl controller) {
        super(model);
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.controller = controller;
        this.initComponents();
        this.init = false;
    }

    @Override
    protected void buildUI() {
        this.selectedValue = 0;
        String text = "";
        if (!this.model.isMultiSelection()) {
            this.selectedValue = this.model.getUserRating();
            int n = this.model.getRatingCount();
            if (n > 0) {
                text = text + "(avg:" + this.model.getRatingAverage() + " | " + n + " vote";
                if (n > 1) {
                    text = text + "s";
                }
                text = text + ")";
            }
        }
        this.otherRating.setText(text);
        this.initialValue = this.selectedValue;
        this.rating.setValue(this.selectedValue);
        this.publishedBox.setSelected(this.model.hasBeenPublished());
        Collection l = this.model.getAttachments();
        int count = 0;
        ArrayList<FileAnnotationData> v = null;
        if (l != null) {
            v = new ArrayList<FileAnnotationData>();
            Iterator k = l.iterator();
            boolean b = false;
            while (k.hasNext()) {
                FileAnnotationData data = (FileAnnotationData)k.next();
                b = this.isEditorFile(data.getFileName());
                if (!b) {
                    b = this.isEditorFile(data.getNameSpace());
                }
                if (b) continue;
                v.add(data);
            }
            count += v.size();
        }
        this.layoutAttachments(v);
        Object refObject = this.model.getRefObject();
        if (!this.model.isMultiSelection()) {
            l = this.model.getTags();
            if (l != null) {
                count += l.size();
            }
            this.layoutTags(l);
        }
        this.filterButton.setEnabled(count > 0);
        boolean enabled = this.model.isWritable();
        this.rating.setEnabled(enabled);
        this.addTagsButton.setEnabled(enabled);
        this.addDocsButton.setEnabled(enabled);
        this.unrateButton.setEnabled(enabled);
        this.removeTagsButton.setEnabled(enabled);
        this.removeDocsButton.setEnabled(enabled);
        this.buildGUI();
    }

    boolean isEditorFile(String value) {
        if (EditorUtil.isEditorFile(value)) {
            return true;
        }
        return "openmicroscopy.org/omero/editor/experiment".equals(value) || "openmicroscopy.org/omero/editor/protocol".equals(value);
    }

    boolean attachFile(File file) {
        Object data;
        List<FileAnnotationData> list = this.getCurrentAttachmentsSelection();
        boolean exist = false;
        if (this.filesDocList.size() > 0) {
            for (DocComponent doc : this.filesDocList) {
                data = doc.getData();
                if (!(data instanceof FileAnnotationData)) continue;
                FileAnnotationData fa = (FileAnnotationData)data;
                if (fa.getId() <= 0L) {
                    if (fa.getFilePath().equals(file.getAbsolutePath())) {
                        exist = true;
                    }
                    list.add(fa);
                    continue;
                }
                if (!fa.getFileName().equals(file.getName())) continue;
                this.toReplace.add(fa);
            }
        }
        if (!exist) {
            data = null;
            try {
                this.docFlag = true;
                list.add(new FileAnnotationData(file));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.firePropertyChange("save", Boolean.FALSE, Boolean.TRUE);
        }
        this.layoutAttachments(list);
        return !exist;
    }

    void removeAttachedFile(Object file) {
        FileAnnotationData data;
        if (file == null) {
            return;
        }
        FileAnnotationData fData = (FileAnnotationData)file;
        List<FileAnnotationData> attachments = this.getCurrentAttachmentsSelection();
        Iterator<FileAnnotationData> i = attachments.iterator();
        ArrayList<FileAnnotationData> toKeep = new ArrayList<FileAnnotationData>();
        while (i.hasNext()) {
            data = i.next();
            if (data.getId() == fData.getId()) continue;
            toKeep.add(data);
        }
        if (this.filesDocList.size() > 0) {
            for (DocComponent doc : this.filesDocList) {
                Object fa = doc.getData();
                if (!(fa instanceof FileAnnotationData) || (data = (FileAnnotationData)fa).getId() > 0L || data.equals(file)) continue;
                toKeep.add(data);
            }
        }
        this.handleObjectsSelection(FileAnnotationData.class, toKeep, true);
    }

    void removeTag(TagAnnotationData tag) {
        if (tag == null) {
            return;
        }
        List<TagAnnotationData> tags = this.getCurrentTagsSelection();
        Iterator<TagAnnotationData> i = tags.iterator();
        ArrayList<TagAnnotationData> toKeep = new ArrayList<TagAnnotationData>();
        while (i.hasNext()) {
            TagAnnotationData data = i.next();
            if (data.getId() == tag.getId()) continue;
            toKeep.add(data);
        }
        this.handleObjectsSelection(TagAnnotationData.class, toKeep, true);
    }

    void handleObjectsSelection(Class type, Collection objects, boolean fire) {
        if (objects == null) {
            return;
        }
        if (TagAnnotationData.class.equals((Object)type)) {
            this.layoutTags(objects);
            ArrayList<Long> ids = new ArrayList<Long>();
            Iterator i = objects.iterator();
            this.tagFlag = false;
            Collection tags = this.model.getTags();
            if (tags == null || tags.size() != objects.size()) {
                this.tagFlag = true;
            } else {
                while (i.hasNext()) {
                    TagAnnotationData tag = (TagAnnotationData)i.next();
                    if (this.model.isAnnotationUsedByUser(tag)) continue;
                    ids.add(tag.getId());
                }
                for (TagAnnotationData tag : tags) {
                    if (ids.contains(tag.getId())) continue;
                    this.tagFlag = true;
                    break;
                }
            }
        } else if (FileAnnotationData.class.equals((Object)type)) {
            this.layoutAttachments(objects);
            ArrayList<Long> ids = new ArrayList<Long>();
            Iterator i = objects.iterator();
            this.docFlag = false;
            Collection attachments = this.model.getAttachments();
            if (attachments == null || attachments.size() != objects.size()) {
                this.docFlag = true;
            } else {
                while (i.hasNext()) {
                    FileAnnotationData data = (FileAnnotationData)i.next();
                    ids.add(data.getId());
                }
                for (FileAnnotationData data : attachments) {
                    if (ids.contains(data.getId())) continue;
                    this.docFlag = true;
                    break;
                }
            }
        }
        this.buildGUI();
        if (fire) {
            this.firePropertyChange("save", (Object)false, (Object)true);
        }
    }

    List<TagAnnotationData> getCurrentTagsSelection() {
        ArrayList<TagAnnotationData> selection = new ArrayList<TagAnnotationData>();
        if (this.tagsDocList.size() == 0) {
            return selection;
        }
        for (DocComponent doc : this.tagsDocList) {
            TagAnnotationData tag;
            Object object = doc.getData();
            if (!(object instanceof TagAnnotationData) || (tag = (TagAnnotationData)object).getId() <= 0L) continue;
            selection.add(tag);
        }
        return selection;
    }

    List<FileAnnotationData> getCurrentAttachmentsSelection() {
        ArrayList<FileAnnotationData> list = new ArrayList<FileAnnotationData>();
        if (this.filesDocList.size() == 0) {
            return list;
        }
        for (DocComponent doc : this.filesDocList) {
            FileAnnotationData data;
            Object object = doc.getData();
            if (!(object instanceof FileAnnotationData) || (data = (FileAnnotationData)object).getId() <= 0L) continue;
            list.add(data);
        }
        return list;
    }

    List<FileAnnotationData> removeAttachedFiles() {
        ArrayList<FileAnnotationData> list = new ArrayList<FileAnnotationData>();
        if (this.filesDocList.size() == 0) {
            this.docFlag = false;
            return list;
        }
        ArrayList<FileAnnotationData> toKeep = new ArrayList<FileAnnotationData>();
        for (DocComponent doc : this.filesDocList) {
            Object object = doc.getData();
            if (doc.canUnlink()) {
                FileAnnotationData data;
                if (!(object instanceof FileAnnotationData) || (data = (FileAnnotationData)object).getId() <= 0L) continue;
                list.add(data);
                continue;
            }
            toKeep.add((FileAnnotationData)object);
        }
        this.handleObjectsSelection(FileAnnotationData.class, toKeep, false);
        if (list.size() == 0) {
            this.docFlag = false;
        }
        return list;
    }

    List<TagAnnotationData> removeTags() {
        ArrayList<TagAnnotationData> list = new ArrayList<TagAnnotationData>();
        if (this.tagsDocList.size() == 0) {
            this.tagFlag = false;
            return list;
        }
        ArrayList<TagAnnotationData> toKeep = new ArrayList<TagAnnotationData>();
        for (DocComponent doc : this.tagsDocList) {
            Object object = doc.getData();
            if (doc.canUnlink()) {
                TagAnnotationData data;
                if (!(object instanceof TagAnnotationData) || (data = (TagAnnotationData)object).getId() <= 0L) continue;
                list.add(data);
                continue;
            }
            toKeep.add((TagAnnotationData)object);
        }
        this.handleObjectsSelection(TagAnnotationData.class, toKeep, false);
        if (list.size() == 0) {
            this.tagFlag = false;
        }
        return list;
    }

    @Override
    protected String getComponentTitle() {
        return "";
    }

    @Override
    protected List<AnnotationData> getAnnotationToRemove() {
        BooleanAnnotationData b;
        Collection original;
        long id;
        Object object;
        ArrayList<Long> idsToKeep;
        RatingAnnotationData rating;
        ArrayList<AnnotationData> l = new ArrayList<AnnotationData>();
        if (this.selectedValue != this.initialValue && this.selectedValue == 0 && (rating = this.model.getUserRatingAnnotation()) != null) {
            l.add((AnnotationData)rating);
        }
        if (this.tagFlag && !this.model.isMultiSelection()) {
            idsToKeep = new ArrayList();
            for (DocComponent doc : this.tagsDocList) {
                TagAnnotationData tag;
                object = doc.getData();
                if (!(object instanceof TagAnnotationData) || (id = (tag = (TagAnnotationData)object).getId()) <= 0L) continue;
                idsToKeep.add(id);
            }
            original = this.model.getTags();
            for (TagAnnotationData tag : original) {
                id = tag.getId();
                if (idsToKeep.contains(id) || this.model.isAnnotationToDelete((AnnotationData)tag)) continue;
                l.add((AnnotationData)tag);
            }
        }
        if (this.docFlag) {
            idsToKeep = new ArrayList<Long>();
            for (DocComponent doc : this.filesDocList) {
                FileAnnotationData fa;
                object = doc.getData();
                if (!(object instanceof FileAnnotationData) || (id = (fa = (FileAnnotationData)object).getId()) <= 0L) continue;
                idsToKeep.add(id);
            }
            original = this.model.getAttachments();
            for (FileAnnotationData fa : original) {
                id = fa.getId();
                if (idsToKeep.contains(id) || this.model.isAnnotationToDelete((AnnotationData)fa)) continue;
                l.add((AnnotationData)fa);
            }
        }
        if (this.model.hasBeenPublished() && !this.publishedBox.isSelected() && (b = this.model.getPublishedAnnotation()).getValue().booleanValue()) {
            l.add((AnnotationData)b);
        }
        return l;
    }

    @Override
    protected List<AnnotationData> getAnnotationToSave() {
        long id;
        Object object;
        AnnotationData annotation;
        ArrayList<Long> ids;
        Iterator j;
        Collection original;
        ArrayList<AnnotationData> l = new ArrayList<AnnotationData>();
        ArrayList added = new ArrayList();
        if (this.tagFlag) {
            Integer count;
            original = this.model.getTags();
            j = original.iterator();
            ids = new ArrayList<Long>();
            while (j.hasNext()) {
                annotation = (AnnotationData)j.next();
                ids.add(annotation.getId());
            }
            Iterator<DocComponent> i = this.tagsDocList.iterator();
            HashMap<Long, Integer> map = new HashMap<Long, Integer>();
            HashMap<Long, AnnotationData> annotations = new HashMap<Long, AnnotationData>();
            while (i.hasNext()) {
                DocComponent doc = i.next();
                object = doc.getData();
                if (!(object instanceof TagAnnotationData)) continue;
                annotation = (AnnotationData)object;
                id = annotation.getId();
                if (!ids.contains(id)) {
                    l.add(annotation);
                    continue;
                }
                count = (Integer)map.get(id);
                if (count != null) {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    map.put(id, count);
                    continue;
                }
                count = 1;
                annotations.put(id, annotation);
                map.put(id, count);
            }
            for (Map.Entry entry : map.entrySet()) {
                count = (Integer)entry.getValue();
                if (count <= 1) continue;
                l.add((AnnotationData)annotations.get(entry.getKey()));
            }
        }
        for (DocComponent doc : this.tagsDocList) {
            object = doc.getData();
            if (!doc.hasBeenModified() || l.contains(annotation = (AnnotationData)object)) continue;
            l.add(annotation);
        }
        if (this.docFlag) {
            original = this.model.getAttachments();
            j = original.iterator();
            ids = new ArrayList();
            while (j.hasNext()) {
                ids.add(((AnnotationData)j.next()).getId());
            }
            for (DocComponent doc : this.filesDocList) {
                object = doc.getData();
                if (!(object instanceof FileAnnotationData) || ids.contains(id = (annotation = (AnnotationData)object).getId())) continue;
                l.add(annotation);
            }
        }
        if (this.selectedValue != this.initialValue) {
            l.add((AnnotationData)new RatingAnnotationData(this.selectedValue));
        }
        if (!this.model.hasBeenPublished() && this.publishedBox.isSelected()) {
            BooleanAnnotationData data = new BooleanAnnotationData(true);
            data.setNameSpace("openmicroscopy.org/omero/insight/published");
            l.add((AnnotationData)data);
        }
        return l;
    }

    @Override
    protected boolean hasDataToSave() {
        if (this.tagFlag || this.docFlag) {
            return true;
        }
        Iterator<DocComponent> i = this.tagsDocList.iterator();
        while (i.hasNext()) {
            if (!i.next().hasBeenModified()) continue;
            return true;
        }
        if (this.model.hasBeenPublished() ? !this.publishedBox.isSelected() : this.publishedBox.isSelected()) {
            return true;
        }
        return this.selectedValue != this.initialValue;
    }

    @Override
    protected void clearData() {
        if (!this.init) {
            this.buildGUI();
            this.init = true;
        }
        this.tagNames.clear();
        this.existingTags.clear();
        this.selectedValue = 0;
        if (!this.model.isMultiSelection()) {
            this.selectedValue = this.model.getUserRating();
        }
        this.initialValue = 0;
        this.otherRating.setText("");
        this.rating.removePropertyChangeListener("rate", this);
        this.rating.setValue(this.selectedValue);
        this.rating.addPropertyChangeListener("rate", this);
        this.publishedBox.setSelected(false);
        this.tagsPane.removeAll();
        this.tagsDocList.clear();
        DocComponent doc = new DocComponent(null, this.model);
        this.tagsDocList.add(doc);
        this.tagsPane.add(doc);
        this.docPane.removeAll();
        this.filesDocList.clear();
        doc = new DocComponent(null, this.model);
        this.filesDocList.add(doc);
        this.docPane.add(doc);
        this.tagFlag = false;
        this.docFlag = false;
        this.content.revalidate();
        this.content.repaint();
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void clearDisplay() {
        this.clearData();
    }

    @Override
    protected void setComponentTitle() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int newValue;
        String name = evt.getPropertyName();
        if ("rate".equals(name) && (newValue = ((Integer)evt.getNewValue()).intValue()) != this.selectedValue) {
            this.selectedValue = newValue;
            this.firePropertyChange("save", Boolean.FALSE, Boolean.TRUE);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                if (index == this.filter) break;
                this.filter = index;
                this.filterAnnotations();
            }
        }
    }

    static {
        AnnotationDataUI.NAMES[0] = "All";
        AnnotationDataUI.NAMES[1] = "Added by Me";
        AnnotationDataUI.NAMES[2] = "Added by Others";
    }
}

