/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import omero.model.AcquisitionMode;
import omero.model.ContrastMethod;
import omero.model.Illumination;
import omero.model.PlaneInfo;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.metadata.editor.AcquisitionDataUI;
import org.openmicroscopy.shoola.agents.metadata.editor.DetectorComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.FilterGroupComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.LightSourceComponent;
import org.openmicroscopy.shoola.agents.util.DataComponent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.model.EnumerationObject;
import org.openmicroscopy.shoola.util.ui.ColourIcon;
import org.openmicroscopy.shoola.util.ui.JLabelButton;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.OMEComboBox;
import org.openmicroscopy.shoola.util.ui.OMETextArea;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ChannelAcquisitionData;
import pojos.ChannelData;
import pojos.DataObject;
import pojos.FilterSetData;
import pojos.LightSourceData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChannelAcquisitionComponent
extends JPanel
implements PropertyChangeListener {
    private static final int GENERAL = 0;
    private AcquisitionDataUI parent;
    private ChannelData channel;
    private OMEComboBox illuminationBox;
    private OMEComboBox contrastMethodBox;
    private OMEComboBox modeBox;
    private Map<String, DataComponent> fieldsGeneral;
    private LightSourceComponent lightPane;
    private DetectorComponent detectorPane;
    private FilterGroupComponent filterSetPane;
    private FilterGroupComponent lightPathPane;
    private JLabelButton unsetGeneral;
    private boolean unsetGeneralShown;
    private JPanel generalPane;
    private boolean init;
    private EditorModel model;
    private JXTaskPane exposureTask;
    private ColourIcon icon;

    private void resetBoxes() {
        List<EnumerationObject> l = this.model.getChannelEnumerations(Editor.ILLUMINATION_TYPE);
        Object[] array = new EnumerationObject[l.size() + 1];
        Iterator<EnumerationObject> j = l.iterator();
        int i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.illuminationBox = EditorUtil.createComboBox(array);
        l = this.model.getChannelEnumerations(Editor.CONTRAST_METHOD);
        array = new EnumerationObject[l.size() + 1];
        j = l.iterator();
        i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.contrastMethodBox = EditorUtil.createComboBox(array);
        l = this.model.getChannelEnumerations(Editor.MODE);
        array = new EnumerationObject[l.size() + 1];
        j = l.iterator();
        i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.modeBox = EditorUtil.createComboBox(array);
        l = this.model.getChannelEnumerations(Editor.BINNING);
        array = new EnumerationObject[l.size() + 1];
        j = l.iterator();
        i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
    }

    private void initComponents() {
        this.resetBoxes();
        this.fieldsGeneral = new LinkedHashMap<String, DataComponent>();
        this.detectorPane = new DetectorComponent(this.parent, this.model);
        this.lightPane = new LightSourceComponent(this.parent, this.model);
        this.unsetGeneral = null;
        this.unsetGeneralShown = false;
        this.generalPane = new JPanel();
        this.generalPane.setBorder(BorderFactory.createTitledBorder("Info"));
        this.generalPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.generalPane.setLayout(new GridBagLayout());
        this.exposureTask = EditorUtil.createTaskPane("Exposure Time");
        this.exposureTask.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void displayUnsetGeneralFields() {
        this.unsetGeneralShown = !this.unsetGeneralShown;
        String s = "Show unset fields";
        if (this.unsetGeneralShown) {
            s = "Hide unset fields";
        }
        this.unsetGeneral.setText(s);
        this.parent.layoutFields(this.generalPane, this.unsetGeneral, this.fieldsGeneral, this.unsetGeneralShown);
    }

    private void transformGeneralSource(Map<String, Object> details) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        List notSet = (List)details.get("NotSet");
        details.remove("NotSet");
        if (notSet.size() > 0 && this.unsetGeneral == null) {
            this.unsetGeneral = this.parent.formatUnsetFieldsControl();
            this.unsetGeneral.setActionID(0L);
            this.unsetGeneral.addPropertyChangeListener(this);
        }
        Set<Map.Entry<String, Object>> entrySet = details.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            JComponent area;
            Object selected;
            String key = entry.getKey();
            boolean set = !notSet.contains(key);
            Object value = entry.getValue();
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            if ("Illumination".equals(key)) {
                selected = this.model.getChannelEnumerationSelected(Editor.ILLUMINATION_TYPE, (String)value);
                if (selected != null) {
                    this.illuminationBox.setSelectedItem(selected);
                } else {
                    set = false;
                    this.illuminationBox.setSelectedIndex(this.illuminationBox.getItemCount() - 1);
                }
                this.illuminationBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.illuminationBox;
            } else if ("Contrast Method".equals(key)) {
                selected = this.model.getChannelEnumerationSelected(Editor.ILLUMINATION_TYPE, (String)value);
                if (selected != null) {
                    this.contrastMethodBox.setSelectedItem(selected);
                } else {
                    set = false;
                    this.contrastMethodBox.setSelectedIndex(this.contrastMethodBox.getItemCount() - 1);
                }
                this.contrastMethodBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.contrastMethodBox;
            } else if ("Mode".equals(key)) {
                selected = this.model.getChannelEnumerationSelected(Editor.MODE, (String)value);
                if (selected != null) {
                    this.modeBox.setSelectedItem(selected);
                } else {
                    set = false;
                    this.modeBox.setSelectedIndex(this.modeBox.getItemCount() - 1);
                }
                this.modeBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.modeBox;
            } else if (value instanceof Number) {
                area = UIUtilities.createComponent(NumericalTextField.class, null);
                String v = "";
                if (value instanceof Double) {
                    v = "" + UIUtilities.roundTwoDecimals(((Number)value).doubleValue());
                    ((NumericalTextField)area).setNumberType(Double.class);
                } else if (value instanceof Float) {
                    v = "" + UIUtilities.roundTwoDecimals(((Number)value).doubleValue());
                    ((NumericalTextField)area).setNumberType(Float.class);
                } else {
                    v = "" + value;
                }
                ((NumericalTextField)area).setText(v);
                ((NumericalTextField)area).setEditedColor(UIUtilities.EDITED_COLOR);
            } else {
                area = UIUtilities.createComponent(OMETextArea.class, null);
                if (value == null || value.equals("")) {
                    set = false;
                    value = "None";
                }
                ((OMETextArea)area).setEditable(false);
                ((OMETextArea)area).setText((String)value);
                ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            }
            area.setEnabled(!set);
            DataComponent comp = new DataComponent(label, area);
            comp.setEnabled(false);
            comp.setSetField(!notSet.contains(key));
            this.fieldsGeneral.put(key, comp);
        }
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.parent.layoutFields(this.generalPane, this.unsetGeneral, this.fieldsGeneral, this.unsetGeneralShown);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 2, 2, 0);
        constraints.weightx = 1.0;
        constraints.gridy = 0;
        if (this.generalPane.isVisible()) {
            this.add((Component)this.generalPane, constraints);
            ++constraints.gridy;
        }
        if (this.detectorPane.isVisible()) {
            this.add((Component)this.detectorPane, constraints);
            ++constraints.gridy;
        }
        if (this.lightPane.isVisible()) {
            this.add((Component)this.lightPane, constraints);
            ++constraints.gridy;
        }
        if (this.lightPathPane != null) {
            this.add((Component)this.lightPathPane, constraints);
            ++constraints.gridy;
        }
        if (this.filterSetPane != null) {
            this.add((Component)this.filterSetPane, constraints);
            ++constraints.gridy;
        }
        constraints.fill = 2;
        this.add((Component)this.exposureTask, constraints);
        this.parent.attachListener(this.fieldsGeneral);
    }

    ChannelAcquisitionComponent(AcquisitionDataUI parent, EditorModel model, ChannelData channel) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("No parent.");
        }
        if (channel == null) {
            throw new IllegalArgumentException("No channel.");
        }
        this.model = model;
        this.channel = channel;
        this.parent = parent;
        this.initComponents();
    }

    int getChannelIndex() {
        return this.channel.getIndex();
    }

    void setChannelColor(Color color) {
        if (color == null) {
            return;
        }
        if (this.icon == null) {
            this.icon = new ColourIcon(color);
            this.icon.paintLineBorder(true);
        } else {
            this.icon.setColour(color);
        }
    }

    Icon getIcon() {
        return this.icon;
    }

    void setChannelAcquisitionData(int index) {
        if (this.channel.getIndex() != index) {
            return;
        }
        if (!this.init) {
            FilterSetData set;
            this.init = true;
            this.resetBoxes();
            this.removeAll();
            this.fieldsGeneral.clear();
            ChannelAcquisitionData data = this.model.getChannelAcquisitionData(this.channel.getIndex());
            Map<String, Object> details = EditorUtil.transformChannelData(this.channel);
            List notSet = (List)details.get("NotSet");
            this.generalPane.setVisible(false);
            if (notSet.size() != 10) {
                this.transformGeneralSource(details);
                this.generalPane.setVisible(true);
            }
            details = EditorUtil.transformDetectorAndSettings(data);
            notSet = (List)details.get("NotSet");
            this.detectorPane.setVisible(false);
            if (notSet.size() != 12) {
                this.detectorPane.displayDetector(details);
                this.detectorPane.setVisible(true);
            }
            details = EditorUtil.transformLightSourceAndSetting(data);
            String kind = (String)details.get("Light");
            details.remove("Light");
            notSet = (List)details.get("NotSet");
            this.lightPane.setVisible(false);
            int n = 9;
            if (LightSourceData.LASER.equals(kind)) {
                n = 15;
            }
            if (notSet.size() != n) {
                this.lightPane.displayLightSource(kind, details);
                this.lightPane.setVisible(true);
            }
            if ((set = data.getFilterSet()) != null) {
                this.filterSetPane = new FilterGroupComponent(this.parent, this.model, (DataObject)set);
            }
            if ((set = data.getLightPath()) != null) {
                this.lightPathPane = new FilterGroupComponent(this.parent, this.model, (DataObject)set);
            }
            this.buildGUI();
        }
    }

    void setPlaneInfo(int index) {
        if (this.channel.getIndex() != index) {
            return;
        }
        Collection result = this.model.getChannelPlaneInfo(index);
        Object[][] values = new String[1][result.size()];
        Object[] names = new String[result.size()];
        int i = 0;
        for (PlaneInfo info : result) {
            Map<String, Object> details = EditorUtil.transformPlaneInfo(info);
            List notSet = (List)details.get("NotSet");
            values[0][i] = !notSet.contains("Exposure Time") ? details.get("Exposure Time") + "s" : "--";
            names[i] = "t=" + (i + 1);
            ++i;
        }
        JTable table = new JTable(values, names);
        table.setAutoResizeMode(0);
        table.setShowGrid(true);
        table.setGridColor(Color.LIGHT_GRAY);
        JScrollPane pane = new JScrollPane(table);
        Dimension d = table.getPreferredSize();
        Dimension de = this.exposureTask.getPreferredSize();
        pane.setPreferredSize(new Dimension(de.width - 10, 4 * d.height));
        this.exposureTask.add((Component)pane);
    }

    boolean hasDataToSave() {
        boolean b = this.parent.hasDataToSave(this.fieldsGeneral);
        if (b) {
            return true;
        }
        b = this.detectorPane.hasDataToSave();
        if (b) {
            return true;
        }
        b = this.lightPane.hasDataToSave();
        if (b) {
            return true;
        }
        if (this.lightPathPane != null && (b = this.lightPathPane.hasDataToSave())) {
            return true;
        }
        return this.filterSetPane != null && (b = this.filterSetPane.hasDataToSave());
    }

    List<Object> prepareDataToSave() {
        ArrayList<Object> data = new ArrayList<Object>();
        if (!this.hasDataToSave()) {
            return data;
        }
        if (this.channel.isDirty()) {
            for (Map.Entry<String, DataComponent> entry : this.fieldsGeneral.entrySet()) {
                EnumerationObject enumObject;
                Number number;
                String key = entry.getKey();
                DataComponent comp = entry.getValue();
                if (!comp.isDirty()) continue;
                Object value = comp.getAreaValue();
                if ("Name".equals(key)) {
                    this.channel.setName((String)value);
                    continue;
                }
                if ("Pinhole size (\u00b5m)".equals(key)) {
                    number = UIUtilities.extractNumber((String)value, Float.class);
                    if (number == null) continue;
                    this.channel.setPinholeSize((double)((Float)number).floatValue());
                    continue;
                }
                if ("NDFilter (%)".equals(key)) {
                    number = UIUtilities.extractNumber((String)value, Float.class);
                    if (number == null) continue;
                    this.channel.setNDFilter((double)((Float)number).floatValue());
                    continue;
                }
                if ("PockelCell".equals(key)) {
                    number = UIUtilities.extractNumber((String)value, Integer.class);
                    if (number == null) continue;
                    this.channel.setPockelCell(((Integer)value).intValue());
                    continue;
                }
                if ("Emission".equals(key)) {
                    number = UIUtilities.extractNumber((String)value, Integer.class);
                    if (number == null) continue;
                    this.channel.setEmissionWavelength(((Integer)number).intValue());
                    continue;
                }
                if ("Excitation".equals(key)) {
                    number = UIUtilities.extractNumber((String)value, Integer.class);
                    if (number == null) continue;
                    this.channel.setExcitationWavelength(((Integer)number).intValue());
                    continue;
                }
                if ("Illumination".equals(key)) {
                    enumObject = (EnumerationObject)value;
                    if (!(enumObject.getObject() instanceof Illumination)) continue;
                    this.channel.setIllumination((Illumination)enumObject.getObject());
                    continue;
                }
                if ("Mode".equals(key)) {
                    enumObject = (EnumerationObject)value;
                    if (!(enumObject.getObject() instanceof AcquisitionMode)) continue;
                    this.channel.setMode((AcquisitionMode)enumObject.getObject());
                    continue;
                }
                if (!"Contrast Method".equals(key) || !((enumObject = (EnumerationObject)value).getObject() instanceof ContrastMethod)) continue;
                this.channel.setContrastMethod((ContrastMethod)enumObject.getObject());
            }
            data.add(this.channel);
        }
        return data;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selected".equals(name)) {
            this.displayUnsetGeneralFields();
        } else if ("collapsed".equals(name)) {
            this.parent.loadPlaneInfo(this.channel.getIndex());
        }
    }
}

