/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.metadata.editor.AcquisitionDataUI;
import org.openmicroscopy.shoola.agents.metadata.editor.DetectorComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.DichroicComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.FilterComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.FilterGroupComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.LightSourceComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.ObjectiveComponent;
import org.openmicroscopy.shoola.agents.util.DataComponent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.model.EnumerationObject;
import org.openmicroscopy.shoola.util.ui.JLabelButton;
import org.openmicroscopy.shoola.util.ui.OMEComboBox;
import org.openmicroscopy.shoola.util.ui.OMETextArea;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DataObject;
import pojos.DetectorData;
import pojos.DichroicData;
import pojos.FilterData;
import pojos.InstrumentData;
import pojos.LightSourceData;
import pojos.ObjectiveData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InstrumentComponent
extends JPanel
implements PropertyChangeListener {
    private EditorModel model;
    private AcquisitionDataUI parent;
    private boolean init;
    private JLabelButton unsetMicroscope;
    private boolean unsetMicroscopeShown;
    private JPanel microscopePane;
    private Map<String, DataComponent> fieldsMicroscope;
    private OMEComboBox microscopeBox;

    private void resetBoxes() {
        List<EnumerationObject> l = this.model.getChannelEnumerations(Editor.MICROSCOPE_TYPE);
        Object[] array = new EnumerationObject[l.size() + 1];
        Iterator<EnumerationObject> j = l.iterator();
        int i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.microscopeBox = EditorUtil.createComboBox(array);
    }

    private void displayUnsetMicroscopeFields() {
        this.unsetMicroscopeShown = !this.unsetMicroscopeShown;
        String s = "Show unset fields";
        if (this.unsetMicroscopeShown) {
            s = "Hide unset fields";
        }
        this.unsetMicroscope.setText(s);
        this.parent.layoutFields(this.microscopePane, this.unsetMicroscope, this.fieldsMicroscope, this.unsetMicroscopeShown);
    }

    private void initComponents() {
        this.resetBoxes();
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new BoxLayout(this, 1));
        this.fieldsMicroscope = new LinkedHashMap<String, DataComponent>();
        this.microscopePane = new JPanel();
        this.parent.format(this.microscopePane, "Microscope");
    }

    private void transformMicroscope(Map<String, Object> details) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        List notSet = (List)details.get("NotSet");
        details.remove("NotSet");
        if (notSet.size() > 0 && this.unsetMicroscope == null) {
            this.unsetMicroscope = this.parent.formatUnsetFieldsControl();
            this.unsetMicroscope.addPropertyChangeListener(this);
        }
        Set<Map.Entry<String, Object>> entrySet = details.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            JComponent area;
            String key = entry.getKey();
            boolean set = !notSet.contains(key);
            Object value = entry.getValue();
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            if ("Type".equals(key)) {
                Object selected = this.model.getChannelEnumerationSelected(Editor.MICROSCOPE_TYPE, (String)value);
                if (selected != null) {
                    this.microscopeBox.setSelectedItem(selected);
                } else {
                    set = false;
                    notSet.add(key);
                    this.microscopeBox.setSelectedIndex(this.microscopeBox.getItemCount() - 1);
                }
                this.microscopeBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.microscopeBox;
            } else {
                area = UIUtilities.createComponent(OMETextArea.class, null);
                if (value == null || value.equals("")) {
                    value = "None";
                    set = false;
                }
                ((OMETextArea)area).setText((String)value);
                ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            }
            area.setEnabled(!set);
            DataComponent comp = new DataComponent(label, area);
            comp.setEnabled(false);
            comp.setSetField(!notSet.contains(key));
            this.fieldsMicroscope.put(key, comp);
        }
    }

    private void buildGUI(List<JComponent> components) {
        this.removeAll();
        if (this.microscopePane.isVisible()) {
            this.parent.layoutFields(this.microscopePane, this.unsetMicroscope, this.fieldsMicroscope, this.unsetMicroscopeShown);
            this.add(this.microscopePane);
            this.parent.attachListener(this.fieldsMicroscope);
        }
        Iterator<JComponent> i = components.iterator();
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    InstrumentComponent(AcquisitionDataUI parent, EditorModel model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("No parent.");
        }
        this.parent = parent;
        this.model = model;
        this.initComponents();
    }

    void setInstrumentData() {
        List lights;
        List detectors;
        List sets;
        List dichroics;
        List filters;
        Iterator i;
        this.resetBoxes();
        this.fieldsMicroscope.clear();
        InstrumentData data = this.model.getInstrumentData();
        Map<String, Object> details = EditorUtil.transformMicroscope(data);
        List notSet = (List)details.get("NotSet");
        this.microscopePane.setVisible(false);
        if (notSet.size() != 5) {
            this.microscopePane.setVisible(true);
            this.transformMicroscope(details);
        }
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        List objectives = data.getObjectives();
        if (objectives != null) {
            this.model.sortDataObjectByID(objectives);
            i = objectives.iterator();
            while (i.hasNext()) {
                details = EditorUtil.transformObjective((ObjectiveData)i.next());
                notSet = (List)details.get("NotSet");
                if (notSet.size() == 11) continue;
                ObjectiveComponent op = new ObjectiveComponent(this.parent, this.model);
                op.displayObjective(details);
                components.add(op);
            }
        }
        if ((filters = data.getFilters()) != null) {
            this.model.sortDataObjectByID(filters);
            i = filters.iterator();
            while (i.hasNext()) {
                details = EditorUtil.transformFilter((FilterData)i.next());
                notSet = (List)details.get("NotSet");
                if (notSet.size() == 11) continue;
                FilterComponent fp = new FilterComponent(this.parent, this.model, null);
                fp.displayFilter(details);
                components.add(fp);
            }
        }
        if ((dichroics = data.getDichroics()) != null) {
            this.model.sortDataObjectByID(dichroics);
            i = dichroics.iterator();
            while (i.hasNext()) {
                details = EditorUtil.transformDichroic((DichroicData)i.next());
                notSet = (List)details.get("NotSet");
                if (notSet.size() == 4) continue;
                DichroicComponent dp = new DichroicComponent(this.parent, this.model);
                dp.displayDichroic(details);
                components.add(dp);
            }
        }
        if ((sets = data.getFilterSets()) != null) {
            this.model.sortDataObjectByID(sets);
            i = sets.iterator();
            while (i.hasNext()) {
                FilterGroupComponent g = new FilterGroupComponent(this.parent, this.model, (DataObject)i.next());
                components.add(g);
            }
        }
        if ((detectors = data.getDetectors()) != null) {
            this.model.sortDataObjectByID(detectors);
            i = detectors.iterator();
            while (i.hasNext()) {
                details = EditorUtil.transformDetector((DetectorData)i.next());
                notSet = (List)details.get("NotSet");
                if (notSet.size() == 10) continue;
                DetectorComponent dp = new DetectorComponent(this.parent, this.model);
                dp.displayDetector(details);
                components.add(dp);
            }
        }
        if ((lights = data.getLightSources()) != null) {
            this.model.sortDataObjectByID(lights);
            i = lights.iterator();
            while (i.hasNext()) {
                details = EditorUtil.transformLightSource((LightSourceData)i.next());
                notSet = (List)details.get("NotSet");
                String kind = (String)details.get("Light");
                details.remove("Light");
                int n = 7;
                if (LightSourceData.LASER.equals(kind)) {
                    n = 14;
                }
                if (notSet.size() == n) continue;
                LightSourceComponent lp = new LightSourceComponent(this.parent, this.model);
                lp.displayLightSource(kind, details);
                components.add(lp);
            }
        }
        this.buildGUI(components);
    }

    void setRootObject() {
        this.init = false;
        this.removeAll();
    }

    boolean hasDataToSave() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selected".equals(name)) {
            int id = ((Long)evt.getNewValue()).intValue();
            this.displayUnsetMicroscopeFields();
        }
    }
}

