/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.openmicroscopy.shoola.agents.events.editor.EditFileEvent;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.treeviewer.DataObjectSelectionEvent;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.editorpreview.PreviewPanel;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.omeeditpane.OMEWikiComponent;
import org.openmicroscopy.shoola.util.ui.omeeditpane.WikiDataObject;
import pojos.AnnotationData;
import pojos.ChannelData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.FileAnnotationData;
import pojos.FileData;
import pojos.ImageData;
import pojos.MultiImageData;
import pojos.PixelsData;
import pojos.PlateAcquisitionData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;
import pojos.WellData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertiesUI
extends AnnotationUI
implements ActionListener,
DocumentListener,
FocusListener,
PropertyChangeListener {
    static final String TITLE = "Properties";
    private static final String DEFAULT_PLATE_TYPE = "Type: ";
    private static final String DEFAULT_DESCRIPTION_TEXT = "Description";
    private static final String EXTERNAL_IDENTIFIER = "External Identifier:";
    private static final String ID_TEXT = "ID: ";
    private static final String OWNER_TEXT = "Owner: ";
    private static final int EDIT_NAME = 0;
    private static final int EDIT_DESC = 1;
    private JButton editName;
    private JButton editDescription;
    private String originalName;
    private String originalDisplayedName;
    private String originalDescription;
    private JTextArea namePane;
    private JTextArea typePane;
    private OMEWikiComponent descriptionPane;
    private JPanel namePanel;
    private JPanel descriptionPanel;
    private JLabel idLabel;
    private JLabel ownerLabel;
    private JLabel parentLabel;
    private JLabel gpLabel;
    private JLabel wellLabel;
    private JLabel channelsArea;
    private String modifiedName;
    private Border defaultBorder;
    private EditorControl controller;
    private String text;
    private boolean init;
    private JScrollPane pane;

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.parentLabel = new JLabel();
        Font f = this.parentLabel.getFont();
        Font newFont = f.deriveFont(f.getStyle(), f.getSize() - 2);
        this.parentLabel.setOpaque(false);
        this.parentLabel.setFont(newFont);
        this.parentLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.gpLabel = new JLabel();
        this.gpLabel.setOpaque(false);
        this.gpLabel.setFont(newFont);
        this.gpLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.wellLabel = new JLabel();
        this.wellLabel.setOpaque(false);
        this.wellLabel.setFont(newFont);
        this.wellLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.idLabel = UIUtilities.setTextFont("");
        this.ownerLabel = new JLabel();
        this.ownerLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.namePane = this.createTextPane();
        this.typePane = this.createTextPane();
        this.typePane.setEditable(false);
        this.namePane.setEditable(false);
        this.namePane.addFocusListener(this);
        f = this.namePane.getFont();
        newFont = f.deriveFont(f.getStyle(), f.getSize() - 2);
        this.descriptionPane = new OMEWikiComponent(false);
        try {
            this.descriptionPane.installObjectFormatters();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.descriptionPane.setFont(newFont);
        this.descriptionPane.addPropertyChangeListener(this);
        this.descriptionPane.setEnabled(false);
        this.descriptionPane.setAllowOneClick(true);
        this.descriptionPane.addFocusListener(this);
        this.defaultBorder = this.namePane.getBorder();
        this.namePane.setFont(f.deriveFont(1));
        this.typePane.setFont(f.deriveFont(1));
        this.typePane.setFont(f.deriveFont(f.getStyle(), f.getSize() - 2));
        f = this.parentLabel.getFont();
        this.parentLabel.setFont(f.deriveFont(1));
        this.parentLabel.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        f = this.gpLabel.getFont();
        this.gpLabel.setFont(f.deriveFont(1));
        this.gpLabel.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        f = this.wellLabel.getFont();
        this.wellLabel.setFont(f.deriveFont(1));
        this.wellLabel.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        f = this.ownerLabel.getFont();
        this.ownerLabel.setFont(f.deriveFont(1, f.getSize() - 2));
        this.channelsArea = UIUtilities.createComponent(null);
        IconManager icons = IconManager.getInstance();
        this.editName = new JButton(icons.getIcon(54));
        this.editName.setOpaque(false);
        UIUtilities.unifiedButtonLookAndFeel(this.editName);
        this.editName.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.editName.setToolTipText("Edit the name.");
        this.editName.addActionListener(this);
        this.editName.setActionCommand("0");
        this.editDescription = new JButton(icons.getIcon(54));
        this.editDescription.setOpaque(false);
        UIUtilities.unifiedButtonLookAndFeel(this.editDescription);
        this.editDescription.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.editDescription.setToolTipText("Edit the description.");
        this.editDescription.addActionListener(this);
        this.editDescription.setActionCommand("1");
        this.descriptionPane.setEnabled(false);
    }

    private JPanel layoutPlateContent(PlateData plate) {
        JLabel value;
        JPanel content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        content.setLayout(new GridBagLayout());
        JLabel l = new JLabel();
        Font font = l.getFont();
        int size = font.getSize() - 2;
        LinkedHashMap<JLabel, JComponent> components = new LinkedHashMap<JLabel, JComponent>();
        String v = plate.getPlateType();
        if (v != null && v.trim().length() > 0) {
            l = UIUtilities.setTextFont(DEFAULT_PLATE_TYPE, 1, size);
            value = UIUtilities.createComponent(null);
            value.setFont(font.deriveFont(font.getStyle(), size));
            value.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
            value.setText(v);
            components.put(l, value);
        }
        l = UIUtilities.setTextFont(EXTERNAL_IDENTIFIER, 1, size);
        value = UIUtilities.createComponent(null);
        value.setFont(font.deriveFont(font.getStyle(), size));
        value.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        v = plate.getExternalIdentifier();
        if (v == null || v.length() == 0) {
            v = "Not Set";
        }
        value.setText(v);
        components.put(l, value);
        l = UIUtilities.setTextFont("Status:", 1, size);
        value = UIUtilities.createComponent(null);
        value.setFont(font.deriveFont(font.getStyle(), size));
        value.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        v = plate.getStatus();
        if (v == null || v.length() == 0) {
            v = "Not Set";
        }
        value.setText(v);
        components.put(l, value);
        this.layoutComponents(content, components);
        return content;
    }

    private JPanel layoutScreenContent(ScreenData screen) {
        JPanel content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        content.setLayout(new GridBagLayout());
        JLabel l = new JLabel();
        Font font = l.getFont();
        int size = font.getSize() - 2;
        LinkedHashMap<JLabel, JComponent> components = new LinkedHashMap<JLabel, JComponent>();
        l = UIUtilities.setTextFont("Protocol Identifier:", 1, size);
        JLabel value = UIUtilities.createComponent(null);
        value.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        String v = screen.getProtocolIdentifier();
        if (v == null || v.length() == 0) {
            v = "Not Set";
        }
        value.setText(v);
        components.put(l, value);
        l = UIUtilities.setTextFont("Protocol Description:", 1, size);
        value = UIUtilities.createComponent(null);
        value.setFont(font.deriveFont(font.getStyle(), size));
        value.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        v = screen.getProtocolDescription();
        if (v == null || v.length() == 0) {
            v = "Not Set";
        }
        value.setText(v);
        components.put(l, value);
        l = UIUtilities.setTextFont("ReagentSet Identifier:", 1, size);
        value = UIUtilities.createComponent(null);
        value.setFont(font.deriveFont(font.getStyle(), size));
        value.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        v = screen.getReagentSetIdentifier();
        if (v == null || v.length() == 0) {
            v = "Not Set";
        }
        value.setText(v);
        components.put(l, value);
        l = UIUtilities.setTextFont("ReagentSet Description:", 1, size);
        value = UIUtilities.createComponent(null);
        value.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        value.setFont(font.deriveFont(font.getStyle(), size));
        v = screen.getReagentSetDescripion();
        if (v == null || v.length() == 0) {
            v = "Not Set";
        }
        value.setText(v);
        components.put(l, value);
        this.layoutComponents(content, components);
        return content;
    }

    private void layoutComponents(JPanel pane, Map<JLabel, JComponent> components) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        Set<Map.Entry<JLabel, JComponent>> set = components.entrySet();
        Iterator<Map.Entry<JLabel, JComponent>> i = set.iterator();
        c.gridy = 0;
        while (i.hasNext()) {
            c.gridx = 0;
            Map.Entry<JLabel, JComponent> entry = i.next();
            ++c.gridy;
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            pane.add((Component)entry.getKey(), c);
            ++c.gridx;
            pane.add(Box.createHorizontalStrut(5), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            pane.add((Component)entry.getValue(), c);
        }
    }

    private String formatPixelsSize(Map details, JLabel component) {
        String x = (String)details.get("Pixel size X (\u00b5m)");
        String y = (String)details.get("Pixel size Y (\u00b5m)");
        String z = (String)details.get("Pixel size Z (\u00b5m)");
        Double dx = null;
        Double dy = null;
        Double dz = null;
        boolean number = true;
        NumberFormat nf = NumberFormat.getInstance();
        try {
            dx = Double.parseDouble(x);
        }
        catch (Exception e) {
            number = false;
        }
        try {
            dy = Double.parseDouble(y);
        }
        catch (Exception e) {
            number = false;
        }
        try {
            dz = Double.parseDouble(z);
        }
        catch (Exception e) {
            number = false;
        }
        String label = "Pixels Size (";
        String value = "";
        String tooltip = "<html><body>";
        if (dx != null && dx > 0.0) {
            value = value + nf.format(dx);
            tooltip = tooltip + "X: " + x + "<br>";
            label = label + "X";
        }
        if (dy != null && dy > 0.0) {
            value = value.length() == 0 ? value + nf.format(dy) : value + "x" + nf.format(dy);
            tooltip = tooltip + "Y: " + y + "<br>";
            label = label + "Y";
        }
        if (dz != null && dz > 0.0) {
            value = value.length() == 0 ? value + nf.format(dz) : value + "x" + nf.format(dz);
            tooltip = tooltip + "Z: " + z + "<br>";
            label = label + "Z";
        }
        label = label + ") ";
        if (!number) {
            component.setForeground(AnnotationUI.WARNING);
            component.setToolTipText("Values stored in the file...");
        } else {
            component.setToolTipText(tooltip);
        }
        if (value.length() == 0) {
            return null;
        }
        component.setText(value);
        return label;
    }

    private JPanel buildContentPanel(Map details, ImageData image) {
        JPanel content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        JLabel l = new JLabel();
        Font font = l.getFont();
        int size = font.getSize() - 2;
        JLabel label = UIUtilities.setTextFont("Image Date", 1, size);
        JLabel value = UIUtilities.createComponent(null);
        String v = this.model.formatDate((DataObject)image);
        value.setText(v);
        content.add((Component)label, c);
        c.gridx += 2;
        content.add((Component)value, c);
        ++c.gridy;
        label = UIUtilities.setTextFont("Dimensions (XY)", 1, size);
        value = UIUtilities.createComponent(null);
        v = (String)details.get("Size X");
        v = v + " x ";
        v = v + (String)details.get("Size Y");
        value.setText(v);
        c.gridx = 0;
        content.add((Component)label, c);
        c.gridx += 2;
        content.add((Component)value, c);
        value = UIUtilities.createComponent(null);
        String s = this.formatPixelsSize(details, value);
        if (s != null) {
            ++c.gridy;
            label = UIUtilities.setTextFont(s + "(\u00b5m)", 1, size);
            c.gridx = 0;
            content.add((Component)label, c);
            c.gridx += 2;
            content.add((Component)value, c);
        }
        ++c.gridy;
        label = UIUtilities.setTextFont("z-sections/timepoints", 1, size);
        value = UIUtilities.createComponent(null);
        v = (String)details.get("Number of sections");
        v = v + " x ";
        v = v + (String)details.get("Number of timepoints");
        value.setText(v);
        c.gridx = 0;
        content.add((Component)label, c);
        c.gridx += 2;
        content.add((Component)value, c);
        ++c.gridy;
        if (!this.model.isNumerousChannel() && this.model.getRefObjectID() > 0L) {
            label = UIUtilities.setTextFont("Channels", 1, size);
            c.gridx = 0;
            content.add((Component)label, c);
            c.gridx += 2;
            content.add((Component)this.channelsArea, c);
        }
        JPanel p = UIUtilities.buildComponentPanel(content);
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        return p;
    }

    private JTextArea createTextPane() {
        JTextArea pane = new JTextArea();
        pane.setWrapStyleWord(true);
        pane.setOpaque(false);
        pane.setBackground(UIUtilities.BACKGROUND_COLOR);
        return pane;
    }

    private JPanel layoutEditablefield(Component button, JComponent component) {
        return this.layoutEditablefield(button, component, -1);
    }

    private JPanel layoutEditablefield(Component button, JComponent component, int sizeRow) {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        if (button != null) {
            JToolBar bar = new JToolBar();
            bar.setBorder(null);
            bar.setFloatable(false);
            bar.setBackground(UIUtilities.BACKGROUND_COLOR);
            bar.add(button);
            p.add((Component)bar, c);
        }
        ++c.gridx;
        if (sizeRow > 0) {
            c.ipady = sizeRow;
            c.gridheight = 2;
        }
        p.add((Component)component, c);
        JPanel content = UIUtilities.buildComponentPanel(p, 0, 0);
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        return content;
    }

    private JPanel buildProperties() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new BoxLayout(p, 1));
        JPanel l = UIUtilities.buildComponentPanel(this.idLabel, 0, 0);
        l.setBackground(UIUtilities.BACKGROUND_COLOR);
        int w = this.editName.getIcon().getIconWidth() + 4;
        p.add(this.layoutEditablefield(Box.createHorizontalStrut(w), l));
        l = UIUtilities.buildComponentPanel(this.ownerLabel, 0, 0);
        l.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(this.layoutEditablefield(Box.createHorizontalStrut(w), l));
        l = UIUtilities.buildComponentPanel(this.gpLabel, 0, 0);
        l.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(this.layoutEditablefield(Box.createHorizontalStrut(w), l));
        l = UIUtilities.buildComponentPanel(this.parentLabel, 0, 0);
        l.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(this.layoutEditablefield(Box.createHorizontalStrut(w), l));
        l = UIUtilities.buildComponentPanel(this.wellLabel, 0, 0);
        l.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(this.layoutEditablefield(Box.createHorizontalStrut(w), l));
        this.namePanel = this.layoutEditablefield(this.editName, this.namePane);
        p.add(this.namePanel);
        p.add(Box.createVerticalStrut(5));
        Object refObject = this.model.getRefObject();
        if (refObject instanceof ImageData || refObject instanceof DatasetData || refObject instanceof ProjectData || refObject instanceof TagAnnotationData || refObject instanceof WellSampleData | refObject instanceof PlateData || refObject instanceof ScreenData) {
            p.add(Box.createVerticalStrut(5));
            this.descriptionPanel = this.layoutEditablefield(this.editDescription, this.descriptionPane, 5);
            this.pane = new JScrollPane(this.descriptionPanel);
            this.pane.setBorder(AnnotationUI.EDIT_BORDER);
            Dimension d = this.pane.getPreferredSize();
            this.pane.getViewport().setPreferredSize(new Dimension(d.width, 60));
            p.add(this.pane);
        } else if (refObject instanceof FileData) {
            // empty if block
        }
        p.add(Box.createVerticalStrut(5));
        return p;
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND);
        this.add(this.buildProperties());
        Object refObject = this.model.getRefObject();
        PixelsData data = null;
        ImageData img = null;
        if (refObject instanceof ImageData) {
            img = (ImageData)refObject;
            try {
                data = ((ImageData)refObject).getDefaultPixels();
            }
            catch (Exception e) {}
        } else if (refObject instanceof WellSampleData) {
            img = ((WellSampleData)refObject).getImage();
            if (img != null && img.getId() > 0L) {
                data = img.getDefaultPixels();
            }
        } else if (refObject instanceof FileAnnotationData) {
            String description;
            FileAnnotationData fa = (FileAnnotationData)refObject;
            String ns = fa.getNameSpace();
            if (("openmicroscopy.org/omero/editor/experiment".equals(ns) || "openmicroscopy.org/omero/editor/protocol".equals(ns)) && (description = fa.getDescription()) != null && description.length() > 0) {
                PreviewPanel panel = new PreviewPanel(description, fa.getId());
                panel.addPropertyChangeListener(this.controller);
                this.add(Box.createVerticalStrut(5));
                this.add(panel);
            }
        } else if (refObject instanceof PlateData) {
            this.add(Box.createVerticalStrut(5));
            this.add(this.layoutPlateContent((PlateData)refObject));
        } else if (refObject instanceof ScreenData) {
            this.add(Box.createVerticalStrut(5));
            this.add(this.layoutScreenContent((ScreenData)refObject));
        }
        if (data == null) {
            return;
        }
        this.add(Box.createVerticalStrut(5));
        this.add(this.buildContentPanel(EditorUtil.transformPixelsData(data), img));
    }

    private void editField(JPanel panel, JComponent field, JButton button, boolean editable) {
        if (field == this.namePane) {
            button.setEnabled(editable);
            this.namePane.setEditable(editable);
            if (editable) {
                panel.setBorder(EDIT_BORDER_BLACK);
                field.requestFocus();
            } else {
                panel.setBorder(this.defaultBorder);
            }
            this.namePane.getDocument().removeDocumentListener(this);
            String text = this.namePane.getText();
            if (text != null) {
                text = text.trim();
            }
            if (editable) {
                this.namePane.setText(this.modifiedName);
            } else {
                this.namePane.setText(EditorUtil.getPartialName(text));
            }
            this.namePane.getDocument().addDocumentListener(this);
            this.namePane.select(0, 0);
            this.namePane.setCaretPosition(0);
        } else if (field == this.descriptionPane) {
            this.descriptionPane.setEnabled(editable);
            if (editable) {
                this.pane.setBorder(EDIT_BORDER_BLACK);
                field.requestFocus();
            } else {
                this.pane.setBorder(EDIT_BORDER);
            }
        }
    }

    private void handleNameChanged(Document document) {
        Document d = this.namePane.getDocument();
        if (d == document) {
            this.modifiedName = this.namePane.getText();
        }
    }

    private String getWellLabel(WellData well, int columnIndex, int rowIndex) {
        int k = well.getRow() + 1;
        String rowText = "";
        if (rowIndex == 1) {
            rowText = UIUtilities.LETTERS.get(k);
        } else if (rowIndex == 0) {
            rowText = "" + k;
        }
        k = well.getColumn() + 1;
        String columnText = "";
        if (columnIndex == 1) {
            columnText = UIUtilities.LETTERS.get(k + 1);
        } else if (columnIndex == 0) {
            columnText = "" + k;
        }
        String value = rowText + "-" + columnText;
        return value;
    }

    private void setParentLabel() {
        this.parentLabel.setText("");
        this.wellLabel.setText("");
        this.gpLabel.setText("");
        Object parent = this.model.getParentRootObject();
        if (parent instanceof WellData) {
            WellData well = (WellData)parent;
            PlateData plate = well.getPlate();
            String text = "Plate: ";
            text = text + plate.getName();
            this.parentLabel.setText(text);
            this.parentLabel.repaint();
            text = "Well " + this.getWellLabel(well, plate.getColumnSequenceIndex(), plate.getRowSequenceIndex());
            this.wellLabel.setText(text);
        }
        if ((parent = this.model.getGrandParentRootObject()) instanceof ScreenData) {
            ScreenData screen = (ScreenData)parent;
            this.text = "Screen: ";
            this.text = this.text + screen.getName();
            this.gpLabel.setText(this.text);
            this.gpLabel.repaint();
        }
    }

    PropertiesUI(EditorModel model, EditorControl controller) {
        super(model);
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.controller = controller;
        this.title = TITLE;
        this.initComponents();
        this.init = false;
    }

    @Override
    protected void buildUI() {
        if (!this.init) {
            this.buildGUI();
            this.init = true;
        }
        this.removeAll();
        if (this.model.isMultiSelection()) {
            return;
        }
        this.namePane.getDocument().removeDocumentListener(this);
        this.descriptionPane.removeDocumentListener(this);
        this.originalName = this.model.getRefObjectName();
        this.modifiedName = this.model.getRefObjectName();
        this.originalDisplayedName = EditorUtil.getPartialName(this.originalName);
        this.namePane.setText(this.originalDisplayedName);
        this.namePane.setToolTipText(this.originalName);
        Object refObject = this.model.getRefObject();
        this.text = "";
        boolean b = this.model.isUserOwner(refObject);
        if (refObject instanceof ImageData) {
            this.text = "Image";
        } else if (refObject instanceof DatasetData) {
            this.text = "Dataset";
        } else if (refObject instanceof ProjectData) {
            this.text = "Project";
        } else if (refObject instanceof ScreenData) {
            this.text = "Screen";
        } else if (refObject instanceof PlateData) {
            this.text = "Plate";
        } else if (refObject instanceof PlateAcquisitionData) {
            this.text = "Plate Run";
        } else if (refObject instanceof FileAnnotationData) {
            FileAnnotationData fa = (FileAnnotationData)refObject;
            String ns = fa.getNameSpace();
            this.text = "openmicroscopy.org/omero/editor/experiment".equals(ns) ? "Experiment" : ("openmicroscopy.org/omero/editor/protocol".equals(ns) ? "Protocol" : "File");
        } else if (refObject instanceof WellSampleData) {
            this.text = "Field";
        } else if (refObject instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)refObject;
            this.text = "openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace()) ? "Tag Set" : "Tag";
        } else if (refObject instanceof FileData) {
            this.editName.setEnabled(false);
            FileData f = (FileData)refObject;
            this.text = f.isDirectory() ? "Folder" : "File";
        } else if (refObject instanceof MultiImageData) {
            this.editName.setEnabled(false);
            this.text = "File";
        }
        String t = this.text;
        if (this.model.getRefObjectID() > 0L) {
            t = t + " ID: " + this.model.getRefObjectID();
        }
        this.idLabel.setText(t);
        String ownerName = this.model.getOwnerName();
        if (ownerName != null && ownerName.length() > 0) {
            this.ownerLabel.setText(OWNER_TEXT + ownerName);
        }
        this.originalDescription = this.model.getRefObjectDescription();
        if (this.originalDescription == null || this.originalDescription.length() == 0) {
            this.originalDescription = DEFAULT_DESCRIPTION_TEXT;
        }
        this.descriptionPane.setText(this.originalDescription);
        this.descriptionPane.setCaretPosition(0);
        this.descriptionPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.descriptionPane.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        if (refObject instanceof WellSampleData || refObject instanceof PlateAcquisitionData) {
            b = false;
        }
        this.namePane.setEnabled(b);
        if (!(refObject instanceof FileData)) {
            this.editName.setEnabled(b);
        }
        if (b) {
            this.namePane.getDocument().addDocumentListener(this);
            this.descriptionPane.addDocumentListener(this);
        }
        this.editDescription.setEnabled(b);
        this.setParentLabel();
        this.buildGUI();
    }

    void setFocusOnName() {
        this.namePane.requestFocus();
    }

    void setParentRootObject() {
        Object object = this.model.getRefObject();
        this.setParentLabel();
        if (!(object instanceof WellSampleData)) {
            return;
        }
        this.originalDescription = this.model.getRefObjectDescription();
        if (this.originalDescription == null || this.originalDescription.length() == 0) {
            this.originalDescription = DEFAULT_DESCRIPTION_TEXT;
        }
        this.descriptionPane.setText(this.originalDescription);
        boolean b = this.model.isUserOwner(this.model.getRefObject());
        this.editDescription.setEnabled(b);
        if (b) {
            this.descriptionPane.addDocumentListener(this);
        }
    }

    void updateDataObject() {
        FileData f;
        if (!this.hasDataToSave()) {
            return;
        }
        Object object = this.model.getRefObject();
        String name = this.namePane.getText().trim();
        String desc = this.descriptionPane.getText().trim();
        if (name != null && (name.equals(this.originalName) || name.equals(this.originalDisplayedName))) {
            name = "";
        }
        if (object instanceof ProjectData) {
            ProjectData p = (ProjectData)object;
            if (name.length() > 0) {
                p.setName(name);
            }
            p.setDescription(desc);
        } else if (object instanceof DatasetData) {
            DatasetData p = (DatasetData)object;
            if (name.length() > 0) {
                p.setName(name);
            }
            p.setDescription(desc);
        } else if (object instanceof ImageData) {
            ImageData p = (ImageData)object;
            if (name.length() > 0) {
                p.setName(name);
            }
            p.setDescription(desc);
        } else if (object instanceof TagAnnotationData) {
            TagAnnotationData p = (TagAnnotationData)object;
            if (name.length() > 0) {
                p.setTagValue(name);
            }
            if (desc.length() > 0) {
                p.setTagDescription(desc);
            }
        } else if (object instanceof ScreenData) {
            ScreenData p = (ScreenData)object;
            if (name.length() > 0) {
                p.setName(name);
            }
            p.setDescription(desc);
        } else if (object instanceof PlateData) {
            PlateData p = (PlateData)object;
            if (name.length() > 0) {
                p.setName(name);
            }
            p.setDescription(desc);
        } else if (object instanceof WellSampleData) {
            WellSampleData well = (WellSampleData)object;
            ImageData img = well.getImage();
            if (name.length() > 0) {
                img.setName(name);
            }
            img.setDescription(desc);
        } else if (object instanceof FileData && (f = (FileData)object).getId() > 0L) {
            return;
        }
    }

    boolean isNameValid() {
        String name = this.namePane.getText();
        if (name == null) {
            return false;
        }
        return name.trim().length() != 0;
    }

    void setChannelData(Map channels) {
        if (channels == null) {
            return;
        }
        String s = "";
        int n = channels.size() - 1;
        Iterator k = channels.keySet().iterator();
        int j = 0;
        while (k.hasNext()) {
            s = s + ((ChannelData)k.next()).getChannelLabeling();
            if (j != n) {
                s = s + ", ";
            }
            ++j;
        }
        this.channelsArea.setText(s);
        this.channelsArea.revalidate();
        this.channelsArea.repaint();
    }

    String getText() {
        return this.text;
    }

    @Override
    protected String getComponentTitle() {
        return TITLE;
    }

    @Override
    protected List<AnnotationData> getAnnotationToRemove() {
        return null;
    }

    @Override
    protected List<AnnotationData> getAnnotationToSave() {
        return null;
    }

    @Override
    protected boolean hasDataToSave() {
        if (this.model.isMultiSelection()) {
            return false;
        }
        String name = this.originalName;
        String value = this.namePane.getText();
        value = value.trim();
        if (name == null) {
            return false;
        }
        if (!name.equals(value) && !this.originalDisplayedName.equals(value)) {
            return true;
        }
        name = this.originalDescription;
        value = this.descriptionPane.getText();
        value = value.trim();
        if (name == null) {
            return value.length() != 0;
        }
        if (DEFAULT_DESCRIPTION_TEXT.equals(name = name.trim()) && DEFAULT_DESCRIPTION_TEXT.equals(value)) {
            return false;
        }
        return !value.equals(name);
    }

    @Override
    protected void clearData() {
        this.originalDisplayedName = this.originalName = this.model.getRefObjectName();
        this.originalDescription = this.model.getRefObjectDescription();
        this.namePane.getDocument().removeDocumentListener(this);
        this.descriptionPane.removeDocumentListener(this);
        this.idLabel.setText("");
        this.ownerLabel.setText("");
        this.namePane.setText(this.originalName);
        this.descriptionPane.setText(this.originalDescription);
        this.namePane.getDocument().addDocumentListener(this);
        this.descriptionPane.addDocumentListener(this);
        this.channelsArea.setText("");
    }

    @Override
    protected void clearDisplay() {
    }

    @Override
    protected void setComponentTitle() {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleNameChanged(e.getDocument());
        this.firePropertyChange("save", (Object)false, (Object)true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleNameChanged(e.getDocument());
        this.firePropertyChange("save", (Object)false, (Object)true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.editField(this.namePanel, this.namePane, this.editName, !this.namePane.isEditable());
                break;
            }
            case 1: {
                this.editField(this.descriptionPanel, this.descriptionPane, this.editDescription, !this.descriptionPane.isEnabled());
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object src = e.getSource();
        if (src == this.namePane) {
            this.editField(this.namePanel, this.namePane, this.editName, false);
            String text = this.namePane.getText();
            this.editName.setEnabled(true);
            if (text == null || text.trim().length() == 0) {
                this.namePane.getDocument().removeDocumentListener(this);
                this.namePane.setText(this.modifiedName);
                this.namePane.getDocument().addDocumentListener(this);
            }
        } else if (src == this.descriptionPane) {
            String text = this.descriptionPane.getText();
            this.editDescription.setEnabled(true);
            if (text == null || text.trim().length() == 0) {
                this.descriptionPane.removeDocumentListener(this);
                this.descriptionPane.setText(DEFAULT_DESCRIPTION_TEXT);
                this.descriptionPane.addDocumentListener(this);
                this.firePropertyChange("save", (Object)false, (Object)true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void focusGained(FocusEvent e) {
        String text;
        Object src = e.getSource();
        if (src == this.namePane) {
            String text2 = this.namePane.getText();
            if (text2 == null) return;
        }
        if (src == this.descriptionPane && (text = this.descriptionPane.getText()) == null) return;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
        if ("wikiDataObject".equals(name)) {
            WikiDataObject object = (WikiDataObject)evt.getNewValue();
            long id = object.getId();
            switch (object.getIndex()) {
                case 2: {
                    if (id <= 0L) break;
                    bus.post(new ViewImage(id, null));
                    break;
                }
                case 4: {
                    bus.post(new EditFileEvent(id));
                }
            }
        } else if ("wikiDataObjectOneClick".equals(name)) {
            WikiDataObject object = (WikiDataObject)evt.getNewValue();
            long id = object.getId();
            switch (object.getIndex()) {
                case 2: {
                    bus.post(new DataObjectSelectionEvent(ImageData.class, id));
                    break;
                }
                case 1: {
                    bus.post(new DataObjectSelectionEvent(DatasetData.class, id));
                    break;
                }
                case 0: {
                    bus.post(new DataObjectSelectionEvent(ProjectData.class, id));
                    break;
                }
                case 4: {
                    bus.post(new DataObjectSelectionEvent(FileData.class, id));
                }
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

