/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.TextualAnnotationComponent;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.border.SeparatorOneLineBorder;
import org.openmicroscopy.shoola.util.ui.omeeditpane.OMEWikiComponent;
import pojos.AnnotationData;
import pojos.TextualAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TextualAnnotationsUI
extends AnnotationUI
implements ActionListener,
DocumentListener,
FocusListener {
    private static final int MAX_LENGTH_TEXT = 200;
    private static final String DEFAULT_TEXT_COMMENT = "Comments";
    private static final String TITLE = "Comments ";
    private static final int HIDE = 2;
    private static final int MORE = 3;
    private EditorControl controller;
    private OMEWikiComponent commentArea;
    private JPanel moreComponent;
    private JPanel hideComponent;
    private JButton inBetweenComponent;
    private String originalText;
    private JScrollPane previousComments;
    private boolean init;
    private boolean expanded;
    private boolean partial;
    private GridBagConstraints constraints;

    private JPanel displayAllPreviousComments() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new BoxLayout(p, 1));
        List list = this.model.getTextualAnnotationsByDate();
        if (list != null) {
            Iterator i = list.iterator();
            int index = 0;
            while (i.hasNext()) {
                TextualAnnotationData data = (TextualAnnotationData)i.next();
                TextualAnnotationComponent comp = new TextualAnnotationComponent(this.model, data);
                if (index % 2 == 0) {
                    comp.setAreaColor(UIUtilities.BACKGROUND_COLOUR_EVEN);
                } else {
                    comp.setAreaColor(UIUtilities.BACKGROUND_COLOUR_ODD);
                }
                p.add(comp);
                ++index;
            }
        }
        return p;
    }

    private JPanel displayPartialPreviousComments() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new BoxLayout(p, 1));
        List list = this.model.getTextualAnnotationsByDate();
        if (list == null || list.size() == 0) {
            return p;
        }
        TextualAnnotationData data = (TextualAnnotationData)list.get(0);
        TextualAnnotationComponent comp = new TextualAnnotationComponent(this.model, data);
        comp.setAreaColor(UIUtilities.BACKGROUND_COLOUR_EVEN);
        p.add(comp);
        int n = list.size();
        if (n == 1) {
            return p;
        }
        Color c = UIUtilities.BACKGROUND_COLOUR_ODD;
        if (n > 2) {
            JPanel lp = UIUtilities.buildComponentPanel(this.inBetweenComponent, 0, 0);
            this.inBetweenComponent.setBackground(UIUtilities.BACKGROUND_COLOUR_ODD);
            lp.setBackground(UIUtilities.BACKGROUND_COLOUR_ODD);
            p.add(lp);
            c = UIUtilities.BACKGROUND_COLOUR_EVEN;
        }
        data = (TextualAnnotationData)list.get(n - 1);
        comp = new TextualAnnotationComponent(this.model, data);
        comp.setAreaColor(c);
        p.add(comp);
        return p;
    }

    private boolean hasPreviousTextualAnnotations() {
        List l = this.model.getTextualAnnotationsByDate();
        return l != null && l.size() != 0;
    }

    private void initComponents() {
        JButton moreButton = new JButton("more");
        moreButton.setBorder(null);
        UIUtilities.unifiedButtonLookAndFeel(moreButton);
        moreButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        moreButton.setForeground(UIUtilities.HYPERLINK_COLOR);
        moreButton.setToolTipText("Display previous comments.");
        moreButton.addActionListener(this);
        moreButton.setActionCommand("3");
        this.moreComponent = UIUtilities.buildComponentPanel(moreButton, 0, 0);
        this.moreComponent.setBackground(UIUtilities.BACKGROUND_COLOR);
        JButton hideButton = new JButton("hide");
        UIUtilities.unifiedButtonLookAndFeel(hideButton);
        hideButton.setBorder(null);
        hideButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        hideButton.setForeground(UIUtilities.HYPERLINK_COLOR);
        hideButton.setToolTipText("Hide previous comments.");
        hideButton.addActionListener(this);
        hideButton.setActionCommand("2");
        this.hideComponent = UIUtilities.buildComponentPanel(hideButton, 0, 0);
        this.hideComponent.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.inBetweenComponent = new JButton("...");
        UIUtilities.unifiedButtonLookAndFeel(this.inBetweenComponent);
        this.inBetweenComponent.setBorder(null);
        this.inBetweenComponent.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.inBetweenComponent.setForeground(UIUtilities.HYPERLINK_COLOR);
        this.inBetweenComponent.setToolTipText("Display all comments.");
        this.inBetweenComponent.addActionListener(this);
        this.inBetweenComponent.setActionCommand("3");
        this.commentArea = new OMEWikiComponent(false);
        this.commentArea.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.commentArea.addPropertyChangeListener(this.controller);
        this.originalText = DEFAULT_TEXT_COMMENT;
        this.commentArea.setDefaultText(this.originalText);
        this.commentArea.setText(this.originalText);
        this.commentArea.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        this.commentArea.setComponentBorder(EDIT_BORDER);
        this.previousComments = new JScrollPane();
        this.previousComments.setBorder(null);
    }

    private void setAreaText(String text, boolean addDefault) {
        this.commentArea.removeDocumentListener(this);
        this.commentArea.setText(text);
        if (addDefault) {
            this.commentArea.setDefaultText(text);
        }
        this.commentArea.addDocumentListener(this);
    }

    private void buildGUI() {
        this.removeAll();
        this.setBorder(new SeparatorOneLineBorder());
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        JScrollPane pane = new JScrollPane(this.commentArea);
        Dimension d = pane.getPreferredSize();
        pane.getViewport().setPreferredSize(new Dimension(d.width, 60));
        pane.setBorder(null);
        JLabel l = new JLabel();
        Font f = l.getFont();
        l = UIUtilities.setTextFont("comment", 1, f.getSize() - 1);
        l.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 2;
        this.constraints.anchor = 18;
        this.constraints.insets = new Insets(0, 2, 2, 0);
        this.constraints.gridy = 0;
        this.constraints.gridwidth = -1;
        this.constraints.weightx = 1.0;
        this.add((Component)l, this.constraints);
        ++this.constraints.gridy;
        this.add((Component)pane, this.constraints);
    }

    private void hidePreviousComments() {
        List l = this.model.getTextualAnnotationsByDate();
        if (this.partial) {
            if (l != null && l.size() > 2) {
                this.remove(this.hideComponent);
                this.constraints.gridy = 2;
                this.add((Component)this.moreComponent, this.constraints);
            }
            this.constraints.gridy = 3;
            this.previousComments.getViewport().add(this.displayPartialPreviousComments());
            this.add((Component)this.previousComments, this.constraints);
        } else {
            this.remove(this.hideComponent);
            this.constraints.gridy = 2;
            this.add((Component)this.moreComponent, this.constraints);
            this.previousComments.getViewport().removeAll();
        }
        this.revalidate();
        this.repaint();
    }

    private void layoutPreviousComments() {
        List l = this.model.getTextualAnnotationsByDate();
        int n = 3;
        if (!this.partial) {
            n = 1;
        }
        if (l != null && l.size() >= n) {
            this.remove(this.moreComponent);
            this.constraints.gridy = 2;
            this.add((Component)this.hideComponent, this.constraints);
        }
        this.previousComments.getViewport().removeAll();
        this.previousComments.getViewport().add(this.displayAllPreviousComments());
        this.revalidate();
        this.repaint();
    }

    TextualAnnotationsUI(EditorModel model, EditorControl controller) {
        super(model);
        this.controller = controller;
        this.title = TITLE;
        this.initComponents();
        this.init = false;
    }

    @Override
    protected void buildUI() {
        this.buildGUI();
        this.init = true;
        if (!this.hasPreviousTextualAnnotations()) {
            this.originalText = DEFAULT_TEXT_COMMENT;
            this.setAreaText(DEFAULT_TEXT_COMMENT, true);
        }
        this.commentArea.setEnabled(this.model.isWritable());
        if (this.hasPreviousTextualAnnotations()) {
            List list = this.model.getTextualAnnotationsByDate();
            TextualAnnotationData data = (TextualAnnotationData)list.get(0);
            String text = data.getText();
            this.expanded = text.length() < 200;
            this.constraints.gridy = 3;
            this.add((Component)this.previousComments, this.constraints);
            if (this.expanded) {
                this.partial = true;
                this.previousComments.getViewport().add(this.displayPartialPreviousComments());
                if (list.size() > 2) {
                    this.constraints.gridy = 2;
                    this.add((Component)this.moreComponent, this.constraints);
                }
            } else {
                this.partial = false;
                this.constraints.gridy = 2;
                this.add((Component)this.moreComponent, this.constraints);
            }
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    protected String getComponentTitle() {
        return this.title;
    }

    @Override
    protected List<AnnotationData> getAnnotationToRemove() {
        TextualAnnotationData data;
        String text;
        ArrayList<AnnotationData> l = new ArrayList<AnnotationData>();
        if (this.originalText != null && this.originalText.length() > 0 && (text = this.commentArea.getText()) != null && (text = text.trim()).length() == 0 && (data = this.model.getLastUserAnnotation()) != null) {
            l.add((AnnotationData)data);
        }
        return l;
    }

    @Override
    protected List<AnnotationData> getAnnotationToSave() {
        ArrayList<AnnotationData> l = new ArrayList<AnnotationData>();
        String text = this.commentArea.getText();
        if (text == null) {
            return l;
        }
        if ((text = text.trim()).length() == 0) {
            return l;
        }
        if (text.equals(this.originalText) || text.equals(DEFAULT_TEXT_COMMENT)) {
            return l;
        }
        l.add((AnnotationData)new TextualAnnotationData(text));
        return l;
    }

    @Override
    protected boolean hasDataToSave() {
        String text = this.commentArea.getText();
        if (text == null) {
            return false;
        }
        if ((text = text.trim()).length() == 0 && this.originalText != null) {
            return true;
        }
        return !this.originalText.equals(text) && !text.equals(DEFAULT_TEXT_COMMENT);
    }

    @Override
    protected void clearDisplay() {
        if (this.previousComments != null) {
            this.previousComments.getViewport().removeAll();
        }
        this.originalText = DEFAULT_TEXT_COMMENT;
        this.setAreaText(DEFAULT_TEXT_COMMENT, true);
    }

    @Override
    protected void clearData() {
        this.clearDisplay();
    }

    @Override
    protected void setComponentTitle() {
        this.title = TITLE;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 3: {
                this.expanded = true;
                this.layoutPreviousComments();
                break;
            }
            case 2: {
                this.expanded = false;
                this.hidePreviousComments();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.firePropertyChange("save", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.firePropertyChange("save", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object src = e.getSource();
        if (src == this.commentArea) {
            String text = this.commentArea.getText();
            boolean b = false;
            if (text == null || text.length() == 0) {
                text = DEFAULT_TEXT_COMMENT;
                b = true;
            }
            this.originalText = text = text.trim();
            this.setAreaText(DEFAULT_TEXT_COMMENT, b);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

