/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.UserProfileCanvas;
import org.openmicroscopy.shoola.agents.metadata.util.UploadPictureDialog;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ui.PermissionsPane;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ExperimenterData;
import pojos.GroupData;

class UserProfile
extends JPanel
implements ActionListener,
ChangeListener,
DocumentListener,
PropertyChangeListener {
    private static final String PASSWORD_OLD = "Old password";
    private static final String PASSWORD_NEW = "New password";
    private static final String PASSWORD_CONFIRMATION = "Confirm password";
    private static final String PASSWORD_CHANGE_TITLE = "Change Password";
    private Map<String, JTextField> items;
    private JComboBox groups;
    private JLabel groupLabel;
    private JPasswordField passwordNew;
    private JPasswordField passwordConfirm;
    private JPasswordField oldPassword;
    private JButton passwordButton;
    private JCheckBox adminBox;
    private JCheckBox activeBox;
    private JCheckBox ownerBox;
    private EditorModel model;
    private int originalIndex;
    private int selectedIndex;
    private Map details;
    private GroupData[] groupData;
    private boolean groupOwner;
    private boolean admin;
    private boolean active;
    private PermissionsPane permissionsPane;
    private JTextField loginArea;
    private UserProfileCanvas userPicture;

    private void changePassword() {
        if (!this.oldPassword.isVisible()) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.passwordNew.getPassword());
            String newPass = buf.toString();
            if (newPass == null || newPass.length() == 0) {
                UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo(PASSWORD_CHANGE_TITLE, "Please enter the new password.");
                this.passwordNew.requestFocus();
                return;
            }
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo(PASSWORD_CHANGE_TITLE, "Password changed.");
            this.passwordNew.setText("");
            this.model.resetPassword(newPass);
            return;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.passwordNew.getPassword());
        String newPass = buf.toString();
        String pass = buf.toString();
        buf = new StringBuffer();
        buf.append(this.passwordConfirm.getPassword());
        String confirm = buf.toString();
        buf = new StringBuffer();
        buf.append(this.oldPassword.getPassword());
        String old = buf.toString();
        if (old == null || old.trim().length() == 0) {
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo(PASSWORD_CHANGE_TITLE, "Please specify your old password.");
            this.oldPassword.requestFocus();
            return;
        }
        if (newPass == null || newPass.length() == 0) {
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo(PASSWORD_CHANGE_TITLE, "Please enter your new password.");
            this.passwordNew.requestFocus();
            return;
        }
        if (pass == null || confirm == null || confirm.length() == 0 || !pass.equals(confirm)) {
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo(PASSWORD_CHANGE_TITLE, "The passwords entered do not match. Please try again.");
            this.passwordNew.setText("");
            this.passwordConfirm.setText("");
            this.passwordNew.requestFocus();
            return;
        }
        this.model.changePassword(old, confirm);
    }

    private void initComponents() {
        this.admin = false;
        this.active = false;
        this.groupOwner = false;
        this.userPicture = new UserProfileCanvas();
        this.userPicture.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.userPicture.setToolTipText("Click to upload your picture.");
        IconManager icons = IconManager.getInstance();
        this.userPicture.setImage(icons.getImageIcon(101).getImage());
        this.loginArea = new JTextField();
        boolean a = MetadataViewerAgent.isAdministrator();
        this.loginArea.setEnabled(a);
        this.loginArea.setEditable(a);
        this.adminBox = new JCheckBox();
        this.adminBox.setVisible(false);
        this.adminBox.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.ownerBox = new JCheckBox();
        this.ownerBox.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.activeBox = new JCheckBox();
        this.activeBox.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.activeBox.setVisible(false);
        this.passwordButton = new JButton("Change password");
        this.passwordButton.setEnabled(false);
        this.passwordButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.passwordButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserProfile.this.changePassword();
            }
        });
        this.passwordNew = new JPasswordField();
        this.passwordNew.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.passwordConfirm = new JPasswordField();
        this.passwordConfirm.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.oldPassword = new JPasswordField();
        this.oldPassword.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.items = new HashMap<String, JTextField>();
        ExperimenterData user = (ExperimenterData)this.model.getRefObject();
        List userGroups = user.getGroups();
        GroupData defaultGroup = user.getDefaultGroup();
        this.permissionsPane = new PermissionsPane(defaultGroup.getPermissions(), UIUtilities.BACKGROUND_COLOR);
        this.permissionsPane.disablePermissions();
        this.groupLabel = new JLabel(defaultGroup.getName());
        this.groupLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        long groupID = defaultGroup.getId();
        boolean owner = false;
        if (defaultGroup.getLeaders() != null) {
            owner = this.setGroupOwner(defaultGroup);
        } else {
            GroupData g = this.model.loadGroup(groupID);
            if (g != null) {
                owner = this.setGroupOwner(g);
            }
        }
        if (MetadataViewerAgent.isAdministrator()) {
            this.oldPassword.setVisible(false);
            owner = true;
            this.adminBox.setVisible(true);
            this.activeBox.setVisible(true);
            this.adminBox.addChangeListener(this);
            this.active = user.isActive();
            this.activeBox.setSelected(this.active);
            this.activeBox.addChangeListener(this);
            this.admin = false;
        } else {
            this.passwordConfirm.getDocument().addDocumentListener(new DocumentListener(){

                public void removeUpdate(DocumentEvent e) {
                    UserProfile.this.handlePasswordEntered();
                }

                public void insertUpdate(DocumentEvent e) {
                    UserProfile.this.handlePasswordEntered();
                }

                public void changedUpdate(DocumentEvent e) {
                }
            });
        }
        this.passwordNew.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                UserProfile.this.handlePasswordEntered();
            }

            public void insertUpdate(DocumentEvent e) {
                UserProfile.this.handlePasswordEntered();
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.ownerBox.setEnabled(owner);
        this.ownerBox.addChangeListener(this);
        ExperimenterData logUser = MetadataViewerAgent.getUserDetails();
        if (user.getId() == logUser.getId()) {
            this.userPicture.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e) {
                    UserProfile.this.uploadPicture();
                }
            });
        }
    }

    private void handlePasswordEntered() {
        char[] values = this.passwordNew.getPassword();
        if (this.oldPassword.isVisible()) {
            char[] oldValues = this.oldPassword.getPassword();
            char[] confirmValues = this.passwordConfirm.getPassword();
            if (values != null && oldValues != null && confirmValues != null) {
                this.passwordButton.setEnabled(values.length > 0 && oldValues.length > 0 && confirmValues.length == values.length);
            }
        } else {
            this.passwordButton.setEnabled(values != null && values.length > 0);
        }
    }

    private void uploadPicture() {
        UploadPictureDialog d = new UploadPictureDialog(MetadataViewerAgent.getRegistry().getTaskBar().getFrame());
        d.addPropertyChangeListener(this);
        d.pack();
        UIUtilities.centerAndShow(d);
    }

    private boolean setGroupOwner(GroupData group) {
        ExperimenterData ref = (ExperimenterData)this.model.getRefObject();
        long userID = MetadataViewerAgent.getUserDetails().getId();
        Set leaders = group.getLeaders();
        boolean isOwner = false;
        if (leaders != null) {
            for (ExperimenterData exp : leaders) {
                if (exp.getId() == ref.getId()) {
                    this.groupOwner = true;
                    this.ownerBox.setSelected(true);
                }
                if (exp.getId() != userID) continue;
                isOwner = true;
            }
        }
        return isOwner;
    }

    private JPanel buildContentPanel() {
        ExperimenterData user = (ExperimenterData)this.model.getRefObject();
        boolean editable = this.model.isUserOwner(user);
        if (!editable) {
            editable = this.model.isGroupLeader() || MetadataViewerAgent.isAdministrator();
        }
        this.details = EditorUtil.convertExperimenter(user);
        JPanel content = new JPanel();
        content.setBorder(BorderFactory.createTitledBorder("Profile"));
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        Iterator i = this.details.entrySet().iterator();
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.gridwidth = 0;
        c.fill = 2;
        content.add((Component)this.userPicture, c);
        ++c.gridy;
        c.gridx = 0;
        JComponent label = EditorUtil.getLabel("Login Name", true);
        label.setBackground(UIUtilities.BACKGROUND_COLOR);
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)label, c);
        ++c.gridx;
        content.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.loginArea.setText(user.getUserName());
        this.loginArea.getDocument().addDocumentListener(this);
        content.add((Component)this.loginArea, c);
        while (i.hasNext()) {
            ++c.gridy;
            c.gridx = 0;
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            label = EditorUtil.getLabel(key, false);
            JTextField area = new JTextField(value);
            area.setBackground(UIUtilities.BACKGROUND_COLOR);
            area.setEditable(editable);
            area.setEnabled(editable);
            if (editable) {
                area.getDocument().addDocumentListener(this);
            }
            this.items.put(key, area);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            content.add((Component)label, c);
            ++c.gridx;
            content.add(Box.createHorizontalStrut(5), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)area, c);
        }
        c.gridx = 0;
        ++c.gridy;
        label = EditorUtil.getLabel("Current Group", false);
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)label, c);
        ++c.gridx;
        content.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)this.groupLabel, c);
        ++c.gridy;
        content.add((Component)this.permissionsPane, c);
        c.gridx = 0;
        ++c.gridy;
        label = EditorUtil.getLabel("Group's owner", false);
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)label, c);
        ++c.gridx;
        content.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)this.ownerBox, c);
        if (this.activeBox.isVisible()) {
            c.gridx = 0;
            ++c.gridy;
            label = EditorUtil.getLabel("Active", false);
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            content.add((Component)label, c);
            ++c.gridx;
            content.add(Box.createHorizontalStrut(5), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)this.activeBox, c);
        }
        if (this.adminBox.isVisible()) {
            c.gridx = 0;
            ++c.gridy;
            label = EditorUtil.getLabel("Administrator", false);
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            content.add((Component)label, c);
            ++c.gridx;
            content.add(Box.createHorizontalStrut(5), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)this.adminBox, c);
        }
        c.gridx = 0;
        ++c.gridy;
        content.add(Box.createHorizontalStrut(10), c);
        ++c.gridy;
        label = UIUtilities.setTextFont("* indicates the required fields.", 2);
        label.setForeground(UIUtilities.REQUIRED_FIELDS_COLOR);
        c.weightx = 0.0;
        content.add((Component)label, c);
        return content;
    }

    private JPanel buildPasswordPanel() {
        JPanel content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        Registry reg = MetadataViewerAgent.getRegistry();
        String ldap = (String)reg.lookup("/user/authentication");
        if (ldap != null && ldap.length() > 0) {
            content.setBorder(BorderFactory.createTitledBorder("LDAP Authentication"));
            content.setLayout(new FlowLayout(0));
            content.add(new JLabel(ldap));
            return content;
        }
        content.setBorder(BorderFactory.createTitledBorder(PASSWORD_CHANGE_TITLE));
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        if (MetadataViewerAgent.isAdministrator()) {
            content.add((Component)UIUtilities.setTextFont(PASSWORD_NEW), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)this.passwordNew, c);
        } else {
            content.add((Component)UIUtilities.setTextFont(PASSWORD_OLD), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)this.oldPassword, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            content.add((Component)UIUtilities.setTextFont(PASSWORD_NEW), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)this.passwordNew, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            content.add((Component)UIUtilities.setTextFont(PASSWORD_CONFIRMATION), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)this.passwordConfirm, c);
            ++c.gridy;
            c.gridx = 0;
        }
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new BoxLayout(p, 1));
        p.add(content);
        JPanel buttonPanel = UIUtilities.buildComponentPanel(this.passwordButton);
        buttonPanel.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(buttonPanel);
        return p;
    }

    private void showRequiredField() {
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        un.notifyInfo("Edit Profile", "The required fields cannot be left blank.");
    }

    UserProfile(EditorModel model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
    }

    void buildGUI() {
        this.removeAll();
        this.initComponents();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = -1;
        c.weightx = 1.0;
        this.add((Component)this.buildContentPanel(), c);
        if (this.model.isUserOwner(this.model.getRefObject()) || MetadataViewerAgent.isAdministrator()) {
            ++c.gridy;
            this.add(Box.createVerticalStrut(5), c);
            ++c.gridy;
            this.add((Component)this.buildPasswordPanel(), c);
        }
    }

    void passwordChanged() {
        this.oldPassword.setText("");
        this.passwordNew.setText("");
        this.passwordConfirm.setText("");
    }

    boolean hasDataToSave() {
        Boolean b;
        ExperimenterData original;
        String text = this.loginArea.getText();
        if (text == null || text.trim().length() == 0) {
            return false;
        }
        if (!(text = text.trim()).equals((original = (ExperimenterData)this.model.getRefObject()).getUserName())) {
            return true;
        }
        if (this.details == null) {
            return false;
        }
        Iterator i = this.details.entrySet().iterator();
        if (this.items.size() > 0) {
            while (i.hasNext()) {
                String v;
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                JTextField field = this.items.get(key);
                if (field == null || (v = field.getText()) == null) continue;
                v = v.trim();
                String value = (String)entry.getValue();
                if (value == null || v.equals(value)) continue;
                return true;
            }
        }
        if ((b = Boolean.valueOf(this.ownerBox.isSelected())).compareTo(this.groupOwner) != 0) {
            return true;
        }
        if (this.adminBox.isVisible() && (b = Boolean.valueOf(this.adminBox.isSelected())).compareTo(this.admin) != 0) {
            return true;
        }
        return this.activeBox.isVisible() && (b = Boolean.valueOf(this.activeBox.isSelected())).compareTo(this.active) != 0;
    }

    Object getExperimenterToSave() {
        ExperimenterData original = (ExperimenterData)this.model.getRefObject();
        JTextField f = this.items.get("Last Name");
        String v = f.getText();
        if (v == null || v.trim().length() == 0) {
            this.showRequiredField();
        }
        original.setLastName(v);
        f = this.items.get("E-mail");
        v = f.getText();
        if (v == null || v.trim().length() == 0) {
            v = "";
        }
        original.setEmail(v);
        f = this.items.get("Institution");
        v = f.getText();
        if (v == null) {
            v = "";
        }
        original.setInstitution(v.trim());
        f = this.items.get("First Name");
        v = f.getText();
        if (v == null) {
            v = "";
        }
        original.setFirstName(v.trim());
        f = this.items.get("First Name");
        v = f.getText();
        if (v == null) {
            v = "";
        }
        original.setFirstName(v.trim());
        f = this.items.get("Middle Name");
        v = f.getText();
        if (v == null) {
            v = "";
        }
        original.setMiddleName(v.trim());
        GroupData g = null;
        String value = this.loginArea.getText().trim();
        UserCredentials uc = new UserCredentials(value, "");
        Boolean b = this.ownerBox.isSelected();
        if (g == null) {
            g = original.getDefaultGroup();
        }
        boolean a = false;
        if (b.compareTo(this.groupOwner) != 0) {
            a = true;
            uc.setOwner(b);
        }
        if (this.adminBox.isVisible() && (b = Boolean.valueOf(this.adminBox.isSelected())).compareTo(this.admin) != 0) {
            a = true;
            uc.setAdministrator(b);
        }
        if (this.activeBox.isVisible() && (b = Boolean.valueOf(this.activeBox.isSelected())).compareTo(this.active) != 0) {
            a = true;
            uc.setActive(b);
        }
        if (!original.getUserName().equals(value)) {
            a = true;
        }
        if (MetadataViewerAgent.isAdministrator()) {
            a = true;
        }
        if (a) {
            HashMap<ExperimenterData, UserCredentials> m = new HashMap<ExperimenterData, UserCredentials>();
            m.put(original, uc);
            AdminObject object = new AdminObject(g, m, 3);
            return object;
        }
        return original;
    }

    void setUserPhoto(BufferedImage image) {
        if (image == null) {
            return;
        }
        BufferedImage img = Factory.scaleBufferedImage(image, 32);
        this.userPicture.setImage(img);
    }

    public void actionPerformed(ActionEvent e) {
        this.selectedIndex = this.groups.getSelectedIndex();
        this.buildGUI();
        this.firePropertyChange("save", (Object)false, (Object)true);
    }

    public void insertUpdate(DocumentEvent e) {
        this.firePropertyChange("save", (Object)false, (Object)true);
    }

    public void removeUpdate(DocumentEvent e) {
        this.firePropertyChange("save", (Object)false, (Object)true);
    }

    public void stateChanged(ChangeEvent e) {
        this.firePropertyChange("save", (Object)false, (Object)true);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("uploadPhoto".equals(name)) {
            List l = (List)evt.getNewValue();
            if (l == null || l.size() != 2) {
                return;
            }
            File f = (File)l.get(0);
            if (f == null) {
                return;
            }
            this.model.uploadPicture(f, (String)l.get(1));
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }
}

