/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.awt.FlowLayout;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.openmicroscopy.shoola.agents.metadata.actions.ManageRndSettingsAction;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class PreviewControlBar
extends JPanel {
    static final int SPACE = 3;
    private static final String PREVIEW = "Live Update";
    private static final String PREVIEW_DESCRIPTION = "Update the rendering settings immediately. Not available for large images";
    private RendererControl control;
    private RendererModel model;
    private JToggleButton preview;

    private void initComponents() {
        this.preview = new JCheckBox(PREVIEW);
        this.preview.setEnabled(!this.model.isBigImage());
        this.preview.setToolTipText(PREVIEW_DESCRIPTION);
        this.formatButton(this.preview);
    }

    private void formatButton(AbstractButton b) {
        b.setVerticalTextPosition(3);
        b.setHorizontalTextPosition(0);
        b.setIconTextGap(0);
        UIUtilities.unifiedButtonLookAndFeel(b);
        b.setBackground(UIUtilities.BACKGROUND_COLOR);
    }

    private JToolBar buildToolBar() {
        JToolBar bar = new JToolBar();
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.setBorder(null);
        bar.setRollover(true);
        bar.setFloatable(false);
        JButton b = new JButton(this.control.getAction(RendererControl.RND_MIN_MAX));
        this.preview.setFont(b.getFont());
        this.formatButton(b);
        bar.add(b);
        b = new JButton(this.control.getAction(RendererControl.RND_ABSOLUTE_MIN_MAX));
        this.preview.setFont(b.getFont());
        this.formatButton(b);
        bar.add(b);
        bar.add(Box.createHorizontalStrut(3));
        b = new JButton(this.control.getAction(RendererControl.RND_RESET));
        this.formatButton(b);
        bar.add(b);
        bar.add(Box.createHorizontalStrut(3));
        b = new JButton(this.control.getAction(RendererControl.RND_UNDO));
        this.formatButton(b);
        bar.add(b);
        bar.add(Box.createHorizontalStrut(3));
        ManageRndSettingsAction a = (ManageRndSettingsAction)this.control.getAction(RendererControl.RND_OWNER);
        b = new JButton(a);
        this.formatButton(b);
        b.addMouseListener(a);
        bar.add(b);
        if (this.model.isGeneralIndex()) {
            bar.add(Box.createHorizontalStrut(3));
            b = new JButton(this.control.getAction(RendererControl.APPLY_TO_ALL));
            this.formatButton(b);
            bar.add(b);
        }
        return bar;
    }

    private void buildGUI() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.add(this.preview);
        this.add(new JSeparator(1));
        this.add(this.buildToolBar());
    }

    PreviewControlBar(RendererControl control, RendererModel model) {
        this.control = control;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    boolean isLiveUpdate() {
        return this.preview.isSelected();
    }
}

