/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.actions.ColorModelAction;
import org.openmicroscopy.shoola.agents.metadata.actions.ContrastStretchingAction;
import org.openmicroscopy.shoola.agents.metadata.actions.HistogramAction;
import org.openmicroscopy.shoola.agents.metadata.actions.ManageRndSettingsAction;
import org.openmicroscopy.shoola.agents.metadata.actions.NoiseReductionAction;
import org.openmicroscopy.shoola.agents.metadata.actions.PlaneSlicingAction;
import org.openmicroscopy.shoola.agents.metadata.actions.ReverseIntensityAction;
import org.openmicroscopy.shoola.agents.metadata.actions.RndAction;
import org.openmicroscopy.shoola.agents.metadata.actions.ViewAction;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererUI;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPicker;

class RendererControl
implements PropertyChangeListener {
    static final Integer BIT_RESOLUTION = 0;
    static final Integer FAMILY = 1;
    static final Integer COEFFICIENT = 2;
    static final Integer NOISE_REDUCTION = 3;
    static final Integer REVERSE_INTENSITY = 4;
    static final Integer PLANE_SLICING = 5;
    static final Integer CONTRAST_STRETCHING = 6;
    static final Integer HISTOGRAM = 7;
    static final Integer COLOR_MODEL = 8;
    static final Integer RND_MIN_MAX = 9;
    static final Integer RND_RESET = 10;
    static final Integer RND_UNDO = 11;
    static final Integer RND_OWNER = 12;
    static final Integer VIEW = 13;
    static final Integer APPLY_TO_ALL = 14;
    static final Integer RND_ABSOLUTE_MIN_MAX = 15;
    private Renderer model;
    private RendererUI view;
    private Map<Integer, RndAction> actionsMap = new HashMap<Integer, RndAction>();
    private int colorPickerIndex;

    private void createActions() {
        this.actionsMap.put(REVERSE_INTENSITY, new ReverseIntensityAction(this.model));
        this.actionsMap.put(PLANE_SLICING, new PlaneSlicingAction(this.model));
        this.actionsMap.put(CONTRAST_STRETCHING, new ContrastStretchingAction(this.model));
        this.actionsMap.put(NOISE_REDUCTION, new NoiseReductionAction(this.model));
        this.actionsMap.put(HISTOGRAM, new HistogramAction(this.model));
        this.actionsMap.put(COLOR_MODEL, new ColorModelAction(this.model));
        this.actionsMap.put(VIEW, new ViewAction(this.model));
        this.actionsMap.put(RND_MIN_MAX, new ManageRndSettingsAction(this.model, 0));
        this.actionsMap.put(RND_UNDO, new ManageRndSettingsAction(this.model, 2));
        this.actionsMap.put(RND_RESET, new ManageRndSettingsAction(this.model, 1));
        this.actionsMap.put(RND_OWNER, new ManageRndSettingsAction(this.model, 4));
        this.actionsMap.put(APPLY_TO_ALL, new ManageRndSettingsAction(this.model, 3));
        this.actionsMap.put(RND_ABSOLUTE_MIN_MAX, new ManageRndSettingsAction(this.model, 5));
    }

    private void attachListeners() {
        this.model.addPropertyChangeListener(this);
    }

    private void showColorPicker(int channel) {
        this.colorPickerIndex = channel;
        Color c = this.view.getChannelColor(channel);
        JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        ColourPicker dialog = new ColourPicker(f, c);
        dialog.addPropertyChangeListener(this);
        UIUtilities.centerAndShow(dialog);
    }

    RendererControl() {
    }

    void initialize(Renderer model, RendererUI view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.model = model;
        this.view = view;
        this.createActions();
        this.attachListeners();
    }

    Action getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    void addPropertyListener(PropertyChangeListener observer) {
        this.model.addPropertyChangeListener(observer);
    }

    void setInputInterval(double s, double e) {
        this.model.setInputInterval(s, e);
    }

    void setInputInterval(double s, double e, int channel) {
        this.model.setChannelWindow(channel, s, e);
    }

    void setCodomainInterval(int s, int e) {
        this.model.setCodomainInterval(s, e);
    }

    void setSelectedXYPlane(int z, int t) {
        this.setSelectedXYPlane(z, t, -1);
    }

    void setSelectedXYPlane(int z, int t, int bin) {
        this.model.setSelectedXYPlane(z, t, bin);
    }

    void setChannelSelection(int index, boolean active) {
        this.model.setChannelSelection(index, active);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Object newValue;
        Object oldValue;
        String name = evt.getPropertyName();
        if ("family".equals(name)) {
            oldValue = (String)evt.getOldValue();
            newValue = (String)evt.getNewValue();
            if (((String)newValue).equals(oldValue)) {
                return;
            }
            this.model.setFamily((String)newValue);
            this.view.onCurveChange();
        } else if ("gamma".equals(name)) {
            oldValue = (Double)evt.getOldValue();
            newValue = (Double)evt.getNewValue();
            if (((Double)newValue).equals(oldValue)) {
                return;
            }
            this.model.setCurveCoefficient((Double)newValue);
            this.view.onCurveChange();
        } else if ("bit_resolution".equals(name)) {
            oldValue = (Integer)evt.getOldValue();
            newValue = (Integer)evt.getNewValue();
            if (((Integer)newValue).equals(oldValue)) {
                return;
            }
            this.model.setBitResolution((Integer)newValue);
        }
        if ("channelSelected".equals(name)) {
            Map map = (Map)evt.getNewValue();
            if (map == null) {
                return;
            }
            if (map.size() != 1) {
                return;
            }
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                Integer index = (Integer)entry.getKey();
                this.setChannelSelection(index, (Boolean)entry.getValue());
            }
        } else if ("channelColour".equals(name)) {
            this.showColorPicker((Integer)evt.getNewValue());
        } else if ("inputInterval".equals(name)) {
            this.view.setInputInterval();
        } else if ("rangeInput".equals(name)) {
            Boolean b = (Boolean)evt.getNewValue();
            this.view.setInputRange(b);
        } else if ("colour".equals(name)) {
            Color c = (Color)evt.getNewValue();
            if (this.colorPickerIndex != -1) {
                this.model.setChannelColor(this.colorPickerIndex, c);
            }
        } else if ("zSelected".equals(name)) {
            this.view.setZSection((Integer)evt.getNewValue());
        } else if ("tSelected".equals(name)) {
            this.view.setTimepoint((Integer)evt.getNewValue());
        }
    }
}

