/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.metadata.rnd.CodomainPane;
import org.openmicroscopy.shoola.agents.metadata.rnd.ControlPane;
import org.openmicroscopy.shoola.agents.metadata.rnd.DomainPane;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class RendererUI
extends JPanel {
    static final Integer DOMAIN = 0;
    static final Integer CODOMAIN = 1;
    private RendererControl controller;
    private RendererModel model;
    private Map<Integer, ControlPane> controlPanes = new HashMap<Integer, ControlPane>(2);

    private void createControlPanes() {
        ControlPane p = new DomainPane(this.model, this.controller);
        p.addPropertyChangeListener(this.controller);
        this.controlPanes.put(DOMAIN, p);
        p = new CodomainPane(this.model, this.controller);
        p.addPropertyChangeListener(this.controller);
        this.controlPanes.put(CODOMAIN, p);
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        this.setLayout(new BorderLayout());
        this.add((Component)pane, "North");
    }

    RendererUI() {
    }

    void initialize(RendererControl controller, RendererModel model) {
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.createControlPanes();
        this.buildGUI();
    }

    void addCodomainMap(Class mapType) {
        CodomainPane pane = (CodomainPane)this.controlPanes.get(CODOMAIN);
        pane.addCodomainMap(mapType);
    }

    void removeCodomainMap(Class mapType) {
        CodomainPane pane = (CodomainPane)this.controlPanes.get(CODOMAIN);
        pane.removeCodomainMap(mapType);
    }

    void setSelectedChannel() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setSelectedChannel();
    }

    void setChannelColor(int index) {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setChannelColor(index);
    }

    void setInputInterval() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setInputInterval();
    }

    void resetDefaultRndSettings() {
        for (Map.Entry<Integer, ControlPane> entry : this.controlPanes.entrySet()) {
            ControlPane pane = entry.getValue();
            pane.resetDefaultRndSettings();
        }
    }

    void setColorModelChanged() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setColorModelChanged();
    }

    void onCurveChange() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.onCurveChange();
    }

    void onStateChange(boolean b) {
        if (this.controlPanes != null && this.controlPanes.size() > 0) {
            for (Map.Entry<Integer, ControlPane> entry : this.controlPanes.entrySet()) {
                ControlPane pane = entry.getValue();
                pane.onStateChange(b);
            }
        }
    }

    Color getChannelColor(int channel) {
        return this.model.getChannelColor(channel);
    }

    void setZSection(int z) {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setZSection(z);
    }

    void setTimepoint(int t) {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setTimepoint(t);
    }

    boolean isSourceDisplayed(Object source) {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        return pane.isSourceDisplayed(source);
    }

    void renderPreview() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.renderPreview();
    }

    void displayViewedBy(List results) {
        if (results == null || results.size() == 0) {
            return;
        }
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.displayViewedBy(results);
    }

    void setInputRange(boolean absolute) {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setInputRange(absolute);
    }
}

