/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import org.openmicroscopy.shoola.agents.treeviewer.util.FileImportComponent;
import org.openmicroscopy.shoola.env.data.model.ImportObject;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportManager
extends JPanel
implements ActionListener,
PropertyChangeListener {
    public static final String VIEW_IMAGE_PROPERTY = "viewImage";
    public static final String SEND_FILES_PROPERTY = "sendFiles";
    public static final String CANCEL_IMPORT_PROPERTY = "cancelImport";
    private static final String TITLE = "Import";
    private static final double[] COLUMNS = new double[]{-1.0};
    private static final int CLEAR = 0;
    private static final int SEND = 1;
    private static final int CANCEL = 2;
    private LinkedHashMap<String, FileImportComponent> components;
    private Map<String, FileImportComponent> imported;
    private List<File> toImport;
    private JPanel entries;
    private JButton clearButton;
    private JButton sendButton;
    private JButton cancelButton;
    private int total;

    private void initComponents() {
        this.toImport = new ArrayList<File>();
        this.imported = new LinkedHashMap<String, FileImportComponent>();
        this.components = new LinkedHashMap();
        this.entries = new JPanel();
        this.entries.setBackground(UIUtilities.BACKGROUND);
        this.clearButton = new JButton("Clear");
        this.clearButton.setToolTipText("Removes the imported files from the list.");
        this.clearButton.setActionCommand("0");
        this.clearButton.addActionListener(this);
        this.sendButton = new JButton("Send");
        this.sendButton.setToolTipText("Sends the files that failed to import.");
        this.sendButton.setActionCommand("1");
        this.sendButton.addActionListener(this);
        this.sendButton.setEnabled(false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Cancel on-going imports.");
        this.cancelButton.setActionCommand("2");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setEnabled(false);
    }

    private void buildGUI() {
        JScrollPane pane = new JScrollPane(this.entries);
        pane.setOpaque(false);
        pane.setBorder(new LineBorder(Color.LIGHT_GRAY));
        TitlePanel tp = new TitlePanel(TITLE, "Imported files and on-going import.", null);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)((Object)tp), "North");
        this.add((Component)pane, "Center");
        this.add((Component)this.buildStatusBar(), "South");
    }

    private JPanel buildStatusBar() {
        JPanel p = new JPanel();
        p.add(this.cancelButton);
        p.add(Box.createHorizontalStrut(5));
        p.add(this.clearButton);
        p.add(Box.createHorizontalStrut(5));
        p.add(this.sendButton);
        JPanel bar = UIUtilities.buildComponentPanelRight(p);
        bar.setBorder(new LineBorder(Color.LIGHT_GRAY));
        return bar;
    }

    private void addRow(TableLayout layout, int index, FileImportComponent c) {
        layout.insertRow(index, -2.0);
        if (index % 2 == 0) {
            c.setBackground(UIUtilities.BACKGROUND_COLOUR_EVEN);
        } else {
            c.setBackground(UIUtilities.BACKGROUND_COLOUR_ODD);
        }
        this.entries.add((Component)c, "0, " + index + "");
    }

    private void layoutEntries() {
        FileImportComponent c;
        this.entries.removeAll();
        TableLayout layout = new TableLayout();
        layout.setColumn(COLUMNS);
        this.entries.setLayout((LayoutManager)layout);
        int index = 0;
        for (Map.Entry<String, FileImportComponent> entry : this.imported.entrySet()) {
            c = entry.getValue();
            if (c == null) continue;
            this.addRow(layout, index, c);
            ++index;
        }
        Iterator<Map.Entry<String, FileImportComponent>> i = this.components.entrySet().iterator();
        int first = 0;
        while (i.hasNext()) {
            Map.Entry<String, FileImportComponent> entry;
            entry = i.next();
            c = entry.getValue();
            if (first == 0) {
                c.setStatus(true, null);
            }
            this.addRow(layout, index, c);
            ++index;
            ++first;
        }
        this.entries.revalidate();
        this.repaint();
    }

    private void clearList() {
        if (this.imported == null) {
            return;
        }
        this.imported.clear();
        this.layoutEntries();
        this.sendButton.setEnabled(false);
    }

    private void send() {
        if (this.imported == null) {
            return;
        }
        HashMap<File, Exception> files = new HashMap<File, Exception>();
        Iterator<Map.Entry<String, FileImportComponent>> i = this.imported.entrySet().iterator();
        ArrayList names = new ArrayList();
        while (i.hasNext()) {
            File f;
            Map.Entry<String, FileImportComponent> entry = i.next();
            FileImportComponent c = entry.getValue();
            if (c == null || !c.isSelected() || names.contains((f = c.getOriginalFile()).getAbsolutePath())) continue;
            files.put(f, c.getImportException());
        }
        if (files.size() == 0) {
            return;
        }
        this.firePropertyChange(SEND_FILES_PROPERTY, null, files);
    }

    private void cancel() {
        for (Map.Entry<String, FileImportComponent> entry : this.components.entrySet()) {
            FileImportComponent c = entry.getValue();
            c.setStatus(false, "Cancelled");
        }
        this.total = 0;
        this.firePropertyChange(CANCEL_IMPORT_PROPERTY, (Object)false, (Object)true);
    }

    public ImportManager() {
        this.initComponents();
        this.buildGUI();
    }

    public List<ImportObject> initialize(Map<File, String> files, int depth) {
        ArrayList<ImportObject> list = new ArrayList<ImportObject>();
        if (files == null) {
            return null;
        }
        this.total = 0;
        this.toImport.clear();
        this.components.clear();
        for (Map.Entry<File, String> entry : files.entrySet()) {
            File f = entry.getKey();
            this.toImport.add(f);
            FileImportComponent c = new FileImportComponent(this, f);
            ImportObject obj = new ImportObject(f, c.getStatus(), entry.getValue());
            if (f.isDirectory()) {
                obj.setDepth(depth);
            }
            list.add(obj);
            c.addPropertyChangeListener("sendFile", this);
            this.components.put(f.getAbsolutePath(), c);
        }
        this.total = this.toImport.size();
        this.cancelButton.setEnabled(this.hasFilesToImport());
        this.layoutEntries();
        return list;
    }

    public void viewImage(ImageData image) {
        this.firePropertyChange(VIEW_IMAGE_PROPERTY, null, image);
    }

    public void setStatus(File f, Object image) {
        if (f == null) {
            return;
        }
        String path = f.getAbsolutePath();
        FileImportComponent c = this.components.get(path);
        if (c != null) {
            File ff2;
            Map m;
            this.imported.put(path, c);
            c.setStatus(false, image);
            this.components.remove(path);
            --this.total;
            if (image instanceof Map && (m = (Map)image) != null && m.size() > 0) {
                for (Map.Entry entry : m.entrySet()) {
                    c = new FileImportComponent(this, (File)entry.getKey());
                    c.setStatus(false, entry.getValue());
                    c.addPropertyChangeListener("sendFile", this);
                    this.components.put(f.getAbsolutePath(), c);
                }
                this.layoutEntries();
            }
            int index = 0;
            for (File ff2 : this.toImport) {
                if (ff2.getAbsolutePath().equals(path)) break;
                ++index;
            }
            int n = this.toImport.size();
            if (++index < n && (c = this.components.get((ff2 = this.toImport.get(index)).getAbsolutePath())) != null) {
                c.setStatus(true, null);
            }
        }
        this.cancelButton.setEnabled(this.hasFilesToImport());
    }

    public boolean hasFilesToImport() {
        return this.total != 0;
    }

    public JComponent getUIDelegate() {
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.clearList();
                break;
            }
            case 1: {
                this.send();
                break;
            }
            case 2: {
                this.cancel();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("sendFile".equals(name)) {
            boolean selected = false;
            for (Map.Entry<String, FileImportComponent> entry : this.imported.entrySet()) {
                FileImportComponent c = entry.getValue();
                if (c == null || !c.isSelected()) continue;
                selected = true;
                break;
            }
            this.sendButton.setEnabled(selected);
        }
    }
}

