/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.events.importer.LoadImporter;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class BrowserImportAction
extends BrowserAction {
    private static final String DESCRIPTION = "Import the selected images.";

    protected void onStateChange() {
        switch (this.model.getState()) {
            case 11: 
            case 12: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(this.model.getLastSelectedDisplay());
            }
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(false);
    }

    public BrowserImportAction(Browser model) {
        super(model);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(90));
    }

    public void actionPerformed(ActionEvent e) {
        int type = -1;
        switch (this.model.getBrowserType()) {
            case 100: {
                type = 0;
                break;
            }
            case 103: {
                type = 1;
            }
        }
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        bus.post(new LoadImporter(type));
    }
}

