/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.browser;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import org.openmicroscopy.shoola.agents.events.editor.EditFileEvent;
import org.openmicroscopy.shoola.agents.treeviewer.AdminLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ContainerCounterLoader;
import org.openmicroscopy.shoola.agents.treeviewer.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ExperimenterDataLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ExperimenterImageLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ExperimenterImagesCounter;
import org.openmicroscopy.shoola.agents.treeviewer.FilesChecker;
import org.openmicroscopy.shoola.agents.treeviewer.RefreshExperimenterDataLoader;
import org.openmicroscopy.shoola.agents.treeviewer.RefreshExperimenterDef;
import org.openmicroscopy.shoola.agents.treeviewer.ScreenPlateLoader;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.ContainersManager;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.DeleteCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageNode;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.env.data.FSAccessException;
import org.openmicroscopy.shoola.env.data.FSFileSystemView;
import org.openmicroscopy.shoola.env.log.LogMessage;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.FileData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.PlateAcquisitionData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BrowserModel {
    private int browserType;
    private List<TreeImageDisplay> selectedNodes;
    private int state = 10;
    private Point clickPoint;
    private DataBrowserLoader currentLoader;
    private DataBrowserLoader numberLoader;
    private List foundNodes;
    private int foundNodeIndex;
    private ContainersManager containersManager;
    private ContainersManager containersManagerWithIndexes;
    private boolean selected;
    private boolean displayed;
    private Map<String, Object> importedImages;
    private Map<Long, FSFileSystemView> views;
    private TreeViewer parent;
    protected Browser component;

    private void checkBrowserType(int type) {
        switch (type) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Browser type not valid.");
            }
        }
    }

    protected BrowserModel(int browserType, TreeViewer parent) {
        this.parent = parent;
        this.checkBrowserType(browserType);
        this.browserType = browserType;
        this.clickPoint = null;
        this.foundNodeIndex = -1;
        this.selectedNodes = new ArrayList<TreeImageDisplay>();
        this.displayed = true;
    }

    void initialize(Browser component) {
        this.component = component;
    }

    int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    long getRootID() {
        return this.parent.getUserDetails().getId();
    }

    long getGroupID() {
        return this.parent.getUserGroupID();
    }

    TreeImageDisplay getLastSelectedDisplay() {
        int n = this.selectedNodes.size();
        if (n == 0) {
            return null;
        }
        Iterator<TreeImageDisplay> i = this.selectedNodes.iterator();
        int index = 0;
        while (i.hasNext()) {
            if (index == n - 1) {
                return i.next();
            }
            ++index;
        }
        return null;
    }

    TreeImageDisplay[] getSelectedDisplays() {
        if (this.selectedNodes.size() == 0) {
            return new TreeImageDisplay[0];
        }
        TreeImageDisplay[] nodes = new TreeImageDisplay[this.selectedNodes.size()];
        Iterator<TreeImageDisplay> i = this.selectedNodes.iterator();
        int index = 0;
        while (i.hasNext()) {
            nodes[index] = i.next();
            ++index;
        }
        return nodes;
    }

    void setSelectedDisplay(TreeImageDisplay display, boolean single) {
        if (single) {
            this.selectedNodes.clear();
            if (display != null) {
                this.selectedNodes.add(display);
            }
        } else if (!this.selectedNodes.contains(display) && display != null) {
            this.selectedNodes.add(display);
        }
    }

    void addFoundNode(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            return;
        }
        TreeImageDisplay display = this.getLastSelectedDisplay();
        if (display != null && !display.getUserObject().getClass().equals(selectedDisplay.getUserObject().getClass())) {
            this.selectedNodes.clear();
        }
        this.selectedNodes.add(selectedDisplay);
    }

    Point getClickPoint() {
        return this.clickPoint;
    }

    void setClickPoint(Point p) {
        this.clickPoint = p;
    }

    int getBrowserType() {
        return this.browserType;
    }

    void fireLeavesLoading(TreeImageDisplay expNode, TreeImageDisplay node) {
        this.state = 12;
        if (node instanceof TreeImageTimeSet || node instanceof TreeFileSet) {
            this.currentLoader = new ExperimenterImageLoader(this.component, (TreeImageSet)expNode, (TreeImageSet)node);
            this.currentLoader.load();
        } else {
            FileData fa;
            Object ho = node.getUserObject();
            if (ho instanceof DatasetData) {
                this.currentLoader = new ExperimenterDataLoader(this.component, 1, (TreeImageSet)expNode, (TreeImageSet)node);
                this.currentLoader.load();
            } else if (ho instanceof TagAnnotationData) {
                this.currentLoader = new ExperimenterDataLoader(this.component, 3, (TreeImageSet)expNode, (TreeImageSet)node);
                this.currentLoader.load();
            } else if (ho instanceof GroupData) {
                this.currentLoader = new AdminLoader(this.component, (TreeImageSet)expNode);
                this.currentLoader.load();
            } else if (!(ho instanceof FileData && (fa = (FileData)ho).isDirectory() && fa.isHidden())) {
                // empty if block
            }
        }
    }

    void fireContainerCountLoading(Set containers, Set<TreeImageSet> nodes) {
        if (containers == null || containers.size() == 0) {
            this.state = 15;
            return;
        }
        this.numberLoader = new ContainerCounterLoader(this.component, containers, nodes);
        this.numberLoader.load();
    }

    void discard() {
        this.cancel();
        if (this.numberLoader != null) {
            this.numberLoader.cancel();
            this.numberLoader = null;
        }
        this.state = 16;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
            this.currentLoader = null;
        }
        this.state = 15;
    }

    boolean setContainerCountValue(JTree tree, long containerID, long value, Set<TreeImageSet> nodes) {
        if (this.containersManager == null) {
            this.containersManager = new ContainersManager(tree, nodes);
        }
        this.containersManager.setNumberItems(containerID, value);
        if (this.containersManager.isDone()) {
            this.containersManager = null;
            this.numberLoader = null;
            return true;
        }
        return false;
    }

    void setSelected(boolean selected) {
        this.selected = selected;
    }

    boolean isSelected() {
        return this.selected;
    }

    void setFoundNodes(List nodes) {
        this.foundNodes = nodes;
    }

    void setFoundNodeIndex(int i) {
        this.foundNodeIndex = i;
    }

    int getFoundNodeIndex() {
        return this.foundNodeIndex;
    }

    List getFoundNodes() {
        return this.foundNodes;
    }

    long getUserID() {
        return this.parent.getUserDetails().getId();
    }

    long getUserGroupID() {
        return this.parent.getUserGroupID();
    }

    ExperimenterData getUserDetails() {
        return (ExperimenterData)TreeViewerAgent.getRegistry().lookup("/current_user/details");
    }

    TreeViewer getParentModel() {
        return this.parent;
    }

    boolean isDisplayed() {
        return this.displayed;
    }

    void setDisplayed(boolean displayed) {
        this.displayed = displayed;
    }

    String getExperimenterNames() {
        return this.parent.getExperimenterNames();
    }

    void fireExperimenterDataLoading(TreeImageSet expNode) {
        int index = -1;
        if (this.browserType == 107) {
            this.state = 11;
            if (TreeViewerAgent.isAdministrator()) {
                this.currentLoader = new AdminLoader(this.component, null);
                this.currentLoader.load();
                return;
            }
            this.component.setGroups(TreeViewerAgent.getGroupsLeaderOf(), null);
            return;
        }
        if (this.browserType == 103) {
            this.currentLoader = new ScreenPlateLoader(this.component, expNode, 0);
            this.currentLoader.load();
            this.state = 11;
            return;
        }
        switch (this.browserType) {
            case 100: {
                index = 0;
                break;
            }
            case 101: {
                index = 2;
                break;
            }
            case 102: {
                index = 4;
                break;
            }
            case 105: {
                index = 7;
                break;
            }
        }
        if (index == -1) {
            return;
        }
        this.currentLoader = new ExperimenterDataLoader(this.component, index, expNode);
        this.currentLoader.load();
        this.state = 11;
    }

    void loadRefreshExperimenterData(Map<Long, RefreshExperimenterDef> nodes, Class type, long id) {
        Class<ProjectData> klass = null;
        switch (this.browserType) {
            case 100: {
                klass = ProjectData.class;
                break;
            }
            case 101: {
                klass = ImageData.class;
                break;
            }
            case 102: {
                klass = TagAnnotationData.class;
                break;
            }
            case 103: {
                klass = ScreenData.class;
                break;
            }
            case 104: {
                klass = FileAnnotationData.class;
                break;
            }
            case 107: {
                klass = GroupData.class;
            }
        }
        this.state = 11;
        if (klass == null) {
            return;
        }
        this.currentLoader = new RefreshExperimenterDataLoader(this.component, klass, nodes, type, id);
        this.currentLoader.load();
    }

    void fireCountExperimenterImages(TreeImageSet expNode) {
        List n = expNode.getChildrenDisplay();
        Iterator i = n.iterator();
        HashSet<Integer> indexes = new HashSet<Integer>();
        switch (this.getBrowserType()) {
            case 101: {
                while (i.hasNext()) {
                    TreeImageTimeSet node = (TreeImageTimeSet)i.next();
                    indexes.add(node.getType());
                }
                break;
            }
            case 102: 
            case 104: {
                while (i.hasNext()) {
                    Object o = i.next();
                    if (!(o instanceof TreeFileSet)) continue;
                    TreeFileSet file = (TreeFileSet)o;
                    indexes.add(file.getType());
                }
                break;
            }
        }
        if (indexes.size() == 0) {
            return;
        }
        if (this.containersManagerWithIndexes == null) {
            this.containersManagerWithIndexes = new ContainersManager(indexes);
        }
        this.state = 13;
        this.numberLoader = new ExperimenterImagesCounter(this.component, expNode, n);
        this.numberLoader.load();
    }

    boolean setExperimenterCount(TreeImageSet expNode, int index) {
        if (this.containersManagerWithIndexes == null) {
            return true;
        }
        this.containersManagerWithIndexes.setItem(index);
        if (this.containersManagerWithIndexes.isDone()) {
            if (this.state == 13 && this.containersManager == null) {
                this.state = 15;
            }
            this.containersManagerWithIndexes = null;
            this.numberLoader = null;
            return true;
        }
        return false;
    }

    void removeDisplay(TreeImageDisplay foundNode) {
        if (foundNode != null) {
            this.selectedNodes.remove(foundNode);
        }
    }

    void browser(TreeImageDisplay node) {
        if (node == null) {
            return;
        }
        Object object = node.getUserObject();
        if (object instanceof ImageData) {
            this.parent.browse(node, true);
        } else if (object instanceof PlateData) {
            if (!node.hasChildrenDisplay()) {
                this.parent.browse(node, true);
            }
        } else if (object instanceof PlateAcquisitionData) {
            this.parent.browse(node, true);
        }
    }

    void openFile(TreeImageDisplay node) {
        if (node == null) {
            return;
        }
        FileAnnotationData data = (FileAnnotationData)node.getUserObject();
        EditFileEvent evt = new EditFileEvent(data);
        TreeViewerAgent.getRegistry().getEventBus().post(evt);
    }

    void setImportedImages(Collection nodes) {
        if (nodes == null) {
            return;
        }
        this.state = 15;
        Iterator i = nodes.iterator();
        this.importedImages = new HashMap<String, Object>();
        while (i.hasNext()) {
            ImageData img = (ImageData)i.next();
            this.importedImages.put(EditorUtil.getObjectName(img.getName()), img);
        }
    }

    void setRepositories(FSFileSystemView systemView) {
        if (this.views == null) {
            this.views = new HashMap<Long, FSFileSystemView>();
        }
        this.views.put(systemView.getUserID(), systemView);
        this.state = 15;
    }

    FSFileSystemView getRepositories(long userID) {
        return this.views.get(userID);
    }

    void addImportedImages(List nodes) {
        for (ImageData img : nodes) {
            this.importedImages.put(EditorUtil.getObjectName(img.getName()), img);
        }
    }

    void addImportedImage(ImageData image) {
        if (this.importedImages != null) {
            this.importedImages.put(EditorUtil.getObjectName(image.getName()), image);
        }
    }

    ImageData getImportedImage(String fileName) {
        if (this.importedImages == null) {
            return null;
        }
        String name = EditorUtil.getObjectName(fileName);
        Object ho = this.importedImages.get(name);
        if (ho instanceof ImageData) {
            return (ImageData)ho;
        }
        return null;
    }

    boolean isFileImported(String path) {
        if (this.importedImages == null) {
            return false;
        }
        String name = EditorUtil.getObjectName(path);
        return this.importedImages.get(name) != null;
    }

    void fireFilesCheck(List<TreeImageNode> nodes) {
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        FilesChecker loader = new FilesChecker(this.component, nodes);
        loader.load();
    }

    void delete() {
        DeleteCmd c = new DeleteCmd(this.component);
        c.execute();
    }

    boolean isSupportedImageFormat(String path) {
        return false;
    }

    DataObject[] getFilesData(long userID, FileData dir) {
        FSFileSystemView fs = this.getRepositories(userID);
        DataObject[] files = null;
        try {
            files = fs.getFiles(dir, false);
        }
        catch (FSAccessException e) {
            LogMessage msg = new LogMessage();
            msg.print("Cannot retrieve the files.");
            msg.print(e);
            TreeViewerAgent.getRegistry().getLogger().error((Object)this, msg);
        }
        return files;
    }
}

