/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.finder;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import org.openmicroscopy.shoola.agents.treeviewer.finder.CloseAction;
import org.openmicroscopy.shoola.agents.treeviewer.finder.FilterMenuAction;
import org.openmicroscopy.shoola.agents.treeviewer.finder.FindAction;
import org.openmicroscopy.shoola.agents.treeviewer.finder.FindNextAction;
import org.openmicroscopy.shoola.agents.treeviewer.finder.FindPreviousAction;
import org.openmicroscopy.shoola.agents.treeviewer.finder.Finder;
import org.openmicroscopy.shoola.agents.treeviewer.finder.FinderAction;
import org.openmicroscopy.shoola.agents.treeviewer.finder.FinderUI;
import org.openmicroscopy.shoola.agents.treeviewer.finder.HighlightAction;

class FinderControl
implements PropertyChangeListener {
    static final Integer CLOSE = 0;
    static final Integer FIND = 1;
    static final Integer FIND_NEXT = 2;
    static final Integer FIND_PREVIOUS = 3;
    static final Integer HIGHLIGHT = 4;
    static final Integer FILTER_MENU = 5;
    private Finder model;
    private FinderUI view;
    private Map<Integer, FinderAction> actionsMap;

    private void createActions() {
        this.actionsMap.put(CLOSE, new CloseAction(this.model));
        this.actionsMap.put(FIND, new FindAction(this.model));
        this.actionsMap.put(FIND_NEXT, new FindNextAction(this.model));
        this.actionsMap.put(FIND_PREVIOUS, new FindPreviousAction(this.model));
        this.actionsMap.put(HIGHLIGHT, new HighlightAction(this.model));
        this.actionsMap.put(FILTER_MENU, new FilterMenuAction(this.model));
    }

    FinderControl(Finder model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        model.addPropertyChangeListener("retrieved", this);
        this.actionsMap = new HashMap<Integer, FinderAction>();
        this.createActions();
    }

    void initialize(FinderUI view) {
        this.view = view;
    }

    Action getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String name = pce.getPropertyName();
        if (name.equals("finderVisible")) {
            this.model.setDisplay((Boolean)pce.getNewValue());
        } else if (name.equals("retrieved")) {
            this.view.setMessage((Integer)pce.getNewValue());
        } else if (name.equals("selection")) {
            this.view.setTextToFind((String)pce.getNewValue());
        }
    }
}

