/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.util.DataPane;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.SelectionWizardUI;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.GroupData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExperimenterPane
extends DataPane {
    private JPasswordField passwordField;
    private Map<String, JTextField> items;
    private Map<String, String> details;
    private JCheckBox adminBox;
    private JCheckBox activeBox;
    private JCheckBox ownerBox;
    private JButton groupOwner;
    private SelectionWizardUI selectionComponent;
    private boolean passwordRequired;

    private void initComponents(Collection available, Collection selected) {
        this.passwordField = new JPasswordField();
        this.passwordField.getDocument().addDocumentListener(this);
        this.details = EditorUtil.convertExperimenter(null);
        this.details = new LinkedHashMap<String, String>();
        this.details.put("Login Name", "");
        this.details.put("First Name", "");
        this.details.put("Middle Name", "");
        this.details.put("Last Name", "");
        this.details.put("E-mail", "");
        this.details.put("Institution", "");
        this.items = new LinkedHashMap<String, JTextField>();
        this.activeBox = new JCheckBox();
        this.activeBox.setSelected(true);
        this.activeBox.setEnabled(!this.passwordRequired);
        this.adminBox = new JCheckBox();
        this.ownerBox = new JCheckBox();
        this.ownerBox.setEnabled(this.passwordRequired);
        this.ownerBox.setSelected(!this.passwordRequired);
        IconManager icons = IconManager.getInstance();
        this.groupOwner = new JButton(icons.getIcon(55));
        this.groupOwner.setToolTipText("Select an existing user as owner");
        this.groupOwner.setVisible(this.passwordRequired);
        if (available == null && selected == null) {
            return;
        }
        long userID = TreeViewerAgent.getUserDetails().getId();
        this.selectionComponent = new SelectionWizardUI(available, selected, GroupData.class, userID);
    }

    private JPanel buildContentPanel() {
        JComponent label;
        JPanel content = new JPanel();
        Iterator<Map.Entry<String, String>> i = this.details.entrySet().iterator();
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        while (i.hasNext()) {
            ++c.gridy;
            c.gridx = 0;
            Map.Entry<String, String> entry = i.next();
            String key = entry.getKey();
            String value = entry.getValue();
            JTextField area = new JTextField(value);
            area.setEditable(true);
            if ("Login Name".equals(key)) {
                label = EditorUtil.getLabel(key, true);
                area = this.nameArea;
            } else {
                label = UIUtilities.setTextFont(key);
            }
            this.items.put(key, area);
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            content.add((Component)label, c);
            ++c.gridx;
            content.add(Box.createHorizontalStrut(5), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)area, c);
        }
        c.gridx = 0;
        ++c.gridy;
        label = EditorUtil.getLabel("Password", this.passwordRequired);
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)label, c);
        ++c.gridx;
        content.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)this.passwordField, c);
        c.gridx = 0;
        ++c.gridy;
        label = EditorUtil.getLabel("Group's owner", false);
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)label, c);
        ++c.gridx;
        content.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)this.ownerBox, c);
        if (this.adminBox.isVisible()) {
            c.gridx = 0;
            ++c.gridy;
            label = EditorUtil.getLabel("Administrator", false);
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            content.add((Component)label, c);
            ++c.gridx;
            content.add(Box.createHorizontalStrut(5), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)this.adminBox, c);
        }
        c.gridx = 0;
        ++c.gridy;
        content.add(Box.createHorizontalStrut(10), c);
        ++c.gridy;
        label = UIUtilities.setTextFont("* indicates the required fields.", 2);
        label.setForeground(UIUtilities.REQUIRED_FIELDS_COLOR);
        c.weightx = 0.0;
        content.add((Component)label, c);
        return content;
    }

    private void buildGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = -1;
        c.weightx = 1.0;
        this.add((Component)this.buildContentPanel(), c);
        if (this.selectionComponent != null) {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.add(UIUtilities.buildComponentPanel(UIUtilities.setTextFont("Select the group(s) to add the Experimenter to")));
            p.add(this.selectionComponent);
            ++c.gridy;
            this.add((Component)new JSeparator(), c);
            ++c.gridy;
            this.add((Component)p, c);
        }
    }

    ExperimenterPane(boolean passwordRequired, Collection<DataObject> available, Collection<DataObject> selected) {
        this.passwordRequired = passwordRequired;
        this.initComponents(available, selected);
        this.buildGUI();
    }

    Map<ExperimenterData, UserCredentials> getObjectToSave() {
        JTextField field = this.items.get("Login Name");
        String s = field.getText().trim();
        ExperimenterData data = new ExperimenterData();
        field = this.items.get("First Name");
        String value = field.getText().trim();
        if (value.length() == 0) {
            value = s;
        }
        data.setFirstName(value);
        field = this.items.get("Last Name");
        value = field.getText().trim();
        if (value.length() == 0) {
            value = s;
        }
        data.setLastName(value);
        field = this.items.get("Middle Name");
        field = this.items.get("E-mail");
        data.setEmail(field.getText().trim());
        field = this.items.get("Institution");
        data.setInstitution(field.getText().trim());
        HashMap<ExperimenterData, UserCredentials> m = new HashMap<ExperimenterData, UserCredentials>();
        StringBuffer buf = new StringBuffer();
        buf.append(this.passwordField.getPassword());
        if (s == null || s.length() == 0) {
            return m;
        }
        String pass = buf.toString();
        if (this.passwordRequired && (pass == null || pass.length() == 0)) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Create Experimenter", "Please Enter a Password");
            return m;
        }
        UserCredentials uc = new UserCredentials(s, pass);
        uc.setAdministrator(this.adminBox.isSelected());
        uc.setOwner(this.ownerBox.isSelected());
        m.put(data, uc);
        return m;
    }

    List<GroupData> getSelectedGroups() {
        Collection<Object> l;
        ArrayList<GroupData> groups = new ArrayList<GroupData>();
        if (this.selectionComponent != null && (l = this.selectionComponent.getSelection()) != null) {
            for (Object o : l) {
                if (!(o instanceof GroupData)) continue;
                groups.add((GroupData)o);
            }
        }
        return groups;
    }
}

