/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class PasswordDialog
extends JDialog
implements ActionListener,
DocumentListener {
    public static final String RESET_PASSWORD_PROPERTY = "resetPassword";
    private static final String TITLE = "Reset Password";
    private static final String TEXT = "Reset the password of the selected experimenters.";
    private static final int CANCEL = 0;
    private static final int SAVE = 1;
    private JButton cancelButton;
    private JButton saveButton;
    private JPasswordField field;

    private void setProperties() {
        this.setModal(true);
        this.setTitle(TITLE);
        this.setResizable(false);
    }

    private void initComponents() {
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand("0");
        this.cancelButton.addActionListener(this);
        this.saveButton = new JButton("OK");
        this.saveButton.setActionCommand("1");
        this.saveButton.addActionListener(this);
        this.saveButton.setEnabled(false);
        this.field = new JPasswordField(40);
        this.field.getDocument().addDocumentListener(this);
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.add(this.saveButton);
        bar.add(Box.createRigidArea(UIUtilities.H_SPACER_SIZE));
        bar.add(this.cancelButton);
        bar.add(Box.createRigidArea(UIUtilities.H_SPACER_SIZE));
        return UIUtilities.buildComponentPanelRight(bar);
    }

    private JPanel buildBody() {
        JPanel p = new JPanel();
        double[][] size = new double[][]{{-1.0, -1.0}, {-2.0, -2.0}};
        p.setLayout((LayoutManager)new TableLayout((double[][])size));
        p.add((Component)UIUtilities.setTextFont("Password:"), "0, 0");
        p.add((Component)this.field, "0, 1, 1, 1");
        return UIUtilities.buildComponentPanel(p);
    }

    private void buildGUI() {
        IconManager icons = IconManager.getInstance();
        TitlePanel tp = new TitlePanel(TITLE, TEXT, icons.getIcon(123));
        Container c = this.getContentPane();
        c.setLayout(new BoxLayout(c, 1));
        c.add((Component)((Object)tp), "North");
        c.add((Component)this.buildBody(), "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void save() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.field.getPassword());
        this.firePropertyChange(RESET_PASSWORD_PROPERTY, null, buf.toString());
        this.close();
    }

    public PasswordDialog(JFrame owner) {
        super(owner);
        this.setProperties();
        this.initComponents();
        this.buildGUI();
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.close();
                break;
            }
            case 1: {
                this.save();
            }
        }
    }

    public void insertUpdate(DocumentEvent e) {
        if (this.field == null) {
            return;
        }
        char[] values = this.field.getPassword();
        this.saveButton.setEnabled(values != null && values.length > 0);
    }

    public void removeUpdate(DocumentEvent e) {
        if (this.field == null) {
            return;
        }
        char[] values = this.field.getPassword();
        this.saveButton.setEnabled(values != null && values.length > 0);
    }

    public void changedUpdate(DocumentEvent e) {
    }
}

