/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ui.RollOverThumbnailManager;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ExperimenterData;

public class ViewedByItem
extends JMenuItem
implements ActionListener {
    public static final int MAX_ICON_SIZE = 32;
    public static final String VIEWED_BY_PROPERTY = "viewedBy";
    private ExperimenterData experimenter;
    private RndProxyDef rndDef;
    private BufferedImage image;
    private boolean asMenuItem;

    private void rollOver() {
        if (this.image == null) {
            return;
        }
        RollOverThumbnailManager.rollOverDisplay(this.image, this.getBounds(), this.getLocationOnScreen(), this.getToolTipText());
    }

    public ViewedByItem(ExperimenterData experimenter, RndProxyDef rndDef) {
        this(experimenter, rndDef, true);
    }

    public ViewedByItem(ExperimenterData experimenter, RndProxyDef rndDef, boolean asMenuItem) {
        this.experimenter = experimenter;
        this.rndDef = rndDef;
        this.asMenuItem = asMenuItem;
        if (!asMenuItem) {
            Font f = this.getFont();
            this.setFont(f.deriveFont(f.getStyle(), f.getSize() - 3));
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setIconTextGap(0);
            this.setText(experimenter.getLastName());
        } else {
            Dimension d = new Dimension(34, 34);
            this.setPreferredSize(d);
            this.setSize(d);
            this.setText(EditorUtil.formatExperimenter(experimenter));
        }
        ArrayList<String> l = new ArrayList<String>();
        l.add("Viewed by: " + this.getText());
        Timestamp time = rndDef.getLastModified();
        if (time != null) {
            l.add("Last modified: " + UIUtilities.formatShortDateTime(time));
        }
        this.setToolTipText(UIUtilities.formatToolTipText(l));
        this.addActionListener(this);
    }

    public ExperimenterData getExperimenter() {
        return this.experimenter;
    }

    public RndProxyDef getRndDef() {
        return this.rndDef;
    }

    public long getExperimenterID() {
        return this.experimenter.getId();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        if (image == null) {
            return;
        }
        this.setIcon(new ImageIcon(Factory.scaleBufferedImage(image, 32)));
        this.revalidate();
        if (!this.asMenuItem) {
            this.addMouseListener(new MouseAdapter(){

                public void mouseExited(MouseEvent e) {
                    RollOverThumbnailManager.stopOverDisplay();
                }

                public void mouseEntered(MouseEvent e) {
                    ViewedByItem.this.rollOver();
                }
            });
        }
        this.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        this.firePropertyChange(VIEWED_BY_PROPERTY, null, this.rndDef);
    }
}

