/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.browser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageNode;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.GroupData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerFinder
implements TreeImageDisplayVisitor {
    private Set<TreeImageSet> containerNodes;
    private Set<DataObject> containers;
    private List<Class> rootType;

    public ContainerFinder(Class rootType) {
        this.rootType = new ArrayList<Class>();
        this.rootType.add(rootType);
        this.containerNodes = new HashSet<TreeImageSet>();
        this.containers = new HashSet<DataObject>();
    }

    public ContainerFinder(List<Class> rootType) {
        this.rootType = rootType;
        this.containerNodes = new HashSet<TreeImageSet>();
        this.containers = new HashSet<DataObject>();
    }

    public Set<TreeImageSet> getContainerNodes() {
        return this.containerNodes;
    }

    public Set<DataObject> getContainers() {
        return this.containers;
    }

    @Override
    public void visit(TreeImageNode node) {
    }

    @Override
    public void visit(TreeImageSet node) {
        Object userObject = node.getUserObject();
        if (userObject != null && this.rootType.contains(userObject.getClass())) {
            TagAnnotationData tag;
            String ns;
            if (userObject instanceof DatasetData || userObject instanceof GroupData || userObject instanceof ExperimenterData) {
                this.containerNodes.add(node);
                this.containers.add((DataObject)userObject);
            } else if (userObject instanceof TagAnnotationData && !"openmicroscopy.org/omero/insight/tagset".equals(ns = (tag = (TagAnnotationData)userObject).getNameSpace())) {
                this.containerNodes.add(node);
                this.containers.add((DataObject)userObject);
            }
        }
    }
}

