/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.finder;

import org.openmicroscopy.shoola.agents.util.finder.Finder;
import org.openmicroscopy.shoola.agents.util.finder.FinderFactory;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.DataHandlerView;
import org.openmicroscopy.shoola.env.data.views.MetadataHandlerView;
import org.openmicroscopy.shoola.env.log.LogMessage;
import pojos.AnnotationData;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.ProjectData;

public abstract class FinderLoader
extends DSCallAdapter {
    public static final int TAGS = 0;
    public static final int IMAGES = 1;
    public static final int ANNOTATIONS = 2;
    public static final int PROJECTS = 3;
    public static final int DATASETS = 4;
    protected Finder viewer;
    protected final Registry registry;
    protected final DataHandlerView dhView;
    protected final MetadataHandlerView mhView;

    protected Class checkType(int value) {
        switch (value) {
            case 1: {
                return ImageData.class;
            }
            case 2: {
                return AnnotationData.class;
            }
            case 3: {
                return ProjectData.class;
            }
            case 4: {
                return DatasetData.class;
            }
        }
        throw new IllegalArgumentException("Type not supported.");
    }

    protected String convertType(Class type) {
        if (ImageData.class.equals((Object)type)) {
            return "Images";
        }
        return "";
    }

    protected FinderLoader(Finder viewer) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        this.registry = FinderFactory.getRegistry();
        this.viewer = viewer;
        this.dhView = (DataHandlerView)this.registry.getDataServicesView(DataHandlerView.class);
        this.mhView = (MetadataHandlerView)this.registry.getDataServicesView(MetadataHandlerView.class);
    }

    protected ExperimenterData getUserDetails() {
        return (ExperimenterData)this.registry.lookup("/current_user/details");
    }

    public void handleNullResult() {
        this.handleException(new Exception("No data available."));
    }

    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
        this.registry.getUserNotifier().notifyInfo("Data Retrieval Cancellation", info);
        this.viewer.setStatus("", false);
    }

    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
        this.viewer.setStatus("", false);
    }

    public abstract void load();

    public abstract void cancel();
}

