/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import org.openmicroscopy.shoola.agents.util.ui.ChannelButtonPopupMenu;
import org.openmicroscopy.shoola.util.ui.ColouredButton;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ChannelButton
extends ColouredButton
implements ActionListener {
    public static final Dimension DEFAULT_MIN_SIZE = new Dimension(30, 30);
    public static final Dimension DEFAULT_MAX_SIZE = new Dimension(60, 30);
    public static final String CHANNEL_SELECTED_PROPERTY = "channelSelected";
    public static final String CHANNEL_OVERLAY_PROPERTY = "channelOverlay";
    public static final String CHANNEL_COLOUR_PROPERTY = "channelColour";
    public static final int MIN_FONT_SIZE = 10;
    private static final String DESCRIPTION = "Toggle channel on/off.";
    protected final int index;
    private ChannelButtonPopupMenu popupMenu;
    private boolean rightClickSupported;
    private boolean overlay;

    private final void setChannelSelected() {
        if (!this.isEnabled()) {
            return;
        }
        Boolean value = true;
        if (this.isSelected()) {
            value = false;
        }
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>(1);
        map.put(this.index, value);
        if (this.overlay) {
            this.firePropertyChange(CHANNEL_OVERLAY_PROPERTY, null, map);
        } else {
            this.firePropertyChange(CHANNEL_SELECTED_PROPERTY, null, map);
        }
    }

    private void onClick(MouseEvent e) {
        boolean mask;
        boolean bl = mask = e.isControlDown() || e.isMetaDown();
        if (e.getButton() == 1 && !mask) {
            this.setChannelSelected();
        } else if (e.getButton() == 2 || mask) {
            this.onReleased(e);
        }
    }

    private void onReleased(MouseEvent e) {
        if (e.isPopupTrigger() && this.rightClickSupported) {
            if (this.popupMenu == null) {
                this.popupMenu = new ChannelButtonPopupMenu(this);
            }
            this.popupMenu.show(this, e.getX(), e.getY());
        }
    }

    private Dimension setComponentSize(int decrease) {
        Font f = this.getFont();
        Font fNew = f.deriveFont(f.getStyle(), f.getSize() - 1);
        this.setFont(fNew);
        String text = this.getText();
        FontMetrics fm = this.getFontMetrics(fNew);
        int width = fm.stringWidth(text) + 4;
        Dimension d = DEFAULT_MIN_SIZE;
        if (width > ChannelButton.DEFAULT_MIN_SIZE.width && width < ChannelButton.DEFAULT_MAX_SIZE.width) {
            d = new Dimension(width + 6, ChannelButton.DEFAULT_MIN_SIZE.height);
        } else if (width >= ChannelButton.DEFAULT_MAX_SIZE.width) {
            if (fNew.getSize() > 10) {
                return this.setComponentSize(decrease - 1);
            }
            String s = "";
            int n = text.length() - 1;
            ArrayList<Character> l = new ArrayList<Character>();
            while (fm.stringWidth(s) + 4 < ChannelButton.DEFAULT_MAX_SIZE.width - 2) {
                char ch = text.charAt(n);
                s = s + ch;
                l.add(Character.valueOf(ch));
                --n;
            }
            Collections.reverse(l);
            Iterator i = l.iterator();
            s = "..";
            while (i.hasNext()) {
                s = s + i.next();
            }
            this.setText(s);
            return this.setComponentSize(decrease);
        }
        return d;
    }

    private String parseText(String text) {
        if (text == null || text.length() == 0) {
            return "";
        }
        String[] values = text.split("\\(");
        if (values == null || values.length == 0) {
            return text;
        }
        return values[0].trim();
    }

    public ChannelButton(String text, Color color, int index, boolean selected) {
        super(text, color);
        this.setText(this.parseText(text));
        this.index = index;
        this.rightClickSupported = true;
        this.setSelected(selected);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ChannelButton.this.onClick(e);
            }

            public void mouseReleased(MouseEvent e) {
                ChannelButton.this.onReleased(e);
            }
        });
        ArrayList<String> l = new ArrayList<String>(2);
        if (text != null && text.length() > 0) {
            l.add(text);
        }
        l.add(DESCRIPTION);
        this.setToolTipText(UIUtilities.formatToolTipText(l));
        this.setPreferredSize(this.setComponentSize(0));
    }

    public ChannelButton(String text, Color color, int index) {
        this(text, color, index, false);
    }

    public void setOverlay(boolean overlay) {
        this.overlay = overlay;
    }

    void showColorPicker() {
        this.firePropertyChange(CHANNEL_COLOUR_PROPERTY, null, (Object)this.index);
    }

    public int getChannelIndex() {
        return this.index;
    }

    public void setRightClickSupported(boolean value) {
        this.rightClickSupported = value;
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (selected) {
            this.setBorder(BorderFactory.createLoweredBevelBorder());
        } else {
            this.setBorder(BorderFactory.createRaisedBevelBorder());
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.setChannelSelected();
    }
}

